/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.ses.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.ses.runtime.SesClientProducer;
import io.quarkus.amazon.ses.runtime.SesConfig;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.SesAsyncClientBuilder;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;

@Recorder
public class SesRecorder {
    public RuntimeValue<SyncHttpClientConfig> getSyncConfig(SesConfig config) {
        return new RuntimeValue((Object)config.syncClient);
    }

    public RuntimeValue<NettyHttpClientConfig> getAsyncConfig(SesConfig config) {
        return new RuntimeValue((Object)config.asyncClient);
    }

    public RuntimeValue<AwsConfig> getAwsConfig(SesConfig config) {
        return new RuntimeValue((Object)config.aws);
    }

    public RuntimeValue<SdkConfig> getSdkConfig(SesConfig config) {
        return new RuntimeValue((Object)config.sdk);
    }

    public RuntimeValue<AwsClientBuilder> createSyncBuilder(SesConfig config, RuntimeValue<SdkHttpClient.Builder> transport) {
        SesClientBuilder builder = SesClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(SesConfig config, RuntimeValue<SdkAsyncHttpClient.Builder> transport) {
        SesAsyncClientBuilder builder = SesAsyncClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<SesClient> buildClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        SesClientProducer producer = (SesClientProducer)beanContainer.instance(SesClientProducer.class, new Annotation[0]);
        producer.setSyncConfiguredBuilder((SesClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.client());
    }

    public RuntimeValue<SesAsyncClient> buildAsyncClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        SesClientProducer producer = (SesClientProducer)beanContainer.instance(SesClientProducer.class, new Annotation[0]);
        producer.setAsyncConfiguredBuilder((SesAsyncClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.asyncClient());
    }
}

