/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.ses.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.SesAsyncClientBuilder;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;

@ApplicationScoped
public class SesClientProducer {
    private volatile SesClientBuilder syncConfiguredBuilder;
    private volatile SesAsyncClientBuilder asyncConfiguredBuilder;
    private SesClient client;
    private SesAsyncClient asyncClient;

    @Produces
    @ApplicationScoped
    public SesClient client() {
        this.client = (SesClient)this.syncConfiguredBuilder.build();
        return this.client;
    }

    @Produces
    @ApplicationScoped
    public SesAsyncClient asyncClient() {
        this.asyncClient = (SesAsyncClient)this.asyncConfiguredBuilder.build();
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }

    public void setSyncConfiguredBuilder(SesClientBuilder syncConfiguredBuilder) {
        this.syncConfiguredBuilder = syncConfiguredBuilder;
    }

    public void setAsyncConfiguredBuilder(SesAsyncClientBuilder asyncConfiguredBuilder) {
        this.asyncConfiguredBuilder = asyncConfiguredBuilder;
    }
}

