/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.EventDataAssert;
import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;

public final class OpenTelemetryAssertions
extends Assertions {
    public static AttributesAssert assertThat(Attributes attributes) {
        return new AttributesAssert(attributes);
    }

    public static SpanDataAssert assertThat(SpanData spanData) {
        return new SpanDataAssert(spanData);
    }

    public static EventDataAssert assertThat(EventData eventData) {
        return new EventDataAssert(eventData);
    }

    public static Map.Entry<AttributeKey<String>, String> attributeEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<String>, String>(AttributeKey.stringKey((String)key), value);
    }

    public static Map.Entry<AttributeKey<Boolean>, Boolean> attributeEntry(String key, boolean value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Boolean>, Boolean>(AttributeKey.booleanKey((String)key), value);
    }

    public static Map.Entry<AttributeKey<Long>, Long> attributeEntry(String key, long value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Long>, Long>(AttributeKey.longKey((String)key), value);
    }

    public static Map.Entry<AttributeKey<Double>, Double> attributeEntry(String key, double value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Double>, Double>(AttributeKey.doubleKey((String)key), value);
    }

    public static Map.Entry<AttributeKey<List<String>>, List<String>> attributeEntry(String key, String ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<String>>, List<String>>(AttributeKey.stringArrayKey((String)key), Arrays.asList(value));
    }

    public static Map.Entry<AttributeKey<List<Boolean>>, List<Boolean>> attributeEntry(String key, boolean ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Boolean>>, List<Boolean>>(AttributeKey.booleanArrayKey((String)key), OpenTelemetryAssertions.toList(value));
    }

    public static Map.Entry<AttributeKey<List<Long>>, List<Long>> attributeEntry(String key, long ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Long>>, List<Long>>(AttributeKey.longArrayKey((String)key), Arrays.stream(value).boxed().collect(Collectors.toList()));
    }

    public static Map.Entry<AttributeKey<List<Double>>, List<Double>> attributeEntry(String key, double ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Double>>, List<Double>>(AttributeKey.doubleArrayKey((String)key), Arrays.stream(value).boxed().collect(Collectors.toList()));
    }

    private static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    private OpenTelemetryAssertions() {
    }
}

