/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanEventMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanLinkMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanStatusMarshaler;
import io.opentelemetry.proto.trace.v1.internal.Span;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

final class SpanMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String traceId;
    private final byte[] traceStateUtf8;
    private final String spanId;
    @Nullable
    private final String parentSpanId;
    private final byte[] nameUtf8;
    private final ProtoEnumInfo spanKind;
    private final long startEpochNanos;
    private final long endEpochNanos;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;
    private final SpanEventMarshaler[] spanEventMarshalers;
    private final int droppedEventsCount;
    private final SpanLinkMarshaler[] spanLinkMarshalers;
    private final int droppedLinksCount;
    private final SpanStatusMarshaler spanStatusMarshaler;

    static SpanMarshaler create(SpanData spanData) {
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createForAttributes(spanData.getAttributes());
        SpanEventMarshaler[] spanEventMarshalers = SpanEventMarshaler.createRepeated(spanData.getEvents());
        SpanLinkMarshaler[] spanLinkMarshalers = SpanLinkMarshaler.createRepeated(spanData.getLinks());
        String parentSpanId = spanData.getParentSpanContext().isValid() ? spanData.getParentSpanContext().getSpanId() : null;
        TraceState traceState = spanData.getSpanContext().getTraceState();
        byte[] traceStateUtf8 = traceState.isEmpty() ? EMPTY_BYTES : W3CTraceContextEncoding.encodeTraceState((TraceState)traceState).getBytes(StandardCharsets.UTF_8);
        return new SpanMarshaler(spanData.getSpanContext().getTraceId(), spanData.getSpanContext().getSpanId(), traceStateUtf8, parentSpanId, MarshalerUtil.toBytes((String)spanData.getName()), SpanMarshaler.toProtoSpanKind(spanData.getKind()), spanData.getStartEpochNanos(), spanData.getEndEpochNanos(), attributeMarshalers, spanData.getTotalAttributeCount() - spanData.getAttributes().size(), spanEventMarshalers, spanData.getTotalRecordedEvents() - spanData.getEvents().size(), spanLinkMarshalers, spanData.getTotalRecordedLinks() - spanData.getLinks().size(), SpanStatusMarshaler.create(spanData.getStatus()));
    }

    private SpanMarshaler(String traceId, String spanId, byte[] traceStateUtf8, @Nullable String parentSpanId, byte[] nameUtf8, ProtoEnumInfo spanKind, long startEpochNanos, long endEpochNanos, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler) {
        super(SpanMarshaler.calculateSize(traceId, spanId, traceStateUtf8, parentSpanId, nameUtf8, spanKind, startEpochNanos, endEpochNanos, attributeMarshalers, droppedAttributesCount, spanEventMarshalers, droppedEventsCount, spanLinkMarshalers, droppedLinksCount, spanStatusMarshaler));
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceStateUtf8 = traceStateUtf8;
        this.parentSpanId = parentSpanId;
        this.nameUtf8 = nameUtf8;
        this.spanKind = spanKind;
        this.startEpochNanos = startEpochNanos;
        this.endEpochNanos = endEpochNanos;
        this.attributeMarshalers = attributeMarshalers;
        this.droppedAttributesCount = droppedAttributesCount;
        this.spanEventMarshalers = spanEventMarshalers;
        this.droppedEventsCount = droppedEventsCount;
        this.spanLinkMarshalers = spanLinkMarshalers;
        this.droppedLinksCount = droppedLinksCount;
        this.spanStatusMarshaler = spanStatusMarshaler;
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeTraceId(Span.TRACE_ID, this.traceId);
        output.serializeSpanId(Span.SPAN_ID, this.spanId);
        output.serializeString(Span.TRACE_STATE, this.traceStateUtf8);
        output.serializeSpanId(Span.PARENT_SPAN_ID, this.parentSpanId);
        output.serializeString(Span.NAME, this.nameUtf8);
        output.serializeEnum(Span.KIND, this.spanKind);
        output.serializeFixed64(Span.START_TIME_UNIX_NANO, this.startEpochNanos);
        output.serializeFixed64(Span.END_TIME_UNIX_NANO, this.endEpochNanos);
        output.serializeRepeatedMessage(Span.ATTRIBUTES, (Marshaler[])this.attributeMarshalers);
        output.serializeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
        output.serializeRepeatedMessage(Span.EVENTS, (Marshaler[])this.spanEventMarshalers);
        output.serializeUInt32(Span.DROPPED_EVENTS_COUNT, this.droppedEventsCount);
        output.serializeRepeatedMessage(Span.LINKS, (Marshaler[])this.spanLinkMarshalers);
        output.serializeUInt32(Span.DROPPED_LINKS_COUNT, this.droppedLinksCount);
        output.serializeMessage(Span.STATUS, (Marshaler)this.spanStatusMarshaler);
    }

    private static int calculateSize(String traceId, String spanId, byte[] traceStateUtf8, @Nullable String parentSpanId, byte[] nameUtf8, ProtoEnumInfo spanKind, long startEpochNanos, long endEpochNanos, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount, SpanEventMarshaler[] spanEventMarshalers, int droppedEventsCount, SpanLinkMarshaler[] spanLinkMarshalers, int droppedLinksCount, SpanStatusMarshaler spanStatusMarshaler) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId((ProtoFieldInfo)Span.TRACE_ID, (String)traceId);
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)Span.SPAN_ID, (String)spanId);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)Span.TRACE_STATE, (byte[])traceStateUtf8);
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)Span.PARENT_SPAN_ID, (String)parentSpanId);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)Span.NAME, (byte[])nameUtf8);
        size += MarshalerUtil.sizeEnum((ProtoFieldInfo)Span.KIND, (ProtoEnumInfo)spanKind);
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)Span.START_TIME_UNIX_NANO, (long)startEpochNanos);
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)Span.END_TIME_UNIX_NANO, (long)endEpochNanos);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_ATTRIBUTES_COUNT, (int)droppedAttributesCount);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.EVENTS, (Marshaler[])spanEventMarshalers);
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_EVENTS_COUNT, (int)droppedEventsCount);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.LINKS, (Marshaler[])spanLinkMarshalers);
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_LINKS_COUNT, (int)droppedLinksCount);
        return size += MarshalerUtil.sizeMessage((ProtoFieldInfo)Span.STATUS, (Marshaler)spanStatusMarshaler);
    }

    static ProtoEnumInfo toProtoSpanKind(SpanKind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.SPAN_KIND_UNSPECIFIED;
    }
}

