/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo.util;

import io.opensergo.proto.common.v1.TimeUnit;
import io.opensergo.util.AssertUtils;

public final class TimeUnitUtils {
    public static long convertToMillis(long t, TimeUnit fromUnit) {
        AssertUtils.assertNotNull((Object)fromUnit, "fromUnit cannot be null");
        switch (fromUnit) {
            case DAY: {
                return java.util.concurrent.TimeUnit.DAYS.toMillis(t);
            }
            case HOUR: {
                return java.util.concurrent.TimeUnit.HOURS.toMillis(t);
            }
            case MINUTE: {
                return java.util.concurrent.TimeUnit.MINUTES.toMillis(t);
            }
            case SECOND: {
                return java.util.concurrent.TimeUnit.SECONDS.toMillis(t);
            }
            case MILLISECOND: {
                return java.util.concurrent.TimeUnit.MILLISECONDS.toMillis(t);
            }
        }
        throw new IllegalArgumentException("unknown time unit: " + (Object)((Object)fromUnit));
    }

    private TimeUnitUtils() {
    }
}

