/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo.subscribe;

import io.opensergo.subscribe.OpenSergoConfigSubscriber;
import io.opensergo.subscribe.SubscribeKey;
import io.opensergo.util.AssertUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SubscribeRegistry {
    private ConcurrentMap<SubscribeKey, List<OpenSergoConfigSubscriber>> subscriberMap = new ConcurrentHashMap<SubscribeKey, List<OpenSergoConfigSubscriber>>();

    public void registerSubscriber(SubscribeKey key, OpenSergoConfigSubscriber subscriber) {
        AssertUtils.assertNotNull(key, "subscribeKey cannot be null");
        AssertUtils.assertNotNull(subscriber, "subscriber cannot be null");
        List list = this.subscriberMap.computeIfAbsent(key, v -> new CopyOnWriteArrayList());
        list.add(subscriber);
    }

    public List<OpenSergoConfigSubscriber> getSubscribersOf(SubscribeKey key) {
        if (key == null) {
            return null;
        }
        return (List)this.subscriberMap.get(key);
    }

    public boolean removeAllSubscribers(SubscribeKey key) {
        return this.subscriberMap.remove(key) != null;
    }
}

