/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo;

import io.opensergo.OpenSergoClient;
import io.opensergo.OpenSergoClientConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OpenSergoClientManager {
    private static volatile OpenSergoClientManager instance;
    private final ConcurrentMap<String, OpenSergoClient> sharedClientCache = new ConcurrentHashMap<String, OpenSergoClient>();

    OpenSergoClientManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenSergoClientManager get() {
        if (instance != null) return instance;
        Class<OpenSergoClientManager> clazz = OpenSergoClientManager.class;
        synchronized (OpenSergoClientManager.class) {
            if (instance != null) return instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return new OpenSergoClientManager();
        }
    }

    private String buildSharedCacheKey(String host, int port) {
        return host + ":" + port;
    }

    public OpenSergoClient getOrCreateClient(String host, int port) {
        return this.getOrCreateClient(host, port, new OpenSergoClientConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSergoClient getOrCreateClient(String host, int port, OpenSergoClientConfig config) {
        String sharedOpenSergoClientKey = this.buildSharedCacheKey(host, port);
        OpenSergoClientManager openSergoClientManager = this;
        synchronized (openSergoClientManager) {
            OpenSergoClient openSergoClient = (OpenSergoClient)this.sharedClientCache.get(sharedOpenSergoClientKey);
            if (openSergoClient != null) {
                return openSergoClient;
            }
            if (config == null) {
                config = new OpenSergoClientConfig();
            }
            openSergoClient = new OpenSergoClient.Builder().endpoint(host, port).openSergoConfig(config).build();
            this.sharedClientCache.putIfAbsent(sharedOpenSergoClientKey, openSergoClient);
            return (OpenSergoClient)this.sharedClientCache.get(sharedOpenSergoClientKey);
        }
    }

    synchronized void clearAllCachedClients() {
        this.sharedClientCache.clear();
    }
}

