/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.udt.nio;

import com.barchart.udt.SocketUDT;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.KindUDT;
import com.barchart.udt.nio.RendezvousChannelUDT;
import com.barchart.udt.nio.SelectorProviderUDT;
import com.barchart.udt.nio.ServerSocketChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerChannelFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.UdtServerChannel;
import io.netty.channel.udt.nio.NioUdtByteAcceptorChannel;
import io.netty.channel.udt.nio.NioUdtByteConnectorChannel;
import io.netty.channel.udt.nio.NioUdtByteRendezvousChannel;
import io.netty.channel.udt.nio.NioUdtMessageAcceptorChannel;
import io.netty.channel.udt.nio.NioUdtMessageConnectorChannel;
import io.netty.channel.udt.nio.NioUdtMessageRendezvousChannel;
import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;

public abstract class NioUdtProvider {
    public static final ServerChannelFactory<UdtServerChannel> BYTE_ACCEPTOR = new NioUdtServerChannelFactory<UdtServerChannel>(TypeUDT.STREAM, KindUDT.ACCEPTOR);
    public static final ChannelFactory<UdtChannel> BYTE_CONNECTOR = new NioUdtChannelFactory<UdtChannel>(TypeUDT.STREAM, KindUDT.CONNECTOR);
    public static final SelectorProvider BYTE_PROVIDER = SelectorProviderUDT.STREAM;
    public static final ChannelFactory<UdtChannel> BYTE_RENDEZVOUS = new NioUdtChannelFactory<UdtChannel>(TypeUDT.STREAM, KindUDT.RENDEZVOUS);
    public static final ServerChannelFactory<UdtServerChannel> MESSAGE_ACCEPTOR = new NioUdtServerChannelFactory<UdtServerChannel>(TypeUDT.DATAGRAM, KindUDT.ACCEPTOR);
    public static final ChannelFactory<UdtChannel> MESSAGE_CONNECTOR = new NioUdtChannelFactory<UdtChannel>(TypeUDT.DATAGRAM, KindUDT.CONNECTOR);
    public static final SelectorProvider MESSAGE_PROVIDER = SelectorProviderUDT.DATAGRAM;
    public static final ChannelFactory<UdtChannel> MESSAGE_RENDEZVOUS = new NioUdtChannelFactory<UdtChannel>(TypeUDT.DATAGRAM, KindUDT.RENDEZVOUS);
    private final KindUDT kind;
    private final TypeUDT type;

    public static ChannelUDT channelUDT(Channel channel) {
        if (channel instanceof NioUdtByteAcceptorChannel) {
            return ((NioUdtByteAcceptorChannel)channel).javaChannel();
        }
        if (channel instanceof NioUdtByteConnectorChannel) {
            return ((NioUdtByteConnectorChannel)channel).javaChannel();
        }
        if (channel instanceof NioUdtByteRendezvousChannel) {
            return ((NioUdtByteRendezvousChannel)channel).javaChannel();
        }
        if (channel instanceof NioUdtMessageAcceptorChannel) {
            return ((NioUdtMessageAcceptorChannel)channel).javaChannel();
        }
        if (channel instanceof NioUdtMessageConnectorChannel) {
            return ((NioUdtMessageConnectorChannel)channel).javaChannel();
        }
        if (channel instanceof NioUdtMessageRendezvousChannel) {
            return ((NioUdtMessageRendezvousChannel)channel).javaChannel();
        }
        return null;
    }

    protected static ServerSocketChannelUDT newAcceptorChannelUDT(TypeUDT type) {
        try {
            return SelectorProviderUDT.from((TypeUDT)type).openServerSocketChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open channel");
        }
    }

    protected static SocketChannelUDT newConnectorChannelUDT(TypeUDT type) {
        try {
            return SelectorProviderUDT.from((TypeUDT)type).openSocketChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open channel");
        }
    }

    protected static RendezvousChannelUDT newRendezvousChannelUDT(TypeUDT type) {
        try {
            return SelectorProviderUDT.from((TypeUDT)type).openRendezvousChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open channel");
        }
    }

    public static SocketUDT socketUDT(Channel channel) {
        ChannelUDT channelUDT = NioUdtProvider.channelUDT(channel);
        if (channelUDT == null) {
            return null;
        }
        return channelUDT.socketUDT();
    }

    private NioUdtProvider(TypeUDT type, KindUDT kind) {
        this.type = type;
        this.kind = kind;
    }

    public KindUDT kind() {
        return this.kind;
    }

    public TypeUDT type() {
        return this.type;
    }

    private static final class NioUdtServerChannelFactory<T extends UdtServerChannel>
    extends NioUdtProvider
    implements ServerChannelFactory<T> {
        private NioUdtServerChannelFactory(TypeUDT type, KindUDT kind) {
            super(type, kind);
        }

        public T newChannel(EventLoop eventLoop, EventLoopGroup childGroup) {
            switch (this.kind()) {
                case ACCEPTOR: {
                    switch (this.type()) {
                        case DATAGRAM: {
                            return (T)new NioUdtMessageAcceptorChannel(eventLoop, childGroup);
                        }
                        case STREAM: {
                            return (T)new NioUdtByteAcceptorChannel(eventLoop, childGroup);
                        }
                    }
                    throw new IllegalStateException("wrong type: " + this.type());
                }
            }
            throw new IllegalStateException("wrong kind: " + this.kind());
        }
    }

    private static final class NioUdtChannelFactory<T extends UdtChannel>
    extends NioUdtProvider
    implements ChannelFactory<T> {
        private NioUdtChannelFactory(TypeUDT type, KindUDT kind) {
            super(type, kind);
        }

        public T newChannel(EventLoop eventLoop) {
            switch (this.kind()) {
                case ACCEPTOR: {
                    throw new IllegalStateException("wrong kind: " + this.kind());
                }
                case CONNECTOR: {
                    switch (this.type()) {
                        case DATAGRAM: {
                            return (T)new NioUdtMessageConnectorChannel(eventLoop);
                        }
                        case STREAM: {
                            return (T)new NioUdtByteConnectorChannel(eventLoop);
                        }
                    }
                    throw new IllegalStateException("wrong type: " + this.type());
                }
                case RENDEZVOUS: {
                    switch (this.type()) {
                        case DATAGRAM: {
                            return (T)new NioUdtMessageRendezvousChannel(eventLoop);
                        }
                        case STREAM: {
                            return (T)new NioUdtByteRendezvousChannel(eventLoop);
                        }
                    }
                    throw new IllegalStateException("wrong type: " + this.type());
                }
            }
            throw new IllegalStateException("wrong kind: " + this.kind());
        }
    }
}

