/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.server.McpTransportContext;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpLoggableSession;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpSession;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import reactor.core.publisher.Mono;

public class McpAsyncServerExchange {
    private final String sessionId;
    private final McpLoggableSession session;
    private final McpSchema.ClientCapabilities clientCapabilities;
    private final McpSchema.Implementation clientInfo;
    private final McpTransportContext transportContext;
    private static final TypeReference<McpSchema.CreateMessageResult> CREATE_MESSAGE_RESULT_TYPE_REF = new TypeReference<McpSchema.CreateMessageResult>(){};
    private static final TypeReference<McpSchema.ListRootsResult> LIST_ROOTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListRootsResult>(){};
    private static final TypeReference<McpSchema.ElicitResult> ELICITATION_RESULT_TYPE_REF = new TypeReference<McpSchema.ElicitResult>(){};
    public static final TypeReference<Object> OBJECT_TYPE_REF = new TypeReference<Object>(){};

    @Deprecated
    public McpAsyncServerExchange(McpSession session, McpSchema.ClientCapabilities clientCapabilities, McpSchema.Implementation clientInfo) {
        this.sessionId = null;
        if (!(session instanceof McpLoggableSession)) {
            throw new IllegalArgumentException("Expecting session to be a McpLoggableSession instance");
        }
        this.session = (McpLoggableSession)session;
        this.clientCapabilities = clientCapabilities;
        this.clientInfo = clientInfo;
        this.transportContext = McpTransportContext.EMPTY;
    }

    public McpAsyncServerExchange(String sessionId, McpLoggableSession session, McpSchema.ClientCapabilities clientCapabilities, McpSchema.Implementation clientInfo, McpTransportContext transportContext) {
        this.sessionId = sessionId;
        this.session = session;
        this.clientCapabilities = clientCapabilities;
        this.clientInfo = clientInfo;
        this.transportContext = transportContext;
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public McpTransportContext transportContext() {
        return this.transportContext;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public Mono<McpSchema.CreateMessageResult> createMessage(McpSchema.CreateMessageRequest createMessageRequest) {
        if (this.clientCapabilities == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be initialized. Call the initialize method first!"));
        }
        if (this.clientCapabilities.sampling() == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be configured with sampling capabilities"));
        }
        return this.session.sendRequest("sampling/createMessage", createMessageRequest, CREATE_MESSAGE_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ElicitResult> createElicitation(McpSchema.ElicitRequest elicitRequest) {
        if (this.clientCapabilities == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be initialized. Call the initialize method first!"));
        }
        if (this.clientCapabilities.elicitation() == null) {
            return Mono.error((Throwable)new McpError((Object)"Client must be configured with elicitation capabilities"));
        }
        return this.session.sendRequest("elicitation/create", elicitRequest, ELICITATION_RESULT_TYPE_REF);
    }

    public Mono<McpSchema.ListRootsResult> listRoots() {
        return this.listRoots(McpSchema.FIRST_PAGE).expand(result -> result.nextCursor() != null ? this.listRoots(result.nextCursor()) : Mono.empty()).reduce((Object)new McpSchema.ListRootsResult(new ArrayList<McpSchema.Root>(), null), (allRootsResult, result) -> {
            allRootsResult.roots().addAll(result.roots());
            return allRootsResult;
        }).map(result -> new McpSchema.ListRootsResult(Collections.unmodifiableList(result.roots()), result.nextCursor()));
    }

    public Mono<McpSchema.ListRootsResult> listRoots(String cursor) {
        return this.session.sendRequest("roots/list", new McpSchema.PaginatedRequest(cursor), LIST_ROOTS_RESULT_TYPE_REF);
    }

    public Mono<Void> loggingNotification(McpSchema.LoggingMessageNotification loggingMessageNotification) {
        if (loggingMessageNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Logging message must not be null"));
        }
        return Mono.defer(() -> {
            if (this.session.isNotificationForLevelAllowed(loggingMessageNotification.level())) {
                return this.session.sendNotification("notifications/message", loggingMessageNotification);
            }
            return Mono.empty();
        });
    }

    public Mono<Void> progressNotification(McpSchema.ProgressNotification progressNotification) {
        if (progressNotification == null) {
            return Mono.error((Throwable)new McpError((Object)"Progress notification must not be null"));
        }
        return this.session.sendNotification("notifications/progress", progressNotification);
    }

    public Mono<Object> ping() {
        return this.session.sendRequest("ping", null, OBJECT_TYPE_REF);
    }

    void setMinLoggingLevel(McpSchema.LoggingLevel minLoggingLevel) {
        Assert.notNull((Object)minLoggingLevel, "minLoggingLevel must not be null");
        this.session.setMinLoggingLevel(minLoggingLevel);
    }
}

