/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;

class RoundRobin<V> {
    protected volatile Collection<? extends V> collection = Collections.emptyList();
    protected volatile V offset;
    private final BiPredicate<V, V> isEqual;

    public RoundRobin() {
        this((a, b) -> true);
    }

    public RoundRobin(BiPredicate<V, V> hasElementChanged) {
        this.isEqual = hasElementChanged;
    }

    public boolean isConsistent(Collection<? extends V> leader) {
        Collection<V> collection = this.collection;
        if (collection.size() != leader.size()) {
            return false;
        }
        for (V currentElement : collection) {
            boolean found = this.find(leader, currentElement);
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean find(Collection<? extends V> hayStack, V needle) {
        for (V searchedElement : hayStack) {
            if (!searchedElement.equals(needle)) continue;
            return this.isEqual.test(needle, searchedElement);
        }
        return false;
    }

    public void rebuild(Collection<? extends V> leader) {
        this.collection = new ArrayList<V>(leader);
        this.offset = null;
    }

    public V next() {
        Collection<V> collection = this.collection;
        V offset = this.offset;
        if (offset != null) {
            boolean accept = false;
            for (V element : collection) {
                if (element == offset) {
                    accept = true;
                    continue;
                }
                if (!accept) continue;
                this.offset = element;
                return this.offset;
            }
        }
        this.offset = collection.iterator().next();
        return this.offset;
    }
}

