/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Channel;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class LoadReportClient {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final XdsClient.XdsChannel xdsChannel;
    private final EnvoyProtoData.Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final LoadStatsManager loadStatsManager;
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    private LrsStream lrsStream;

    LoadReportClient(String targetName, LoadStatsManager loadStatsManager, XdsClient.XdsChannel xdsChannel, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.loadStatsManager = (LoadStatsManager)Preconditions.checkNotNull((Object)loadStatsManager, (Object)"loadStatsManager");
        this.xdsChannel = (XdsClient.XdsChannel)Preconditions.checkNotNull((Object)xdsChannel, (Object)"xdsChannel");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.retryStopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.node = ((EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node")).toBuilder().addClientFeatures("envoy.lrs.supports_send_all_clusters").build();
        this.logId = InternalLogId.allocate((String)"lrs-client", (String)targetName);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void startLoadReporting() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Starting load reporting RPC");
        this.startLrsRpc();
    }

    void stopLoadReporting() {
        if (!this.started) {
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stopping load reporting RPC");
        if (this.lrsRpcRetryTimer != null) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close((Exception)Status.CANCELLED.withDescription("stop load reporting").asException());
        }
        this.started = false;
    }

    private void startLrsRpc() {
        Preconditions.checkState((this.lrsStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        this.lrsStream = this.xdsChannel.isUseProtocolV3() ? new LrsStreamV3() : new LrsStreamV2();
        this.retryStopwatch.reset().start();
        this.lrsStream.start();
    }

    private static final class LoadStatsResponseData {
        final boolean sendAllClusters;
        final List<String> clusters;
        final long loadReportingIntervalNanos;

        LoadStatsResponseData(boolean sendAllClusters, List<String> clusters, long loadReportingIntervalNanos) {
            this.sendAllClusters = sendAllClusters;
            this.clusters = (List)Preconditions.checkNotNull(clusters, (Object)"clusters");
            this.loadReportingIntervalNanos = loadReportingIntervalNanos;
        }

        boolean getSendAllClusters() {
            return this.sendAllClusters;
        }

        List<String> getClustersList() {
            return this.clusters;
        }

        long getLoadReportingIntervalNanos() {
            return this.loadReportingIntervalNanos;
        }

        static LoadStatsResponseData fromEnvoyProtoV2(LoadStatsResponse loadStatsResponse) {
            return new LoadStatsResponseData(loadStatsResponse.getSendAllClusters(), (List<String>)loadStatsResponse.getClustersList(), Durations.toNanos((Duration)loadStatsResponse.getLoadReportingInterval()));
        }

        static LoadStatsResponseData fromEnvoyProtoV3(io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse loadStatsResponse) {
            return new LoadStatsResponseData(loadStatsResponse.getSendAllClusters(), (List<String>)loadStatsResponse.getClustersList(), Durations.toNanos((Duration)loadStatsResponse.getLoadReportingInterval()));
        }
    }

    private static final class LoadStatsRequestData {
        final EnvoyProtoData.Node node;
        @Nullable
        final List<EnvoyProtoData.ClusterStats> clusterStatsList;

        LoadStatsRequestData(EnvoyProtoData.Node node, @Nullable List<EnvoyProtoData.ClusterStats> clusterStatsList) {
            this.node = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.clusterStatsList = clusterStatsList;
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest toEnvoyProtoV2() {
            LoadStatsRequest.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest.newBuilder().setNode(this.node.toEnvoyProtoNodeV2());
            if (this.clusterStatsList != null) {
                for (EnvoyProtoData.ClusterStats stats : this.clusterStatsList) {
                    builder.addClusterStats(stats.toEnvoyProtoClusterStatsV2());
                }
            }
            return builder.build();
        }

        LoadStatsRequest toEnvoyProtoV3() {
            LoadStatsRequest.Builder builder = LoadStatsRequest.newBuilder().setNode(this.node.toEnvoyProtoNode());
            if (this.clusterStatsList != null) {
                for (EnvoyProtoData.ClusterStats stats : this.clusterStatsList) {
                    builder.addClusterStats(stats.toEnvoyProtoClusterStats());
                }
            }
            return builder.build();
        }
    }

    private final class LrsStreamV3
    extends LrsStream {
        StreamObserver<LoadStatsRequest> lrsRequestWriterV3;

        private LrsStreamV3() {
        }

        @Override
        void start() {
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse> lrsResponseReaderV3 = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse>(){

                public void onNext(final io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse response) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
                            LrsStreamV3.this.handleResponse(LoadStatsResponseData.fromEnvoyProtoV3(response));
                        }
                    });
                }

                public void onError(final Throwable t) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV3.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV3.this.handleRpcCompleted();
                        }
                    });
                }
            };
            LoadReportingServiceGrpc.LoadReportingServiceStub stubV3 = LoadReportingServiceGrpc.newStub((Channel)LoadReportClient.this.xdsChannel.getManagedChannel());
            this.lrsRequestWriterV3 = ((LoadReportingServiceGrpc.LoadReportingServiceStub)stubV3.withWaitForReady()).streamLoadStats(lrsResponseReaderV3);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(new LoadStatsRequestData(LoadReportClient.this.node, null));
        }

        @Override
        void sendLoadStatsRequest(LoadStatsRequestData request) {
            LoadStatsRequest requestProto = request.toEnvoyProtoV3();
            this.lrsRequestWriterV3.onNext((Object)requestProto);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.lrsRequestWriterV3.onError((Throwable)error);
        }
    }

    private final class LrsStreamV2
    extends LrsStream {
        StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest> lrsRequestWriterV2;

        private LrsStreamV2() {
        }

        @Override
        void start() {
            StreamObserver<LoadStatsResponse> lrsResponseReaderV2 = new StreamObserver<LoadStatsResponse>(){

                public void onNext(final LoadStatsResponse response) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LoadStatsResponse:\n{0}", response);
                            LrsStreamV2.this.handleResponse(LoadStatsResponseData.fromEnvoyProtoV2(response));
                        }
                    });
                }

                public void onError(final Throwable t) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV2.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV2.this.handleRpcCompleted();
                        }
                    });
                }
            };
            LoadReportingServiceGrpc.LoadReportingServiceStub stubV2 = io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc.newStub((Channel)LoadReportClient.this.xdsChannel.getManagedChannel());
            this.lrsRequestWriterV2 = ((LoadReportingServiceGrpc.LoadReportingServiceStub)stubV2.withWaitForReady()).streamLoadStats(lrsResponseReaderV2);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(new LoadStatsRequestData(LoadReportClient.this.node, null));
        }

        @Override
        void sendLoadStatsRequest(LoadStatsRequestData request) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest requestProto = request.toEnvoyProtoV2();
            this.lrsRequestWriterV2.onNext((Object)requestProto);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", requestProto);
        }

        @Override
        void sendError(Exception error) {
            this.lrsRequestWriterV2.onError((Throwable)error);
        }
    }

    private abstract class LrsStream {
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalNano = -1L;
        boolean reportAllClusters;
        List<String> clusterNames;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        private LrsStream() {
        }

        abstract void start();

        abstract void sendLoadStatsRequest(LoadStatsRequestData var1);

        abstract void sendError(Exception var1);

        final void handleResponse(LoadStatsResponseData response) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS response received");
                this.initialResponseReceived = true;
            }
            this.reportAllClusters = response.getSendAllClusters();
            if (this.reportAllClusters) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for all clusters");
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for clusters: ", response.getClustersList());
                this.clusterNames = response.getClustersList();
            }
            long interval = response.getLoadReportingIntervalNanos();
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", interval);
            this.loadReportIntervalNano = interval;
            this.scheduleNextLoadReport();
        }

        final void handleRpcError(Throwable t) {
            this.handleStreamClosed(Status.fromThrowable((Throwable)t));
        }

        final void handleRpcCompleted() {
            this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void sendLoadReport() {
            ArrayList<EnvoyProtoData.ClusterStats> clusterStatsList;
            if (this.reportAllClusters) {
                clusterStatsList = LoadReportClient.this.loadStatsManager.getAllLoadReports();
            } else {
                clusterStatsList = new ArrayList();
                for (String name : this.clusterNames) {
                    clusterStatsList.addAll(LoadReportClient.this.loadStatsManager.getClusterLoadReports(name));
                }
            }
            LoadStatsRequestData request = new LoadStatsRequestData(LoadReportClient.this.node, clusterStatsList);
            this.sendLoadStatsRequest(request);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.loadReportIntervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.loadReportIntervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
            this.closed = true;
            this.cleanUp();
            long delayNanos = 0L;
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }
    }

    @VisibleForTesting
    class LrsRpcRetryTask
    implements Runnable {
        LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

