/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.FieldVisitor;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class ClassSignature
implements Constants {
    private ClassReader reader;
    public final boolean isRuntimeClass;
    public final Set<Method> methods;
    public final Set<String> fields;
    public final Set<String> signaturePolymorphicMethods;
    public final String className;
    public final String superName;
    public final String[] interfaces;

    public ClassSignature(ClassReader classReader, boolean isRuntimeClass, boolean withReader) {
        this.reader = withReader ? classReader : null;
        this.isRuntimeClass = isRuntimeClass;
        this.className = classReader.getClassName();
        this.superName = classReader.getSuperName();
        this.interfaces = classReader.getInterfaces();
        final HashSet methods = new HashSet();
        final HashSet fields = new HashSet();
        final HashSet signaturePolymorphicMethods = new HashSet();
        classReader.accept(new ClassVisitor(0x1070000){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Method m = new Method(name, desc);
                methods.add(m);
                if (ClassSignature.this.className.startsWith("java/lang/invoke/") && (access & 0x80) != 0 && (access & 0x100) != 0 && Constants.SIGNATURE_POLYMORPHIC_DESCRIPTOR.equals(desc)) {
                    signaturePolymorphicMethods.add(name);
                }
                return null;
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                fields.add(name);
                return null;
            }
        }, 7);
        this.methods = ClassSignature.createSet(methods);
        this.fields = ClassSignature.createSet(fields);
        this.signaturePolymorphicMethods = ClassSignature.createSet(signaturePolymorphicMethods);
    }

    public ClassSignature(Class<?> clazz, boolean isRuntimeClass) {
        this.reader = null;
        this.isRuntimeClass = isRuntimeClass;
        this.className = Type.getType(clazz).getInternalName();
        Class<?> superclazz = clazz.getSuperclass();
        this.superName = superclazz == null ? null : Type.getType(superclazz).getInternalName();
        Class<?>[] interfClasses = clazz.getInterfaces();
        this.interfaces = new String[interfClasses.length];
        for (int i = 0; i < interfClasses.length; ++i) {
            this.interfaces[i] = Type.getType(interfClasses[i]).getInternalName();
        }
        HashSet<Method> methods = new HashSet<Method>();
        HashSet<String> fields = new HashSet<String>();
        HashSet<String> signaturePolymorphicMethods = new HashSet<String>();
        for (java.lang.reflect.Method method : clazz.getDeclaredMethods()) {
            methods.add(Method.getMethod(method));
            if (!this.className.startsWith("java/lang/invoke/") || !method.isVarArgs() || (method.getModifiers() & 0x100) == 0 || !SIGNATURE_POLYMORPHIC_DESCRIPTOR.equals(Type.getMethodDescriptor(method))) continue;
            signaturePolymorphicMethods.add(method.getName());
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            methods.add(Method.getMethod(executable));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            fields.add(((Field)accessibleObject).getName());
        }
        this.methods = ClassSignature.createSet(methods);
        this.fields = ClassSignature.createSet(fields);
        this.signaturePolymorphicMethods = ClassSignature.createSet(signaturePolymorphicMethods);
    }

    private static <T> Set<T> createSet(Set<? extends T> s) {
        return s.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassReader getReader() {
        if (this.reader == null) {
            throw new IllegalStateException("'" + Type.getObjectType(this.className).getClassName() + "' has no ClassReader, because it was already checked or is only loaded as related class.");
        }
        try {
            ClassReader classReader = this.reader;
            return classReader;
        }
        finally {
            this.reader = null;
        }
    }
}

