/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.Graphs;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class GraphBuilder<V, E, G extends Graph<V, E>> {
    private final G graph;

    public GraphBuilder(G graph) {
        this.graph = graph;
    }

    public G build() {
        return this.graph;
    }

    public GraphBuilder<V, E, G> addVertex(V v) {
        this.graph.addVertex(v);
        return this;
    }

    public GraphBuilder<V, E, G> addEdge(V a, V b) {
        this.graph.addEdge(a, b);
        return this;
    }

    public GraphBuilder<V, E, G> addEdge(V a, V b, E edge) {
        this.graph.addEdge(a, b, edge);
        return this;
    }

    public GraphBuilder<V, E, G> addVertices(V a, V b, V ... other) {
        this.graph.addVertex(a);
        this.graph.addVertex(b);
        for (V o : other) {
            this.graph.addVertex(o);
        }
        return this;
    }

    public GraphBuilder<V, E, G> addEdgeChain(V a, V b, V ... other) {
        this.addVertices(a, b, other);
        this.graph.addEdge(a, b);
        V last = b;
        for (V o : other) {
            this.graph.addEdge(last, o);
            last = o;
        }
        return this;
    }

    public static <V, E, G extends Graph<V, E>> GraphBuilder<V, E, G> of(G graph) {
        return new GraphBuilder<V, E, G>(graph);
    }

    public static <V> GraphBuilder<V, DefaultEdge, DefaultDirectedGraph<V, DefaultEdge>> withDirectedGraph() {
        return new GraphBuilder(Graphs.Directed.newInstance());
    }

    public static <V, E> GraphBuilder<V, E, DefaultDirectedGraph<V, E>> withDirectedGraph(Class<E> edgeType) {
        return new GraphBuilder(Graphs.Directed.newInstance(edgeType));
    }
}

