/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.memcached.tests;

import de.flapdoodle.embed.memcached.Command;
import de.flapdoodle.embed.memcached.MemcachedExecutable;
import de.flapdoodle.embed.memcached.MemcachedProcess;
import de.flapdoodle.embed.memcached.MemcachedStarter;
import de.flapdoodle.embed.memcached.config.MemcachedConfig;
import de.flapdoodle.embed.memcached.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.memcached.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import net.spy.memcached.MemcachedClient;

public class MemcachedForTestsFactory {
    private static Logger logger = Logger.getLogger(MemcachedForTestsFactory.class.getName());
    private final MemcachedExecutable memcachedExecutable;
    private final MemcachedProcess memcachedProcess;

    public static MemcachedForTestsFactory with(IVersion version) throws IOException {
        return new MemcachedForTestsFactory(version);
    }

    public MemcachedForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MemcachedForTestsFactory(IVersion version) throws IOException {
        MemcachedStarter runtime = MemcachedStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MemcacheD, logger).build());
        this.memcachedExecutable = (MemcachedExecutable)runtime.prepare((IExecutableProcessConfig)this.newMemcachedConfig(version));
        this.memcachedProcess = (MemcachedProcess)this.memcachedExecutable.start();
    }

    protected MemcachedConfig newMemcachedConfig(IVersion version) throws UnknownHostException, IOException {
        return new MemcachedConfig(version, new MemcachedConfig.Net(), new MemcachedConfig.Storage(), new MemcachedConfig.Timeout());
    }

    public MemcachedClient newMemcachedClient() throws IOException {
        return new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(((MemcachedConfig)this.memcachedProcess.getConfig()).net().getServerAddress().getCanonicalHostName(), ((MemcachedConfig)this.memcachedProcess.getConfig()).net().getPort())});
    }

    public void shutdown() {
        this.memcachedProcess.stop();
        this.memcachedExecutable.stop();
    }
}

