/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.memcached.config;

import de.flapdoodle.embed.memcached.Command;
import de.flapdoodle.embed.memcached.PackagePaths;
import de.flapdoodle.embed.process.config.store.DownloadConfigBuilder;
import de.flapdoodle.embed.process.config.store.IDownloadPath;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.UserHome;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class DownloadConfigBuilder
extends de.flapdoodle.embed.process.config.store.DownloadConfigBuilder {
    protected static Logger logger = Logger.getLogger(DownloadConfigBuilder.class.getName());

    public DownloadConfigBuilder packageResolverForCommand(Command command) {
        this.packageResolver(new PackagePaths(command));
        return this;
    }

    public DownloadConfigBuilder defaultsForCommand(Command command) {
        return this.defaults().packageResolverForCommand(command);
    }

    public DownloadConfigBuilder defaults() {
        this.fileNaming().setDefault((Object)new UUIDTempNaming());
        this.downloadPath().setDefault((Object)new MemcacheDownloadPath());
        this.progressListener().setDefault((Object)new StandardConsoleProgressListener());
        this.artifactStorePath().setDefault((Object)new UserHome(".embedmemcache"));
        this.downloadPrefix().setDefault((Object)new DownloadConfigBuilder.DownloadPrefix("embedmemcache-download"));
        this.userAgent().setDefault((Object)new DownloadConfigBuilder.UserAgent("Mozilla/5.0 (compatible; Embedded Memcache; +https://github.com/flapdoodle-oss/de.flapdoodle.embed.memcache)"));
        return this;
    }

    private static class MemcacheDownloadPath
    implements IDownloadPath {
        private MemcacheDownloadPath() {
        }

        public String getPath(Distribution distribution) {
            String memcachedDownloadUrl = null;
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File("server.properties")));
                memcachedDownloadUrl = properties.getProperty("memcached.download.url");
            }
            catch (FileNotFoundException e) {
                logger.severe("Couldn't find server.properties in working directory.");
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                logger.severe("Couldn't load server.properties from working directory.");
                throw new RuntimeException(e);
            }
            if (memcachedDownloadUrl == null) {
                throw new IllegalArgumentException("Please specify a property 'memcached.download.url' with the redis distribution download URL.");
            }
            return memcachedDownloadUrl;
        }
    }
}

