/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import de.codecentric.boot.admin.zuul.OptionsDispatchingZuulController;
import de.codecentric.boot.admin.zuul.filters.pre.ApplicationHeadersFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.zuul.RoutesEndpoint;
import org.springframework.cloud.netflix.zuul.ZuulServerAutoConfiguration;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.filters.TraceProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.pre.PreDecorationFilter;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
public class RevereseZuulProxyConfiguration
extends ZuulServerAutoConfiguration {
    @Autowired(required=false)
    private TraceRepository traces;
    @Autowired
    private ApplicationRegistry registry;
    @Autowired
    private AdminServerProperties adminServer;

    @Bean
    @Order(value=0)
    public ApplicationRouteLocator applicationRouteLocator() {
        ApplicationRouteLocator routeLocator = new ApplicationRouteLocator(this.server.getServletPrefix(), this.registry, this.adminServer.getContextPath() + "/api/applications/");
        routeLocator.setEndpoints(this.adminServer.getRoutes().getEndpoints());
        return routeLocator;
    }

    @Bean
    public ZuulController zuulController() {
        return new OptionsDispatchingZuulController();
    }

    @Bean
    public ProxyRequestHelper proxyRequestHelper() {
        TraceProxyRequestHelper helper = new TraceProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        helper.setIgnoredHeaders(this.zuulProperties.getIgnoredHeaders());
        helper.setTraceRequestBody(this.zuulProperties.isTraceRequestBody());
        return helper;
    }

    @Bean
    public PreDecorationFilter preDecorationFilter(RouteLocator routeLocator) {
        return new PreDecorationFilter(routeLocator, this.server.getServletPrefix(), this.zuulProperties, this.proxyRequestHelper());
    }

    @Bean
    public ApplicationHeadersFilter applicationHeadersFilter(ApplicationRouteLocator routeLocator, HttpHeadersProvider headersProvider) {
        return new ApplicationHeadersFilter(headersProvider, routeLocator);
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter() {
        return new SimpleHostRoutingFilter(this.proxyRequestHelper(), this.zuulProperties);
    }

    @Bean
    public ApplicationListener<ApplicationEvent> zuulRefreshRoutesListener() {
        return new ZuulRefreshListener(this.zuulHandlerMapping(null));
    }

    private static class ZuulRefreshListener
    implements ApplicationListener<ApplicationEvent> {
        private ZuulHandlerMapping zuulHandlerMapping;

        private ZuulRefreshListener(ZuulHandlerMapping zuulHandlerMapping) {
            this.zuulHandlerMapping = zuulHandlerMapping;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof PayloadApplicationEvent && ((PayloadApplicationEvent)event).getPayload() instanceof RoutesOutdatedEvent) {
                this.zuulHandlerMapping.setDirty(true);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class RoutesEndpointConfiguration {
        protected RoutesEndpointConfiguration() {
        }

        @Bean
        public RoutesEndpoint zuulEndpoint(RouteLocator routeLocator) {
            return new RoutesEndpoint(routeLocator);
        }
    }
}

