/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.concurrent.threadpool;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class QueuableCachedThreadPool
extends ThreadPoolExecutor {
    private final AtomicInteger submittedCount = new AtomicInteger(0);

    public QueuableCachedThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ControllableQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        workQueue.setParent(this);
        this.prestartAllCoreThreads();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedCount.decrementAndGet();
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, 0L, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable command, long timeout, TimeUnit unit) {
        this.submittedCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            ControllableQueue queue = (ControllableQueue)super.getQueue();
            try {
                if (!queue.force(command, timeout, unit)) {
                    this.submittedCount.decrementAndGet();
                    throw new RejectedExecutionException("Queue capacity is full.");
                }
            }
            catch (InterruptedException ignore) {
                this.submittedCount.decrementAndGet();
                throw new RejectedExecutionException(ignore);
            }
        }
    }

    protected static class ControllableQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 5044057462066661171L;
        private volatile transient QueuableCachedThreadPool parent = null;

        public ControllableQueue(int capacity) {
            super(capacity);
        }

        public void setParent(QueuableCachedThreadPool tp) {
            this.parent = tp;
        }

        public boolean force(Runnable o) {
            if (this.parent.isShutdown()) {
                throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
            }
            return super.offer(o);
        }

        public boolean force(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
            if (this.parent.isShutdown()) {
                throw new RejectedExecutionException("Executor not running, can't force a command into the queue");
            }
            return super.offer(o, timeout, unit);
        }

        @Override
        public boolean offer(Runnable o) {
            int currentPoolSize = this.parent.getPoolSize();
            if (currentPoolSize >= this.parent.getMaximumPoolSize()) {
                return super.offer(o);
            }
            if (this.parent.getSubmittedCount() < currentPoolSize) {
                return super.offer(o);
            }
            if (currentPoolSize < this.parent.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(o);
        }
    }
}

