/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.security;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.spring.security.AuthenticationContext;
import com.vaadin.flow.spring.security.RequestUtil;
import com.vaadin.flow.spring.security.UidlRedirectStrategy;
import com.vaadin.flow.spring.security.VaadinAwareSecurityContextHolderStrategyConfiguration;
import com.vaadin.flow.spring.security.VaadinDefaultRequestCache;
import com.vaadin.flow.spring.security.VaadinRolePrefixHolder;
import com.vaadin.flow.spring.security.VaadinSavedRequestAwareAuthenticationSuccessHandler;
import com.vaadin.flow.spring.security.stateless.VaadinStatelessSecurityConfigurer;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfException;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.WebApplicationContext;

@Import(value={VaadinAwareSecurityContextHolderStrategyConfiguration.class})
public abstract class VaadinWebSecurity {
    @Autowired
    private VaadinDefaultRequestCache vaadinDefaultRequestCache;
    @Autowired
    private RequestUtil requestUtil;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private VaadinRolePrefixHolder vaadinRolePrefixHolder;
    @Value(value="#{servletContext.contextPath}")
    private String servletContextPath;
    @Autowired
    private ObjectProvider<NavigationAccessControl> accessControlProvider;
    private NavigationAccessControl accessControl;
    private final AuthenticationContext authenticationContext = new AuthenticationContext();

    @PostConstruct
    void afterPropertiesSet() {
        this.accessControl = (NavigationAccessControl)this.accessControlProvider.getIfAvailable();
        this.authenticationContext.setRolePrefixHolder(this.vaadinRolePrefixHolder);
    }

    @Bean(name={"VaadinSecurityFilterChainBean"})
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        this.configure(http);
        http.logout(cfg -> {
            cfg.invalidateHttpSession(true);
            this.addLogoutHandlers(arg_0 -> ((LogoutConfigurer)cfg).addLogoutHandler(arg_0));
        });
        DefaultSecurityFilterChain securityFilterChain = (DefaultSecurityFilterChain)http.build();
        Optional.ofNullable(this.vaadinRolePrefixHolder).ifPresent(vaadinRolePrefixHolder -> vaadinRolePrefixHolder.resetRolePrefix(securityFilterChain));
        AuthenticationContext.applySecurityConfiguration(http, this.authenticationContext);
        return securityFilterChain;
    }

    @Bean(name={"VaadinAuthenticationContext"})
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.exceptionHandling(cfg -> cfg.accessDeniedHandler(this.createAccessDeniedHandler()).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), this.requestUtil::isEndpointRequest));
        http.csrf(cfg -> {
            RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
            requestMatcherArray[0] = this.requestUtil::isFrameworkInternalRequest;
            cfg.ignoringRequestMatchers(requestMatcherArray);
        });
        http.requestCache(cfg -> cfg.requestCache((RequestCache)this.vaadinDefaultRequestCache));
        http.authorizeHttpRequests(urlRegistry -> {
            RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
            requestMatcherArray[0] = this.requestUtil::isFrameworkInternalRequest;
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray)).permitAll();
            RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
            requestMatcherArray2[0] = this.requestUtil::isAnonymousEndpoint;
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray2)).permitAll();
            RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
            requestMatcherArray3[0] = this.requestUtil::isAllowedHillaView;
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray3)).permitAll();
            RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
            requestMatcherArray4[0] = this.requestUtil::isAnonymousRoute;
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray4)).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurity.getDefaultHttpSecurityPermitMatcher(this.requestUtil.getUrlMapping())})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{VaadinWebSecurity.getDefaultWebSecurityIgnoreMatcher(this.requestUtil.getUrlMapping())})).permitAll();
            RequestMatcher[] requestMatcherArray5 = new RequestMatcher[1];
            requestMatcherArray5[0] = this.requestUtil::isCustomWebIcon;
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(requestMatcherArray5)).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        });
        this.accessControl.setEnabled(this.enableNavigationAccessControl());
    }

    @Bean(name={"VaadinWebSecurityCustomizerBean"})
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> {
            try {
                this.configure(web);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected void configure(WebSecurity web) throws Exception {
    }

    protected boolean enableNavigationAccessControl() {
        return true;
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher() {
        return VaadinWebSecurity.getDefaultHttpSecurityPermitMatcher("/*");
    }

    public static RequestMatcher getDefaultHttpSecurityPermitMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        Stream.Builder paths = Stream.builder();
        Stream.of(HandlerHelper.getPublicResourcesRequiringSecurityContext()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path)).forEach(paths::add);
        return new OrRequestMatcher(paths.build().map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher() {
        return VaadinWebSecurity.getDefaultWebSecurityIgnoreMatcher("/*");
    }

    public static RequestMatcher getDefaultWebSecurityIgnoreMatcher(String urlMapping) {
        Objects.requireNonNull(urlMapping, "Vaadin servlet url mapping is required");
        Stream<String> mappingRelativePaths = Stream.of(HandlerHelper.getPublicResources()).map(path -> RequestUtil.applyUrlMapping(urlMapping, path));
        Stream<String> rootPaths = Stream.of(HandlerHelper.getPublicResourcesRoot());
        return new OrRequestMatcher(Stream.concat(mappingRelativePaths, rootPaths).map(AntPathRequestMatcher::new).collect(Collectors.toList()));
    }

    public RequestMatcher[] antMatchers(String ... patterns) {
        return RequestUtil.antMatchers(patterns);
    }

    public RequestMatcher[] routeMatchers(String ... patterns) {
        return RequestUtil.routeMatchers((String[])Stream.of(patterns).map(this::applyUrlMapping).toArray(String[]::new));
    }

    protected void setLoginView(HttpSecurity http, String hillaLoginViewPath) throws Exception {
        this.setLoginView(http, hillaLoginViewPath, this.getDefaultLogoutUrl());
    }

    protected void setLoginView(HttpSecurity http, String hillaLoginViewPath, String logoutSuccessUrl) throws Exception {
        String completeHillaLoginViewPath = this.applyUrlMapping(hillaLoginViewPath);
        http.formLogin(formLogin -> {
            formLogin.loginPage(completeHillaLoginViewPath).permitAll();
            formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        });
        this.configureLogout(http, logoutSuccessUrl);
        http.exceptionHandling(cfg -> cfg.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(completeHillaLoginViewPath), AnyRequestMatcher.INSTANCE));
        this.accessControl.setLoginView(hillaLoginViewPath);
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView) throws Exception {
        this.setLoginView(http, flowLoginView, this.getDefaultLogoutUrl());
    }

    protected void setLoginView(HttpSecurity http, Class<? extends Component> flowLoginView, String logoutSuccessUrl) throws Exception {
        Optional route = AnnotationReader.getAnnotationFor(flowLoginView, Route.class);
        if (!route.isPresent()) {
            throw new IllegalArgumentException("Unable find a @Route annotation on the login view " + flowLoginView.getName());
        }
        if (!(this.applicationContext instanceof WebApplicationContext)) {
            throw new RuntimeException("VaadinWebSecurity cannot be used without WebApplicationContext.");
        }
        VaadinServletContext vaadinServletContext = new VaadinServletContext(((WebApplicationContext)this.applicationContext).getServletContext());
        Object loginPath = RouteUtil.getRoutePath((VaadinContext)vaadinServletContext, flowLoginView);
        if (!((String)loginPath).startsWith("/")) {
            loginPath = "/" + (String)loginPath;
        }
        String completeLoginPath = this.applyUrlMapping((String)loginPath);
        http.formLogin(formLogin -> {
            formLogin.loginPage(completeLoginPath).permitAll();
            formLogin.successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http));
        });
        http.csrf(cfg -> cfg.ignoringRequestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(completeLoginPath)}));
        this.configureLogout(http, logoutSuccessUrl);
        http.exceptionHandling(cfg -> cfg.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(completeLoginPath), AnyRequestMatcher.INSTANCE));
        this.accessControl.setLoginView(flowLoginView);
    }

    protected void setOAuth2LoginPage(HttpSecurity http, String oauth2LoginPage) throws Exception {
        http.oauth2Login(cfg -> ((OAuth2LoginConfigurer)cfg.loginPage(oauth2LoginPage).successHandler((AuthenticationSuccessHandler)this.getVaadinSavedRequestAwareAuthenticationSuccessHandler(http))).permitAll());
        this.accessControl.setLoginView(this.servletContextPath + oauth2LoginPage);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer) throws Exception {
        this.setStatelessAuthentication(http, secretKey, issuer, 1800L);
    }

    protected void setStatelessAuthentication(HttpSecurity http, SecretKey secretKey, String issuer, long expiresIn) throws Exception {
        VaadinStatelessSecurityConfigurer.apply(http, (Customizer<VaadinStatelessSecurityConfigurer<HttpSecurity>>)((Customizer)cfg -> cfg.withSecretKey().secretKey(secretKey).and().issuer(issuer).expiresIn(expiresIn)));
    }

    protected String applyUrlMapping(String path) {
        return this.requestUtil.applyUrlMapping(path);
    }

    @Deprecated(forRemoval=true, since="24.3")
    protected ViewAccessChecker getViewAccessChecker() {
        LoggerFactory.getLogger(this.getClass()).warn("ViewAccessChecker is not used anymore by VaadinWebSecurity and has been replaced by NavigationAccessControl. 'VaadinWebSecurity.getViewAccessChecker()' returns a stub instance that delegates calls to NavigationAccessControl. Usages of 'getViewAccessChecker()' should be replaced by calls to 'getNavigationAccessControl()'.");
        return new DeprecateViewAccessCheckerDelegator(this.accessControl);
    }

    protected NavigationAccessControl getNavigationAccessControl() {
        return this.accessControl;
    }

    protected void addLogoutHandlers(Consumer<LogoutHandler> registry) {
    }

    private void configureLogout(HttpSecurity http, String logoutSuccessUrl) throws Exception {
        SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        logoutSuccessHandler.setRedirectStrategy((RedirectStrategy)new UidlRedirectStrategy());
        http.logout(cfg -> cfg.logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler));
    }

    private String getDefaultLogoutUrl() {
        return this.servletContextPath.startsWith("/") ? this.servletContextPath : "/" + this.servletContextPath;
    }

    private VaadinSavedRequestAwareAuthenticationSuccessHandler getVaadinSavedRequestAwareAuthenticationSuccessHandler(HttpSecurity http) {
        VaadinSavedRequestAwareAuthenticationSuccessHandler vaadinSavedRequestAwareAuthenticationSuccessHandler = new VaadinSavedRequestAwareAuthenticationSuccessHandler();
        vaadinSavedRequestAwareAuthenticationSuccessHandler.setDefaultTargetUrl(this.applyUrlMapping(""));
        RequestCache requestCache = (RequestCache)http.getSharedObject(RequestCache.class);
        if (requestCache != null) {
            vaadinSavedRequestAwareAuthenticationSuccessHandler.setRequestCache(requestCache);
        }
        http.setSharedObject(VaadinSavedRequestAwareAuthenticationSuccessHandler.class, (Object)vaadinSavedRequestAwareAuthenticationSuccessHandler);
        return vaadinSavedRequestAwareAuthenticationSuccessHandler;
    }

    private AccessDeniedHandler createAccessDeniedHandler() {
        AccessDeniedHandlerImpl defaultHandler = new AccessDeniedHandlerImpl();
        Http401UnauthorizedAccessDeniedHandler http401UnauthorizedHandler = new Http401UnauthorizedAccessDeniedHandler();
        LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler> exceptionHandlers = new LinkedHashMap<Class<CsrfException>, Http401UnauthorizedAccessDeniedHandler>();
        exceptionHandlers.put(CsrfException.class, http401UnauthorizedHandler);
        LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler> matcherHandlers = new LinkedHashMap<RequestMatcher, DelegatingAccessDeniedHandler>();
        matcherHandlers.put(this.requestUtil::isEndpointRequest, new DelegatingAccessDeniedHandler(exceptionHandlers, (AccessDeniedHandler)new AccessDeniedHandlerImpl()));
        return new RequestMatcherDelegatingAccessDeniedHandler(matcherHandlers, (AccessDeniedHandler)defaultHandler);
    }

    private static class DeprecateViewAccessCheckerDelegator
    extends ViewAccessChecker {
        private final NavigationAccessControl accessControl;

        public DeprecateViewAccessCheckerDelegator(NavigationAccessControl acc) {
            this.accessControl = acc;
        }

        public void enable() {
            this.accessControl.setEnabled(true);
        }

        public void setLoginView(Class<? extends Component> loginView) {
            this.accessControl.setLoginView(loginView);
        }

        public void setLoginView(String loginUrl) {
            this.accessControl.setLoginView(loginUrl);
        }

        public void beforeEnter(BeforeEnterEvent beforeEnterEvent) {
            this.accessControl.beforeEnter(beforeEnterEvent);
        }
    }

    private static class Http401UnauthorizedAccessDeniedHandler
    implements AccessDeniedHandler {
        private Http401UnauthorizedAccessDeniedHandler() {
        }

        public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        }
    }
}

