/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.spring.SpringUtil;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.boot.SpringBootVersion;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.util.ClassUtils;

public class SpringInstantiator
extends DefaultInstantiator {
    private ApplicationContext context;
    private AtomicBoolean loggingEnabled = new AtomicBoolean(true);

    public SpringInstantiator(VaadinService service, ApplicationContext context) {
        super(service);
        this.context = context;
        UsageStatistics.markAsUsed((String)"flow/SpringInstantiator", null);
        UsageStatistics.markAsUsed((String)"SpringFramework", (String)Optional.ofNullable(SpringVersion.getVersion()).orElse("unknown"));
        if (SpringUtil.isSpringBoot()) {
            UsageStatistics.markAsUsed((String)"SpringBoot", (String)SpringBootVersion.getVersion());
        }
    }

    public Stream<VaadinServiceInitListener> getServiceInitListeners() {
        Stream<VaadinServiceInitListener & Serializable> springListeners = Stream.concat(Stream.of((VaadinServiceInitListener & Serializable)event -> this.context.publishEvent((Object)event)), this.context.getBeansOfType(VaadinServiceInitListener.class).values().stream());
        return Stream.concat(super.getServiceInitListeners(), springListeners);
    }

    public <T extends Component> T createComponent(Class<T> componentClass) {
        return (T)((Component)this.context.getAutowireCapableBeanFactory().createBean(componentClass));
    }

    public I18NProvider getI18NProvider() {
        int beansCount = this.context.getBeanNamesForType(I18NProvider.class).length;
        if (beansCount == 1) {
            return (I18NProvider)this.context.getBean(I18NProvider.class);
        }
        if (this.loggingEnabled.compareAndSet(true, false)) {
            LoggerFactory.getLogger((String)SpringInstantiator.class.getName()).info("The number of beans implementing '{}' is {}. Cannot use Spring beans for I18N, falling back to the default behavior", (Object)I18NProvider.class.getSimpleName(), (Object)beansCount);
        }
        return super.getI18NProvider();
    }

    public MenuAccessControl getMenuAccessControl() {
        int beansCount = this.context.getBeanNamesForType(MenuAccessControl.class).length;
        if (beansCount == 1) {
            return (MenuAccessControl)this.context.getBean(MenuAccessControl.class);
        }
        if (this.loggingEnabled.compareAndSet(true, false)) {
            LoggerFactory.getLogger((String)SpringInstantiator.class.getName()).info("The number of beans implementing '{}' is {}. Cannot use Spring beans for Menu Access Control, falling back to the default behavior", (Object)MenuAccessControl.class.getSimpleName(), (Object)beansCount);
        }
        return super.getMenuAccessControl();
    }

    public <T> T getOrCreate(Class<T> type) {
        if (this.context.getBeanNamesForType(type).length == 1) {
            return (T)this.context.getBean(type);
        }
        if (this.context.getBeanNamesForType(type).length > 1) {
            try {
                return (T)this.context.getAutowireCapableBeanFactory().createBean(type);
            }
            catch (BeanInstantiationException e) {
                throw new BeanInstantiationException(e.getBeanClass(), "[HINT] This could be caused by more than one suitable beans for autowiring in the context.", (Throwable)e);
            }
        }
        return (T)this.context.getAutowireCapableBeanFactory().createBean(type);
    }

    public Class<?> getApplicationClass(Class<?> clazz) {
        return ClassUtils.getUserClass(clazz);
    }
}

