/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.spring.ReloadEvent;
import java.io.File;
import java.io.Serializable;
import org.springframework.boot.devtools.classpath.ClassPathChangedEvent;
import org.springframework.context.ApplicationListener;

class ReloadListener
implements ApplicationListener<ClassPathChangedEvent>,
Serializable {
    private final SerializableConsumer<ReloadEvent> callback;

    public ReloadListener(SerializableConsumer<ReloadEvent> callback) {
        this.callback = callback;
    }

    public void onApplicationEvent(ClassPathChangedEvent event) {
        ReloadEvent reloadEvent = new ReloadEvent();
        event.getChangeSet().forEach(changedFiles -> changedFiles.getFiles().forEach(file -> {
            String className = this.convertToClassName(file.getRelativeName());
            if (className != null) {
                switch (file.getType()) {
                    case ADD: {
                        reloadEvent.getAddedClasses().add(className);
                        break;
                    }
                    case DELETE: {
                        reloadEvent.getRemovedClasses().add(className);
                        break;
                    }
                    case MODIFY: {
                        reloadEvent.getChangedClasses().add(className);
                    }
                }
            }
        }));
        this.callback.accept((Object)reloadEvent);
    }

    private String convertToClassName(String fileName) {
        if (fileName.endsWith(".class")) {
            String name = fileName.replace(".class", "").replace('/', '.');
            if (File.separatorChar != '/') {
                return name.replace(File.separatorChar, '.');
            }
            return name;
        }
        return null;
    }
}

