/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="marginalia", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureMarginaliaMojo
extends AbstractClojureCompilerMojo {
    @Parameter(readonly=true, required=true, property="project")
    private MavenProject project = null;
    @Parameter(property="project.name")
    private String projectName;
    @Parameter(property="project.version")
    private String projectVersion;
    @Parameter(property="project.description")
    private String projectDescription;
    @Parameter(property="project.build.directory")
    private String projectBuildDir;
    @Parameter
    private String[] marginaliaSourceDirectories;
    @Parameter(defaultValue="${project.build.directory}/marginalia")
    private String marginaliaTargetDirectory;
    @Parameter
    private Map<String, String> marginalia;

    private Set<Artifact> filterScope(Set<Artifact> artifacts, String scope) {
        Vector<Artifact> to_remove = new Vector<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.getScope() == scope) continue;
            to_remove.add(artifact);
        }
        artifacts.removeAll(to_remove);
        return artifacts;
    }

    private String quote(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(s);
        sb.append("\"");
        return sb.toString();
    }

    private String formatDependencies(Set<Artifact> artifacts) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Artifact artifact : artifacts) {
            sb.append("[\"");
            sb.append(artifact.getGroupId());
            sb.append("/");
            sb.append(artifact.getArtifactId());
            sb.append("\" \"");
            sb.append(artifact.getVersion());
            sb.append("\"]\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private String formatMap(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(" :" + key + " ");
            if (value != null) {
                sb.append(value);
            } else {
                sb.append("nil");
            }
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void execute() throws MojoExecutionException {
        HashMap<String, String> effectiveProps = new HashMap<String, String>();
        effectiveProps.put("name", this.quote(this.projectName));
        effectiveProps.put("version", this.quote(this.projectVersion));
        effectiveProps.put("description", this.quote(this.projectDescription));
        effectiveProps.put("dependencies", this.formatDependencies(this.filterScope(this.project.getDependencyArtifacts(), "compile")));
        effectiveProps.put("dev-dependencies", this.formatDependencies(this.filterScope(this.project.getDependencyArtifacts(), "test")));
        if (this.marginalia != null) {
            effectiveProps.put("marginalia", this.formatMap(this.marginalia));
        }
        boolean multiDoc = this.marginalia == null ? false : "true".equals(this.marginalia.get("multi"));
        StringBuilder sb = new StringBuilder();
        sb.append("(use `marginalia.core '[marginalia.html :only (*resources*)])\n");
        sb.append("(binding [*resources* \"\"]\n");
        sb.append("(ensure-directory! \"");
        sb.append(this.marginaliaTargetDirectory);
        sb.append("\")\n");
        sb.append(multiDoc ? "(multidoc!\n" : "(uberdoc!\n");
        sb.append("  \"");
        sb.append(this.marginaliaTargetDirectory);
        if (!multiDoc) {
            sb.append("/uberdoc.html");
        }
        sb.append("\"\n");
        sb.append("  (format-sources [");
        for (String entry : this.marginaliaSourceDirectories != null && this.marginaliaSourceDirectories.length > 0 ? this.marginaliaSourceDirectories : this.sourceDirectories) {
            sb.append("\"");
            sb.append(this.baseDirectory);
            sb.append("/");
            sb.append(entry);
            sb.append("\" ");
        }
        sb.append("])\n");
        sb.append(this.formatMap(effectiveProps));
        sb.append(")\n");
        sb.append(")\n");
        try {
            File marginaliaClj = File.createTempFile("marginalia", ".clj");
            PrintWriter pw = new PrintWriter(marginaliaClj);
            pw.print(sb.toString());
            pw.close();
            this.getLog().info((CharSequence)"Generating marginalia docs");
            this.getLog().debug((CharSequence)sb.toString());
            this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE, AbstractClojureCompilerMojo.SourceDirectory.TEST), this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{marginaliaClj.getPath()});
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

