/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.common;

import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.plugin.server.EventHandler;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public abstract class ServiceUpdateTask
implements Runnable,
Comparable<ServiceUpdateTask> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceUpdateTask.class);
    protected final ServiceEventHandler serviceEventHandler;
    protected final DestroyableServerConnector serverConnector;
    protected final AtomicReference<ClusterType> targetClusterType = new AtomicReference();
    protected final AtomicReference<ServiceUpdateTaskConstant.Type> taskType = new AtomicReference();
    protected final AtomicReference<ServiceUpdateTaskConstant.Status> taskStatus = new AtomicReference();
    protected final ServiceEventKey serviceEventKey;
    protected final AtomicLong lastUpdateTime = new AtomicLong(0L);
    protected final AtomicLong successUpdates = new AtomicLong(0L);
    private final long refreshIntervalMs;
    private final EventHandler eventHandler;

    public ServiceUpdateTask(ServiceEventHandler handler, DestroyableServerConnector connector) {
        this.serviceEventHandler = handler;
        this.serverConnector = connector;
        this.serviceEventKey = handler.getServiceEventKey();
        this.refreshIntervalMs = handler.getRefreshIntervalMs() + (long)new Random().nextInt(1000);
        this.eventHandler = handler.getEventHandler();
        this.taskType.set(ServiceUpdateTaskConstant.Type.FIRST);
        this.taskStatus.set(ServiceUpdateTaskConstant.Status.READY);
        this.targetClusterType.set(handler.getTargetCluster());
    }

    @Override
    public int compareTo(ServiceUpdateTask o) {
        return this.taskType.get().ordinal() - o.taskType.get().ordinal();
    }

    public ServiceEventKey getServiceEventKey() {
        return this.serviceEventKey;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public ClusterType getTargetClusterType() {
        return this.targetClusterType.get();
    }

    public boolean setType(ServiceUpdateTaskConstant.Type last, ServiceUpdateTaskConstant.Type current) {
        return this.taskType.compareAndSet(last, current);
    }

    public boolean setStatus(ServiceUpdateTaskConstant.Status last, ServiceUpdateTaskConstant.Status current) {
        return this.taskStatus.compareAndSet(last, current);
    }

    public ServiceUpdateTaskConstant.Type getTaskType() {
        return this.taskType.get();
    }

    public void retry() {
        this.serverConnector.retryServiceUpdateTask(this);
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Throwable throwable) {
            this.handle(throwable);
        }
    }

    protected abstract void execute() throws Throwable;

    protected abstract void handle(Throwable var1);

    public abstract boolean notifyServerEvent(ServerEvent var1);

    public void addUpdateTaskSet() {
        if (this.taskType.compareAndSet(ServiceUpdateTaskConstant.Type.FIRST, ServiceUpdateTaskConstant.Type.LONG_RUNNING)) {
            this.targetClusterType.set(ClusterType.SERVICE_DISCOVER_CLUSTER);
            this.serverConnector.addLongRunningTask(this);
            LOG.info("[ServerConnector]task for service {} has been scheduled updated", (Object)this);
        }
    }

    public boolean needUpdate() {
        if (this.taskType.get() != ServiceUpdateTaskConstant.Type.LONG_RUNNING || this.taskStatus.get() != ServiceUpdateTaskConstant.Status.READY) {
            return false;
        }
        long nowMs = System.currentTimeMillis();
        return nowMs - this.lastUpdateTime.get() >= this.refreshIntervalMs;
    }

    public ServiceUpdateTaskConstant.Status getTaskStatus() {
        return this.taskStatus.get();
    }

    public String toString() {
        return "ServiceUpdateTask{taskType=" + (Object)((Object)this.taskType.get()) + ", taskStatus=" + (Object)((Object)this.taskStatus.get()) + ", serviceEventKey=" + this.serviceEventKey + ", targetClusterType=" + this.targetClusterType.get() + '}';
    }

    public long getRefreshIntervalMs() {
        return this.refreshIntervalMs;
    }
}

