/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.Endpoint;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringUtils {
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static List<Endpoint> parseEndpoints(String endpointsFullStr) throws SQLException {
        if (StringUtils.isEmpty(endpointsFullStr)) {
            ArrayList<Endpoint> result = new ArrayList<Endpoint>(1);
            Endpoint endpoint = new Endpoint("localhost", 0, false);
            result.add(endpoint);
            return result;
        }
        String[] endpoints = endpointsFullStr.split(",");
        ArrayList<Endpoint> result = new ArrayList<Endpoint>(endpoints.length);
        for (int i = 0; i < endpoints.length; ++i) {
            String endpointStr = endpoints[i];
            String host = "localhost";
            String port = "0";
            if (endpointStr.startsWith("[")) {
                int endBracket = endpointStr.indexOf(93);
                if (endBracket != -1) {
                    host = endpointStr.substring(0, endBracket + 1);
                    if (endBracket + 1 < endpointStr.length() && endpointStr.charAt(endBracket + 1) == ':') {
                        port = endpointStr.substring(endBracket + 2);
                    }
                } else {
                    throw TSDBError.createSQLException(8963, "Invalid IPv6 address: " + endpointStr);
                }
                if (host.contains("%")) {
                    host = host.replace("%", "%25");
                }
                result.add(new Endpoint(host, Integer.parseInt(port), true));
                continue;
            }
            int lastColon = endpointStr.lastIndexOf(58);
            if (lastColon != -1) {
                host = endpointStr.substring(0, lastColon);
                String portStr = endpointStr.substring(lastColon + 1);
                if (!StringUtils.isEmpty(portStr)) {
                    port = portStr;
                }
            } else {
                host = endpointStr;
            }
            result.add(new Endpoint(host, Integer.parseInt(port), false));
        }
        return result;
    }

    public static Properties parseUrl(String url, Properties defaults) throws SQLException {
        List<Endpoint> endpoints;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (StringUtils.isEmpty(url)) {
            return urlProps;
        }
        int paramStart = url.indexOf("?");
        if (paramStart != -1) {
            String paramString = url.substring(paramStart + 1);
            url = url.substring(0, paramStart);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String value;
                String pair = queryParams.nextToken();
                int eqIdx = pair.indexOf("=");
                if (eqIdx == -1) continue;
                String key = pair.substring(0, eqIdx);
                String string = value = eqIdx + 1 < pair.length() ? pair.substring(eqIdx + 1) : "";
                if (key.isEmpty() || value.isEmpty()) continue;
                urlProps.setProperty(key, value);
            }
        }
        int slashesStart = url.indexOf("//");
        String dbProductName = url.substring(0, slashesStart);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        urlProps.setProperty("productName", dbProductName);
        String hostPortDb = url.substring(slashesStart + 2);
        int dbStart = hostPortDb.indexOf("/");
        if (dbStart != -1) {
            if (dbStart + 1 < hostPortDb.length()) {
                urlProps.setProperty("dbname", hostPortDb.substring(dbStart + 1).toLowerCase());
            }
            hostPortDb = hostPortDb.substring(0, dbStart);
        }
        urlProps.setProperty("endpoints", hostPortDb);
        if (!StringUtils.isEmpty(hostPortDb) && (endpoints = StringUtils.parseEndpoints(hostPortDb)).size() == 1) {
            Endpoint endpoint = endpoints.get(0);
            if (!StringUtils.isEmpty(endpoint.getHost())) {
                urlProps.setProperty("host", endpoint.getHost());
            }
            if (endpoint.getPort() > 0) {
                urlProps.setProperty("port", String.valueOf(endpoint.getPort()));
            }
        }
        return urlProps;
    }

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < hex.length() / 2; ++i) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = StringUtils.hexToInt(hex.charAt(i2));
            int nib0 = StringUtils.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public static String bytesToHex(byte[] bytes) {
        return StringUtils.toHex(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(StringUtils.toHexDigit(b >> 4 & 0xF));
            buf.append(StringUtils.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public static String getBasicUrl(String url) {
        if (url == null || url.trim().length() == 0) {
            return "";
        }
        int firstIndex = url.indexOf("?");
        if (firstIndex > 0) {
            return url.substring(0, firstIndex);
        }
        return url;
    }

    public static String retainHostPortPart(String jdbcUrl) {
        if (jdbcUrl == null || jdbcUrl.isEmpty()) {
            return jdbcUrl;
        }
        String urlWithoutParams = StringUtils.getBasicUrl(jdbcUrl);
        int doubleSlashIndex = urlWithoutParams.indexOf("//");
        if (doubleSlashIndex == -1) {
            return urlWithoutParams;
        }
        int dbSeparatorIndex = urlWithoutParams.indexOf(47, doubleSlashIndex + 2);
        if (dbSeparatorIndex == -1) {
            return urlWithoutParams;
        }
        return urlWithoutParams.substring(0, dbSeparatorIndex);
    }
}

