/*
 * Decompiled with CFR 0.152.
 */
package squants.mass;

import scala.Function1;
import scala.Option;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.SpecificEnergy;
import squants.mass.AreaDensity;
import squants.mass.Density;
import squants.mass.Density$;
import squants.mass.Grams$;
import squants.mass.Kilograms$;
import squants.mass.KilogramsPerSquareMeter$;
import squants.mass.Kilopounds$;
import squants.mass.Mass$;
import squants.mass.MassUnit;
import squants.mass.Megapounds$;
import squants.mass.Micrograms$;
import squants.mass.Milligrams$;
import squants.mass.Ounces$;
import squants.mass.Pounds$;
import squants.mass.Tonnes$;
import squants.motion.Acceleration;
import squants.motion.Force;
import squants.motion.KilogramsPerSecond$;
import squants.motion.MassFlow;
import squants.motion.Momentum;
import squants.motion.Momentum$;
import squants.motion.Newtons$;
import squants.motion.Velocity;
import squants.package$;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.SquareMeters$;
import squants.space.Volume;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeIntegral$class;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0005\u001d\u0011A!T1tg*\u00111\u0001B\u0001\u0005[\u0006\u001c8OC\u0001\u0006\u0003\u001d\u0019\u0018/^1oiN\u001c\u0001aE\u0002\u0001\u00119\u00012!\u0003\u0006\r\u001b\u0005!\u0011BA\u0006\u0005\u0005!\tV/\u00198uSRL\bCA\u0007\u0001\u001b\u0005\u0011\u0001cA\b\u0013)5\t\u0001C\u0003\u0002\u0012\t\u0005!A/[7f\u0013\t\u0019\u0002C\u0001\u0007US6,\u0017J\u001c;fOJ\fG\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00051Qn\u001c;j_:L!!\u0007\f\u0003\u00115\u000b7o\u001d$m_^D\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0006m\u0006dW/Z\u000b\u0002;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1Ai\\;cY\u0016D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\nA!\u001e8jiV\t\u0001\u0006\u0005\u0002\u000eS%\u0011!F\u0001\u0002\t\u001b\u0006\u001c8/\u00168ji\"AA\u0006\u0001B\u0001B\u0003%\u0001&A\u0003v]&$\b\u0005C\u0003/\u0001\u0011%q&\u0001\u0004=S:LGO\u0010\u000b\u0004\u0019A\n\u0004\"B\u000e.\u0001\u0004i\u0002\"\u0002\u0014.\u0001\u0004A\u0003\"B\u001a\u0001\t\u0003!\u0014!\u00033j[\u0016t7/[8o+\u0005)dBA\u00077\u000f\u00159$\u0001#\u00019\u0003\u0011i\u0015m]:\u0011\u00055Id!B\u0001\u0003\u0011\u0003Q4#B\u001d<}\u0005#\u0005C\u0001\u0010=\u0013\titD\u0001\u0004B]f\u0014VM\u001a\t\u0004\u0013}b\u0011B\u0001!\u0005\u0005%!\u0015.\\3og&|g\u000e\u0005\u0002\n\u0005&\u00111\t\u0002\u0002\u000e\u0005\u0006\u001cX\rR5nK:\u001c\u0018n\u001c8\u0011\u0005y)\u0015B\u0001$ \u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015q\u0013\b\"\u0001I)\u0005A\u0004B\u0002&:\t\u0003\u00111*A\u0003baBd\u00170\u0006\u0002M=R\u0019QjZ5\u0015\u00051q\u0005\"B(J\u0001\b\u0001\u0016a\u00018v[B\u0019\u0011+\u0017/\u000f\u0005I;fBA*W\u001b\u0005!&BA+\u0007\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002Y?\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\u001dqU/\\3sS\u000eT!\u0001W\u0010\u0011\u0005usF\u0002\u0001\u0003\u0006?&\u0013\r\u0001\u0019\u0002\u0002\u0003F\u0011\u0011\r\u001a\t\u0003=\tL!aY\u0010\u0003\u000f9{G\u000f[5oOB\u0011a$Z\u0005\u0003M~\u00111!\u00118z\u0011\u0015A\u0017\n1\u0001]\u0003\u0005q\u0007\"\u0002\u0014J\u0001\u0004A\u0003\"\u0002&:\t\u0003YW#\u00017\u0011\tyiGm\\\u0005\u0003]~\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007A\u001cH\"D\u0001r\u0015\t\u0011x$\u0001\u0003vi&d\u0017B\u0001;r\u0005\r!&/\u001f\u0005\u0006mf\"\ta^\u0001\u0005]\u0006lW-F\u0001y!\tIh0D\u0001{\u0015\tYH0\u0001\u0003mC:<'\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u0014aa\u0015;sS:<\u0007bBA\u0002s\u0011\u0005\u0011QA\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002\b9\u0019Q\"!\u0003\n\u0007\u0005-!!A\u0003He\u0006l7\u000fC\u0004\u0002\u0010e\"\t!!\u0005\u0002\rMLWK\\5u+\t\t\u0019BD\u0002\u000e\u0003+I1!a\u0006\u0003\u0003%Y\u0015\u000e\\8he\u0006l7\u000fC\u0004\u0002\u001ce\"\t!!\b\u0002\u000bUt\u0017\u000e^:\u0016\u0005\u0005}\u0001CBA\u0011\u0003W\ty#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%IW.\\;uC\ndWMC\u0002\u0002*}\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti#a\t\u0003\u0007M+G\u000f\u0005\u0003\n\u0003ca\u0011bAA\u001a\t\tiQK\\5u\u001f\u001alU-Y:ve\u0016Da!a\u000e:\t\u00039\u0018a\u00043j[\u0016t7/[8o'fl'm\u001c7\t\u0013\u0005m\u0012(!A\u0005\n\u0005u\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0010\u0011\u0007e\f\t%C\u0002\u0002Di\u0014aa\u00142kK\u000e$\bbBA$\u0001\u0011E\u0011\u0011J\u0001\fi&lW\rR3sSZ,G-F\u0001\u0015\u0011\u0019\t\u0002\u0001\"\u0005\u0002NU\u0011\u0011q\n\t\u0004\u001f\u0005E\u0013bAA*!\t!A+[7f\u0011\u001d\t9\u0006\u0001C\u0001\u00033\na\u0001\n;j[\u0016\u001cH\u0003BA.\u0003O\u0002B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C\"\u0011AB3oKJ<\u00170\u0003\u0003\u0002f\u0005}#AB#oKJ<\u0017\u0010\u0003\u0005\u0002j\u0005U\u0003\u0019AA6\u0003\u0011!\b.\u0019;\u0011\t\u0005u\u0013QN\u0005\u0005\u0003_\nyF\u0001\bTa\u0016\u001c\u0017NZ5d\u000b:,'oZ=\t\u000f\u0005]\u0003\u0001\"\u0001\u0002tQ!\u0011QOA>!\r)\u0012qO\u0005\u0004\u0003s2\"\u0001C'p[\u0016tG/^7\t\u0011\u0005%\u0014\u0011\u000fa\u0001\u0003{\u0002B!a \u0002\b:!\u0011\u0011QAC\u001d\r\u0019\u00161Q\u0005\u0002\u000b%\u0011\u0001\fB\u0005\u0005\u0003\u0013\u000bYI\u0001\u0005WK2|7-\u001b;z\u0015\tAF\u0001C\u0004\u0002X\u0001!\t!a$\u0015\t\u0005E\u0015q\u0013\t\u0004+\u0005M\u0015bAAK-\t)ai\u001c:dK\"A\u0011\u0011NAG\u0001\u0004\tI\n\u0005\u0003\u0002\u0000\u0005m\u0015\u0002BAO\u0003\u0017\u0013A\"Q2dK2,'/\u0019;j_:Dq!!)\u0001\t\u0003\t\u0019+\u0001\u0003%I&4H\u0003BAS\u0003W\u0003B!a \u0002(&!\u0011\u0011VAF\u0005\u00191v\u000e\\;nK\"A\u0011\u0011NAP\u0001\u0004\ti\u000bE\u0002\u000e\u0003_K1!!-\u0003\u0005\u001d!UM\\:jifDq!!)\u0001\t\u0003\t)\f\u0006\u0003\u0002.\u0006]\u0006\u0002CA5\u0003g\u0003\r!!*\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002<R!\u0011QXAb!\u0011\ty(a0\n\t\u0005\u0005\u00171\u0012\u0002\u0005\u0003J,\u0017\r\u0003\u0005\u0002j\u0005e\u0006\u0019AAc!\ri\u0011qY\u0005\u0004\u0003\u0013\u0014!aC!sK\u0006$UM\\:jifDq!!)\u0001\t\u0003\ti\r\u0006\u0003\u0002F\u0006=\u0007\u0002CA5\u0003\u0017\u0004\r!!0\t\r\u0005M\u0007\u0001\"\u0001\u001d\u00031!x.T5de><'/Y7t\u0011\u0019\t9\u000e\u0001C\u00019\u0005aAo\\'jY2LwM]1ng\"1\u00111\u001c\u0001\u0005\u0002q\tq\u0001^8He\u0006l7\u000f\u0003\u0004\u0002`\u0002!\t\u0001H\u0001\fi>\\\u0015\u000e\\8he\u0006l7\u000f\u0003\u0004\u0002d\u0002!\t\u0001H\u0001\ti>$vN\u001c8fg\"1\u0011q\u001d\u0001\u0005\u0002q\t\u0001\u0002^8Pk:\u001cWm\u001d\u0005\u0007\u0003W\u0004A\u0011\u0001\u000f\u0002\u0011Q|\u0007k\\;oINDa!a<\u0001\t\u0003a\u0012\u0001\u0004;p\u0017&dw\u000e]8v]\u0012\u001c\bBBAz\u0001\u0011\u0005A$\u0001\u0007u_6+w-\u00199pk:$7\u000f")
public final class Mass
extends Quantity<Mass>
implements TimeIntegral<MassFlow> {
    private final double value;
    private final MassUnit unit;

    public static Try<Mass> parse(Object object) {
        return Mass$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<Mass>> symbolToUnit(String string) {
        return Mass$.MODULE$.symbolToUnit(string);
    }

    public static String dimensionSymbol() {
        return Mass$.MODULE$.dimensionSymbol();
    }

    public static Set<UnitOfMeasure<Mass>> units() {
        return Mass$.MODULE$.units();
    }

    public static Kilograms$ siUnit() {
        return Mass$.MODULE$.siUnit();
    }

    public static Grams$ primaryUnit() {
        return Mass$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Mass$.MODULE$.name();
    }

    public static Function1<Object, Try<Mass>> apply() {
        return Mass$.MODULE$.apply();
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral$class.per(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public MassUnit unit() {
        return this.unit;
    }

    public Mass$ dimension() {
        return Mass$.MODULE$;
    }

    @Override
    public MassFlow timeDerived() {
        return KilogramsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toKilograms()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(SpecificEnergy that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Momentum $times(Velocity that) {
        return Momentum$.MODULE$.apply(this, that);
    }

    public Force $times(Acceleration that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(Density that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Density $div(Volume that) {
        return Density$.MODULE$.apply(this, that);
    }

    public Area $div(AreaDensity that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public AreaDensity $div(Area that) {
        return KilogramsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toMicrograms() {
        return this.to(Micrograms$.MODULE$);
    }

    public double toMilligrams() {
        return this.to(Milligrams$.MODULE$);
    }

    public double toGrams() {
        return this.to(Grams$.MODULE$);
    }

    public double toKilograms() {
        return this.to(Kilograms$.MODULE$);
    }

    public double toTonnes() {
        return this.to(Tonnes$.MODULE$);
    }

    public double toOunces() {
        return this.to(Ounces$.MODULE$);
    }

    public double toPounds() {
        return this.to(Pounds$.MODULE$);
    }

    public double toKilopounds() {
        return this.to(Kilopounds$.MODULE$);
    }

    public double toMegapounds() {
        return this.to(Megapounds$.MODULE$);
    }

    public Mass(double value, MassUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral$class.$init$(this);
    }
}

