/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import scala.Function1;
import scala.Some;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import squants.market.AUD$;
import squants.market.BTC$;
import squants.market.CAD$;
import squants.market.CHF$;
import squants.market.EUR$;
import squants.market.GBP$;
import squants.market.HKD$;
import squants.market.JPY$;
import squants.market.Money;
import squants.market.Money$;
import squants.market.MoneyContext;
import squants.market.MoneyConversions$;
import squants.market.NOK$;
import squants.market.NZD$;
import squants.market.SEK$;
import squants.market.USD$;
import squants.market.XAG$;
import squants.market.XAU$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dw!B\u0001\u0003\u0011\u00039\u0011\u0001E'p]\u0016L8i\u001c8wKJ\u001c\u0018n\u001c8t\u0015\t\u0019A!\u0001\u0004nCJ\\W\r\u001e\u0006\u0002\u000b\u000591/];b]R\u001c8\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0011\u001b>tW-_\"p]Z,'o]5p]N\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001\u0003\u0005\u0017\u0013!\u0015\r\u0011\"\u0001\u0018\u0003\u0019!w\u000e\u001c7beV\t\u0001\u0004\u0005\u0002\t3%\u0011!D\u0001\u0002\u0006\u001b>tW-\u001f\u0005\t9%A\t\u0011)Q\u00051\u00059Am\u001c7mCJ\u0004\u0003\u0002\u0003\u0010\n\u0011\u000b\u0007I\u0011A\f\u0002\t\u0015,(o\u001c\u0005\tA%A\t\u0011)Q\u00051\u0005)Q-\u001e:pA!A!%\u0003EC\u0002\u0013\u0005q#A\u0002zK:D\u0001\u0002J\u0005\t\u0002\u0003\u0006K\u0001G\u0001\u0005s\u0016t\u0007\u0005C\u0003'\u0013\u0011\rq%\u0001\u0005ge>lGj\u001c8h)\rA\u00131\u0002\t\u0004S)zX\"A\u0005\u0007\t)I\u0011aK\u000b\u0003YE\u001a\"A\u000b\u0007\t\u00119R#\u0011!Q\u0001\n=\n\u0011A\u001c\t\u0003aEb\u0001\u0001B\u00033U\t\u00071GA\u0001B#\t!t\u0007\u0005\u0002\u000ek%\u0011aG\u0004\u0002\b\u001d>$\b.\u001b8h!\ti\u0001(\u0003\u0002:\u001d\t\u0019\u0011I\\=\t\u0011mR#\u0011!Q\u0001\fq\n1A\\;n!\riTi\f\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001#\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u000f9+X.\u001a:jG*\u0011AI\u0004\u0005\u0006')\"\t!\u0013\u000b\u0003\u00156#\"a\u0013'\u0011\u0007%Rs\u0006C\u0003<\u0011\u0002\u000fA\bC\u0003/\u0011\u0002\u0007q\u0006C\u0003PU\u0011\u0005\u0001+A\u0003n_:,\u0017\u0010\u0006\u0002\u0019#\")!K\u0014a\u0002'\u000691m\u001c8uKb$\bC\u0001\u0005U\u0013\t)&A\u0001\u0007N_:,\u0017pQ8oi\u0016DH\u000fC\u0003XU\u0011\u0005q#A\u0002Y\u0003VCQ!\u0017\u0016\u0005\u0002]\t1\u0001W!H\u0011\u0015Y&\u0006\"\u0001\u0018\u0003\r)6\u000b\u0012\u0005\u0006;*\"\taF\u0001\bI>dG.\u0019:t\u0011\u0015y&\u0006\"\u0001\u0018\u0003\u0015\u0019WM\u001c;t\u0011\u0015\t'\u0006\"\u0001\u0018\u0003\r)UK\u0015\u0005\u0006G*\"\taF\u0001\u0006KV\u0014xn\u001d\u0005\u0006K*\"\taF\u0001\u0004\u0015BK\u0006\"\u0002\u0012+\t\u00039\u0002\"\u00025+\t\u00039\u0012aA$C!\")!N\u000bC\u0001/\u0005i\u0001o\\;oIN#XM\u001d7j]\u001eDQ\u0001\u001c\u0016\u0005\u0002]\t1a\u0011%G\u0011\u0015q'\u0006\"\u0001\u0018\u0003-\u0019x/[:t\rJ\fgnY:\t\u000bATC\u0011A\f\u0002\u0007\u0005+F\tC\u0003sU\u0011\u0005q#A\u0002D\u0003\u0012CQ\u0001\u001e\u0016\u0005\u0002]\t1aU#L\u0011\u00151(\u0006\"\u0001\u0018\u0003\rA5\n\u0012\u0005\u0006q*\"\taF\u0001\u0004\u001d>[\u0005\"\u0002>+\t\u00039\u0012a\u0001([\t\")AP\u000bC\u0001/\u0005\u0019!\tV\"\t\u000byTC\u0011A\f\u0002\u000f\tLGoQ8j]B!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u00069\tA!\\1uQ&!\u0011\u0011BA\u0002\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\u001c\u0005\b\u0003\u001b)\u0003\u0019AA\b\u0003\u0005a\u0007cA\u0007\u0002\u0012%\u0019\u00111\u0003\b\u0003\t1{gn\u001a\u0005\b\u0003/IA1AA\r\u0003)1'o\\7E_V\u0014G.\u001a\u000b\u0004Q\u0005m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u0003\u0011\u00042!DA\u0011\u0013\r\t\u0019C\u0004\u0002\u0007\t>,(\r\\3\t\u0011\u0005I\u0011\u0011!C\u0002\u0003O)B!!\u000b\u00022Q!\u00111FA\u001c)\u0011\ti#a\r\u0011\t%R\u0013q\u0006\t\u0004a\u0005EBA\u0002\u001a\u0002&\t\u00071\u0007C\u0004<\u0003K\u0001\u001d!!\u000e\u0011\tu*\u0015q\u0006\u0005\b]\u0005\u0015\u0002\u0019AA\u0018\r\u0019\tY$\u0003\u0001\u0002>\taQj\u001c8fs:+X.\u001a:jGN1\u0011\u0011HA \u0003\u001f\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007u*\u0005\u0004\u0003\u0006\u0002T\u0005e\"\u0011!Q\u0001\fM\u000b!!\\2\t\u000fM\tI\u0004\"\u0001\u0002XQ\u0011\u0011\u0011\f\u000b\u0005\u00037\ni\u0006E\u0002*\u0003sAq!a\u0015\u0002V\u0001\u000f1\u000b\u0003\u0005\u0002b\u0005eB\u0011AA2\u0003\u0011\u0001H.^:\u0015\u000ba\t)'!\u001b\t\u000f\u0005\u001d\u0014q\fa\u00011\u0005\t\u0001\u0010C\u0004\u0002l\u0005}\u0003\u0019\u0001\r\u0002\u0003eD\u0001\"a\u001c\u0002:\u0011\u0005\u0011\u0011O\u0001\u0006[&tWo\u001d\u000b\u00061\u0005M\u0014Q\u000f\u0005\b\u0003O\ni\u00071\u0001\u0019\u0011\u001d\tY'!\u001cA\u0002aA\u0001\"!\u001f\u0002:\u0011\u0005\u00111P\u0001\u0006i&lWm\u001d\u000b\u0006i\u0005u\u0014q\u0010\u0005\b\u0003O\n9\b1\u0001\u0019\u0011\u001d\tY'a\u001eA\u0002aA\u0001\"a!\u0002:\u0011\u0005\u0011QQ\u0001\u0007]\u0016<\u0017\r^3\u0015\u0007a\t9\tC\u0004\u0002h\u0005\u0005\u0005\u0019\u0001\r\t\u0011\u0005-\u0015\u0011\bC\u0001\u0003\u001b\u000bqA\u001a:p[&sG\u000fF\u0002\u0019\u0003\u001fC\u0001\"a\u001a\u0002\n\u0002\u0007\u0011\u0011\u0013\t\u0004\u001b\u0005M\u0015bAAK\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005e\u0015\u0011\bC\u0001\u00037\u000bQ\u0001^8J]R$B!!%\u0002\u001e\"9\u0011qMAL\u0001\u0004A\u0002\u0002CAQ\u0003s!\t!a)\u0002\rQ|Gj\u001c8h)\u0011\ty!!*\t\u000f\u0005\u001d\u0014q\u0014a\u00011!A\u0011\u0011VA\u001d\t\u0003\tY+A\u0004u_\u001acw.\u0019;\u0015\t\u00055\u00161\u0017\t\u0004\u001b\u0005=\u0016bAAY\u001d\t)a\t\\8bi\"9\u0011qMAT\u0001\u0004A\u0002\u0002CA\\\u0003s!\t!!/\u0002\u0011Q|Gi\\;cY\u0016$B!a\b\u0002<\"9\u0011qMA[\u0001\u0004A\u0002\u0002CA`\u0003s!\t!!1\u0002\u000f\r|W\u000e]1sKR1\u0011\u0011SAb\u0003\u000bDq!a\u001a\u0002>\u0002\u0007\u0001\u0004C\u0004\u0002l\u0005u\u0006\u0019\u0001\r")
public final class MoneyConversions {
    public static <A> MoneyConversions<A> MoneyConversions(A a, Numeric<A> numeric) {
        return MoneyConversions$.MODULE$.MoneyConversions(a, numeric);
    }

    public static MoneyConversions<BigDecimal> fromDouble(double d) {
        return MoneyConversions$.MODULE$.fromDouble(d);
    }

    public static MoneyConversions<BigDecimal> fromLong(long l) {
        return MoneyConversions$.MODULE$.fromLong(l);
    }

    public static Money yen() {
        return MoneyConversions$.MODULE$.yen();
    }

    public static Money euro() {
        return MoneyConversions$.MODULE$.euro();
    }

    public static Money dollar() {
        return MoneyConversions$.MODULE$.dollar();
    }

    public static class MoneyNumeric
    implements Numeric<Money> {
        private final MoneyContext mc;

        public Object zero() {
            return Numeric.class.zero((Numeric)this);
        }

        public Object one() {
            return Numeric.class.one((Numeric)this);
        }

        public Object abs(Object x) {
            return Numeric.class.abs((Numeric)this, (Object)x);
        }

        public int signum(Object x) {
            return Numeric.class.signum((Numeric)this, (Object)x);
        }

        public Numeric.Ops mkNumericOps(Object lhs) {
            return Numeric.class.mkNumericOps((Numeric)this, (Object)lhs);
        }

        public Some tryCompare(Object x, Object y) {
            return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
        }

        public Object max(Object x, Object y) {
            return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
        }

        public Object min(Object x, Object y) {
            return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
        }

        public Ordering<Money> reverse() {
            return Ordering.class.reverse((Ordering)this);
        }

        public <U> Ordering<U> on(Function1<U, Money> f) {
            return Ordering.class.on((Ordering)this, f);
        }

        public Ordering.Ops mkOrderingOps(Object lhs) {
            return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
        }

        public Money plus(Money x, Money y) {
            return x.$plus(y, this.mc);
        }

        public Money minus(Money x, Money y) {
            return x.$minus(y, this.mc);
        }

        public Nothing$ times(Money x, Money y) {
            throw new UnsupportedOperationException("Numeric.times not supported for Quantities");
        }

        public Money negate(Money x) {
            return (Money)x.unary_$minus();
        }

        public Money fromInt(int x) {
            return this.mc.defaultCurrency().apply(BoxesRunTime.boxToInteger((int)x), (Numeric)Numeric.IntIsIntegral$.MODULE$);
        }

        public int toInt(Money x) {
            return (int)x.value();
        }

        public long toLong(Money x) {
            return (long)x.value();
        }

        public float toFloat(Money x) {
            return (float)x.value();
        }

        public double toDouble(Money x) {
            return x.value();
        }

        public int compare(Money x, Money y) {
            return x.value() > y.value() ? 1 : (x.value() < y.value() ? -1 : 0);
        }

        public MoneyNumeric(MoneyContext mc) {
            this.mc = mc;
            PartialOrdering.class.$init$((PartialOrdering)this);
            Ordering.class.$init$((Ordering)this);
            Numeric.class.$init$((Numeric)this);
        }
    }

    public static class MoneyConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public Money money(MoneyContext context) {
            return Money$.MODULE$.apply(this.n, context.defaultCurrency(), this.num);
        }

        public Money XAU() {
            return Money$.MODULE$.apply(this.n, XAU$.MODULE$, this.num);
        }

        public Money XAG() {
            return Money$.MODULE$.apply(this.n, XAG$.MODULE$, this.num);
        }

        public Money USD() {
            return Money$.MODULE$.apply(this.n, USD$.MODULE$, this.num);
        }

        public Money dollars() {
            return this.USD();
        }

        public Money cents() {
            return Money$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.num.toDouble(this.n) / 100.0)), USD$.MODULE$, Numeric.DoubleIsFractional$.MODULE$);
        }

        public Money EUR() {
            return Money$.MODULE$.apply(this.n, EUR$.MODULE$, this.num);
        }

        public Money euros() {
            return this.EUR();
        }

        public Money JPY() {
            return Money$.MODULE$.apply(this.n, JPY$.MODULE$, this.num);
        }

        public Money yen() {
            return this.JPY();
        }

        public Money GBP() {
            return Money$.MODULE$.apply(this.n, GBP$.MODULE$, this.num);
        }

        public Money poundSterling() {
            return this.GBP();
        }

        public Money CHF() {
            return Money$.MODULE$.apply(this.n, CHF$.MODULE$, this.num);
        }

        public Money swissFrancs() {
            return this.CHF();
        }

        public Money AUD() {
            return Money$.MODULE$.apply(this.n, AUD$.MODULE$, this.num);
        }

        public Money CAD() {
            return Money$.MODULE$.apply(this.n, CAD$.MODULE$, this.num);
        }

        public Money SEK() {
            return Money$.MODULE$.apply(this.n, SEK$.MODULE$, this.num);
        }

        public Money HKD() {
            return Money$.MODULE$.apply(this.n, HKD$.MODULE$, this.num);
        }

        public Money NOK() {
            return Money$.MODULE$.apply(this.n, NOK$.MODULE$, this.num);
        }

        public Money NZD() {
            return Money$.MODULE$.apply(this.n, NZD$.MODULE$, this.num);
        }

        public Money BTC() {
            return Money$.MODULE$.apply(this.n, BTC$.MODULE$, this.num);
        }

        public Money bitCoin() {
            return this.BTC();
        }

        public MoneyConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }
    }
}

