/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BtusPerHour$;
import squants.energy.Energy;
import squants.energy.Gigawatts$;
import squants.energy.Kilowatts$;
import squants.energy.Megawatts$;
import squants.energy.Milliwatts$;
import squants.energy.Power$;
import squants.energy.PowerRamp;
import squants.energy.PowerUnit;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.energy.WattsPerHour$;
import squants.package$;
import squants.radio.Irradiance;
import squants.radio.RadiantIntensity;
import squants.radio.SpectralPower;
import squants.radio.WattsPerMeter$;
import squants.radio.WattsPerSquareMeter$;
import squants.radio.WattsPerSteradian$;
import squants.space.Area;
import squants.space.Length;
import squants.space.SolidAngle;
import squants.space.SquareMeters$;
import squants.space.SquaredRadians$;
import squants.space.Volume;
import squants.time.Hours$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeDerivative$class;
import squants.time.TimeIntegral;
import squants.time.TimeIntegral$class;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0005\u001d\u0011Q\u0001U8xKJT!a\u0001\u0003\u0002\r\u0015tWM]4z\u0015\u0005)\u0011aB:rk\u0006tGo]\u0002\u0001'\u0011\u0001\u0001BD\f\u0011\u0007%QA\"D\u0001\u0005\u0013\tYAA\u0001\u0005Rk\u0006tG/\u001b;z!\ti\u0001!D\u0001\u0003!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0005i&lW-\u0003\u0002\u0014!\tqA+[7f\t\u0016\u0014\u0018N^1uSZ,\u0007CA\u0007\u0016\u0013\t1\"A\u0001\u0004F]\u0016\u0014x-\u001f\t\u0004\u001faQ\u0012BA\r\u0011\u00051!\u0016.\\3J]R,wM]1m!\ti1$\u0003\u0002\u001d\u0005\tI\u0001k\\<feJ\u000bW\u000e\u001d\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005)a/\u00197vKV\t\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004E_V\u0014G.\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005A\u00051a/\u00197vK\u0002B\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAK\u0001\u0005k:LG/F\u0001,!\tiA&\u0003\u0002.\u0005\tI\u0001k\\<feVs\u0017\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005W\u0005)QO\\5uA!)\u0011\u0007\u0001C\u0005e\u00051A(\u001b8jiz\"2\u0001D\u001a5\u0011\u0015q\u0002\u00071\u0001!\u0011\u0015I\u0003\u00071\u0001,\u0011\u00151\u0004\u0001\"\u00018\u0003%!\u0017.\\3og&|g.F\u00019\u001d\ti\u0011hB\u0003;\u0005!\u00051(A\u0003Q_^,'\u000f\u0005\u0002\u000ey\u0019)\u0011A\u0001E\u0001{M!AHP!E!\t\ts(\u0003\u0002AE\t1\u0011I\\=SK\u001a\u00042!\u0003\"\r\u0013\t\u0019EAA\u0005ES6,gn]5p]B\u0011\u0011%R\u0005\u0003\r\n\u0012AbU3sS\u0006d\u0017N_1cY\u0016DQ!\r\u001f\u0005\u0002!#\u0012a\u000f\u0005\u0007\u0015r\"\tAA&\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u00051sFcA'hSR\u0011AB\u0014\u0005\u0006\u001f&\u0003\u001d\u0001U\u0001\u0004]Vl\u0007cA)Z9:\u0011!k\u0016\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0005a\u0013\u0013a\u00029bG.\fw-Z\u0005\u00035n\u0013qAT;nKJL7M\u0003\u0002YEA\u0011QL\u0018\u0007\u0001\t\u0015y\u0016J1\u0001a\u0005\u0005\t\u0015CA1e!\t\t#-\u0003\u0002dE\t9aj\u001c;iS:<\u0007CA\u0011f\u0013\t1'EA\u0002B]fDQ\u0001[%A\u0002q\u000b\u0011A\u001c\u0005\u0006S%\u0003\ra\u000b\u0005\u0006\u0015r\"\ta\u001b\u000b\u0004\u00191l\u0007\"B\u0002k\u0001\u0004!\u0002\"B\tk\u0001\u0004q\u0007CA8t\u001d\t\u0001(O\u0004\u0002Tc&\tQ!\u0003\u0002Y\t%\u0011A/\u001e\u0002\u0005)&lWM\u0003\u0002Y\t!)!\n\u0010C\u0001oV\t\u0001\u0010\u0005\u0003\"s\u0012\\\u0018B\u0001>#\u0005%1UO\\2uS>t\u0017\u0007E\u0002}\u007f2i\u0011! \u0006\u0003}\n\nA!\u001e;jY&\u0019\u0011\u0011A?\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002\u0006q\"\t!a\u0002\u0002\t9\fW.Z\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003mC:<'BAA\n\u0003\u0011Q\u0017M^1\n\t\u0005]\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005mA\b\"\u0001\u0002\u001e\u0005Y\u0001O]5nCJLXK\\5u+\t\tyBD\u0002\u000e\u0003CI1!a\t\u0003\u0003\u00159\u0016\r\u001e;t\u0011\u001d\t9\u0003\u0010C\u0001\u0003;\taa]5V]&$\bbBA\u0016y\u0011\u0005\u0011QF\u0001\u0006k:LGo]\u000b\u0003\u0003_\u0001b!!\r\u0002<\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013%lW.\u001e;bE2,'bAA\u001dE\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0004'\u0016$\b\u0003B\u0005\u0002B1I1!a\u0011\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u0011q\t\u001f\u0002\u0002\u0013%\u0011\u0011J\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002LA!\u00111BA'\u0013\u0011\ty%!\u0004\u0003\r=\u0013'.Z2u\u0011!\t\u0019\u0006\u0001C\t\t\u0005U\u0013A\u0004;j[\u0016Le\u000e^3he\u0006$X\rZ\u000b\u0002)!9\u0011\u0011\f\u0001\u0005\u0012\u0005m\u0013a\u0003;j[\u0016$UM]5wK\u0012,\u0012A\u0007\u0005\b#\u0001!\t\u0002BA0+\t\t\t\u0007E\u0002\u0010\u0003GJ!\u0001\u001e\t\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005!A\u0005Z5w)\u0011\tY'a\u001e\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d\u0005\u0003\u0015\u0011\u0018\rZ5p\u0013\u0011\t)(a\u001c\u0003\u001bM\u0003Xm\u0019;sC2\u0004vn^3s\u0011!\tI(!\u001aA\u0002\u0005m\u0014\u0001\u0002;iCR\u00042a\\A?\u0013\r\ty(\u001e\u0002\u0007\u0019\u0016tw\r\u001e5\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002\u0004R!\u00111PAC\u0011!\tI(!!A\u0002\u0005-\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u0012\u000b\u0005\u0003\u0017\u000b\t\n\u0005\u0003\u0002n\u00055\u0015\u0002BAH\u0003_\u0012!\"\u0013:sC\u0012L\u0017M\\2f\u0011!\tI(a\"A\u0002\u0005M\u0005cA8\u0002\u0016&\u0019\u0011qS;\u0003\t\u0005\u0013X-\u0019\u0005\b\u0003O\u0002A\u0011AAN)\u0011\t\u0019*!(\t\u0011\u0005e\u0014\u0011\u0014a\u0001\u0003\u0017Cq!a\u001a\u0001\t\u0003\t\t\u000b\u0006\u0003\u0002$\u0006=\u0006\u0003BAS\u0003Wk!!a*\u000b\u0007\u0005%F!A\u0003ta\u0006\u001cW-\u0003\u0003\u0002.\u0006\u001d&AC*pY&$\u0017I\\4mK\"A\u0011\u0011PAP\u0001\u0004\t\t\f\u0005\u0003\u0002n\u0005M\u0016\u0002BA[\u0003_\u0012\u0001CU1eS\u0006tG/\u00138uK:\u001c\u0018\u000e^=\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002:R!\u0011\u0011WA^\u0011!\tI(a.A\u0002\u0005\r\u0006bBA4\u0001\u0011\u0005\u0011q\u0018\u000b\u0005\u0003\u0003\fi\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\rB\u0001\bK2,7\r\u001e:p\u0013\u0011\tY-!2\u0003\u001f\u0015cWm\u0019;sS\u000e\u001cUO\u001d:f]RD\u0001\"!\u001f\u0002>\u0002\u0007\u0011q\u001a\t\u0005\u0003\u0007\f\t.\u0003\u0003\u0002T\u0006\u0015'!E#mK\u000e$(/[2Q_R,g\u000e^5bY\"9\u0011q\r\u0001\u0005\u0002\u0005]G\u0003BAh\u00033D\u0001\"!\u001f\u0002V\u0002\u0007\u0011\u0011\u0019\u0005\b\u0003O\u0002A\u0011AAo)\r\t\u0017q\u001c\u0005\t\u0003s\nY\u000e1\u0001\u0002bB\u0019q.a9\n\u0007\u0005\u0015XO\u0001\u0004W_2,X.\u001a\u0005\u0007\u0003S\u0004A\u0011A\u0010\u0002\u0019Q|W*\u001b7mS^\fG\u000f^:\t\r\u00055\b\u0001\"\u0001 \u0003\u001d!xnV1uiNDa!!=\u0001\t\u0003y\u0012a\u0003;p\u0017&dwn^1uiNDa!!>\u0001\t\u0003y\u0012a\u0003;p\u001b\u0016<\u0017m^1uiNDa!!?\u0001\t\u0003y\u0012a\u0003;p\u000f&<\u0017m^1uiNDa!!@\u0001\t\u0003y\u0012!\u0004;p\u0005R,8\u000fU3s\u0011>,(\u000f")
public final class Power
extends Quantity<Power>
implements TimeDerivative<Energy>,
TimeIntegral<PowerRamp> {
    private final double value;
    private final PowerUnit unit;

    public static Try<Power> parse(Object object) {
        return Power$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<Power>> symbolToUnit(String string) {
        return Power$.MODULE$.symbolToUnit(string);
    }

    public static Set<UnitOfMeasure<Power>> units() {
        return Power$.MODULE$.units();
    }

    public static Watts$ siUnit() {
        return Power$.MODULE$.siUnit();
    }

    public static Watts$ primaryUnit() {
        return Power$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Power$.MODULE$.name();
    }

    public static Function1<Object, Try<Power>> apply() {
        return Power$.MODULE$.apply();
    }

    public static Power apply(Energy energy, Time time) {
        return Power$.MODULE$.apply(energy, time);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral$class.per(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative$class.$times(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public PowerUnit unit() {
        return this.unit;
    }

    public Power$ dimension() {
        return Power$.MODULE$;
    }

    @Override
    public Energy timeIntegrated() {
        return WattHours$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public PowerRamp timeDerived() {
        return WattsPerHour$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public SpectralPower $div(Length that) {
        return WattsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(SpectralPower that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Irradiance $div(Area that) {
        return WattsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Irradiance that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SolidAngle $div(RadiantIntensity that) {
        return SquaredRadians$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSteradian())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $div(SolidAngle that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSteradians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricPotential that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Volume that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public double toMilliwatts() {
        return this.to(Milliwatts$.MODULE$);
    }

    public double toWatts() {
        return this.to(Watts$.MODULE$);
    }

    public double toKilowatts() {
        return this.to(Kilowatts$.MODULE$);
    }

    public double toMegawatts() {
        return this.to(Megawatts$.MODULE$);
    }

    public double toGigawatts() {
        return this.to(Gigawatts$.MODULE$);
    }

    public double toBtusPerHour() {
        return this.to(BtusPerHour$.MODULE$);
    }

    public Power(double value, PowerUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative$class.$init$(this);
        TimeIntegral$class.$init$(this);
    }
}

