/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BritishThermalUnits$;
import squants.energy.Energy$;
import squants.energy.EnergyDensity;
import squants.energy.EnergyUnit;
import squants.energy.Gigajoules$;
import squants.energy.GigawattHours$;
import squants.energy.Grays$;
import squants.energy.Joules$;
import squants.energy.JoulesPerCubicMeter$;
import squants.energy.Kilojoules$;
import squants.energy.KilowattHours$;
import squants.energy.MBtus$;
import squants.energy.MMBtus$;
import squants.energy.Megajoules$;
import squants.energy.MegawattHours$;
import squants.energy.Microjoules$;
import squants.energy.Millijoules$;
import squants.energy.Nanojoules$;
import squants.energy.Picojoules$;
import squants.energy.Power;
import squants.energy.PowerRamp;
import squants.energy.SpecificEnergy;
import squants.energy.Terajoules$;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.mass.ChemicalAmount;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.Newtons$;
import squants.package$;
import squants.space.Angle;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.Length;
import squants.space.Volume;
import squants.thermal.JoulesPerKelvin$;
import squants.thermal.Kelvin$;
import squants.thermal.Temperature;
import squants.thermal.ThermalCapacity;
import squants.time.Hours$;
import squants.time.SecondTimeDerivative;
import squants.time.SecondTimeIntegral;
import squants.time.SecondTimeIntegral$class;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeIntegral$class;
import squants.time.TimeSquared;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0001\u0003\u0005\u001d\u0011a!\u00128fe\u001eL(BA\u0002\u0005\u0003\u0019)g.\u001a:hs*\tQ!A\u0004tcV\fg\u000e^:\u0004\u0001M!\u0001\u0001\u0003\b\u0018!\rI!\u0002D\u0007\u0002\t%\u00111\u0002\u0002\u0002\t#V\fg\u000e^5usB\u0011Q\u0002A\u0007\u0002\u0005A\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\tQLW.Z\u0005\u0003'A\u0011A\u0002V5nK&sG/Z4sC2\u0004\"!D\u000b\n\u0005Y\u0011!!\u0002)po\u0016\u0014\bcA\b\u00195%\u0011\u0011\u0004\u0005\u0002\u0013'\u0016\u001cwN\u001c3US6,\u0017J\u001c;fOJ\fG\u000e\u0005\u0002\u000e7%\u0011AD\u0001\u0002\n!><XM\u001d*b[BD\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0006m\u0006dW/Z\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1Ai\\;cY\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002)\nA!\u001e8jiV\t1\u0006\u0005\u0002\u000eY%\u0011QF\u0001\u0002\u000b\u000b:,'oZ=V]&$\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u000bUt\u0017\u000e\u001e\u0011\t\u000bE\u0002A\u0011\u0002\u001a\u0002\rqJg.\u001b;?)\ra1\u0007\u000e\u0005\u0006=A\u0002\r\u0001\t\u0005\u0006SA\u0002\ra\u000b\u0005\u0006m\u0001!\taN\u0001\nI&lWM\\:j_:,\u0012\u0001\u000f\b\u0003\u001be:QA\u000f\u0002\t\u0002m\na!\u00128fe\u001eL\bCA\u0007=\r\u0015\t!\u0001#\u0001>'\u0011ad(\u0011#\u0011\u0005\u0005z\u0014B\u0001!#\u0005\u0019\te.\u001f*fMB\u0019\u0011B\u0011\u0007\n\u0005\r#!!\u0003#j[\u0016t7/[8o!\t\tS)\u0003\u0002GE\ta1+\u001a:jC2L'0\u00192mK\")\u0011\u0007\u0010C\u0001\u0011R\t1\b\u0003\u0004Ky\u0011\u0005!aS\u0001\u0006CB\u0004H._\u000b\u0003\u0019z#2!T4j)\taa\nC\u0003P\u0013\u0002\u000f\u0001+A\u0002ok6\u00042!U-]\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V\r\u00051AH]8pizJ\u0011aI\u0005\u00031\n\nq\u0001]1dW\u0006<W-\u0003\u0002[7\n9a*^7fe&\u001c'B\u0001-#!\tif\f\u0004\u0001\u0005\u000b}K%\u0019\u00011\u0003\u0003\u0005\u000b\"!\u00193\u0011\u0005\u0005\u0012\u0017BA2#\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!I3\n\u0005\u0019\u0014#aA!os\")\u0001.\u0013a\u00019\u0006\ta\u000eC\u0003*\u0013\u0002\u00071\u0006C\u0003Ky\u0011\u00051\u000eF\u0002\rY:DQ!\u001c6A\u0002Q\tA\u0001\\8bI\")\u0011C\u001ba\u0001_B\u0011q\u0002]\u0005\u0003cB\u0011A\u0001V5nK\")!\n\u0010C\u0001gV\tA\u000f\u0005\u0003\"k\u0012<\u0018B\u0001<#\u0005%1UO\\2uS>t\u0017\u0007E\u0002yw2i\u0011!\u001f\u0006\u0003u\n\nA!\u001e;jY&\u0011A0\u001f\u0002\u0004)JL\b\"\u0002@=\t\u0003y\u0018\u0001\u00028b[\u0016,\"!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!A.\u00198h\u0015\t\tY!\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003\u000b\u0011aa\u0015;sS:<\u0007bBA\ny\u0011\u0005\u0011QC\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002\u00189\u0019Q\"!\u0007\n\u0007\u0005m!!A\u0005XCR$\bj\\;sg\"9\u0011q\u0004\u001f\u0005\u0002\u0005\u0005\u0012AB:j+:LG/\u0006\u0002\u0002$9\u0019Q\"!\n\n\u0007\u0005\u001d\"!\u0001\u0004K_VdWm\u001d\u0005\b\u0003WaD\u0011AA\u0017\u0003\u0015)h.\u001b;t+\t\ty\u0003\u0005\u0004\u00022\u0005m\u0012qH\u0007\u0003\u0003gQA!!\u000e\u00028\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s\u0011\u0013AC2pY2,7\r^5p]&!\u0011QHA\u001a\u0005\r\u0019V\r\u001e\t\u0005\u0013\u0005\u0005C\"C\u0002\u0002D\u0011\u0011Q\"\u00168ji>3W*Z1tkJ,\u0007\"CA$y\u0005\u0005I\u0011BA%\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005-\u0003\u0003BA\u0002\u0003\u001bJA!a\u0014\u0002\u0006\t1qJ\u00196fGRDq!a\u0015\u0001\t#\t)&A\u0006uS6,G)\u001a:jm\u0016$W#\u0001\u000b\t\rE\u0001A\u0011CA-+\u0005y\u0007bBA/\u0001\u0011\u0005\u0011qL\u0001\u0005I\u0011Lg\u000f\u0006\u0003\u0002b\u0005E\u0004\u0003BA2\u0003WrA!!\u001a\u0002j9\u00191+a\u001a\n\u0003\u0015I!\u0001\u0017\u0003\n\t\u00055\u0014q\u000e\u0002\u0006\r>\u00148-\u001a\u0006\u00031\u0012A\u0001\"a\u001d\u0002\\\u0001\u0007\u0011QO\u0001\u0005i\"\fG\u000f\u0005\u0003\u0002d\u0005]\u0014\u0002BA=\u0003_\u0012a\u0001T3oORD\u0007bBA/\u0001\u0011\u0005\u0011Q\u0010\u000b\u0005\u0003k\ny\b\u0003\u0005\u0002t\u0005m\u0004\u0019AA1\u0011\u001d\ti\u0006\u0001C\u0001\u0003\u0007#B!!\"\u0002\fB\u0019Q\"a\"\n\u0007\u0005%%A\u0001\bTa\u0016\u001c\u0017NZ5d\u000b:,'oZ=\t\u0011\u0005M\u0014\u0011\u0011a\u0001\u0003\u001b\u0003B!a\u0019\u0002\u0010&!\u0011\u0011SA8\u0005\u0011i\u0015m]:\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u0016R!\u0011QRAL\u0011!\t\u0019(a%A\u0002\u0005\u0015\u0005bBA/\u0001\u0011\u0005\u00111\u0014\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002\u000e\u0003?K1!!)\u0003\u00055)e.\u001a:hs\u0012+gn]5us\"A\u00111OAM\u0001\u0004\t)\u000b\u0005\u0003\u0002d\u0005\u001d\u0016\u0002BAU\u0003_\u0012aAV8mk6,\u0007bBA/\u0001\u0011\u0005\u0011Q\u0016\u000b\u0005\u0003K\u000by\u000b\u0003\u0005\u0002t\u0005-\u0006\u0019AAO\u0011\u001d\ti\u0006\u0001C\u0001\u0003g#B!!.\u0002BB!\u0011qWA_\u001b\t\tILC\u0002\u0002<\u0012\tq!\u001a7fGR\u0014x.\u0003\u0003\u0002@\u0006e&!E#mK\u000e$(/[2Q_R,g\u000e^5bY\"A\u00111OAY\u0001\u0004\t\u0019\r\u0005\u0003\u00028\u0006\u0015\u0017\u0002BAd\u0003s\u0013a\"\u00127fGR\u0014\u0018nY\"iCJ<W\rC\u0004\u0002^\u0001!\t!a3\u0015\t\u0005\r\u0017Q\u001a\u0005\t\u0003g\nI\r1\u0001\u00026\"9\u0011Q\f\u0001\u0005\u0002\u0005EG\u0003BAj\u0003?\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0004\u00033$\u0011a\u0002;iKJl\u0017\r\\\u0005\u0005\u0003;\f9NA\bUQ\u0016\u0014X.\u00197DCB\f7-\u001b;z\u0011!\t\u0019(a4A\u0002\u0005\u0005\b\u0003BA2\u0003GLA!!:\u0002p\tYA+Z7qKJ\fG/\u001e:f\u0011\u001d\ti\u0006\u0001C\u0001\u0003S$B!a;\u0002pB!\u0011Q[Aw\u0013\u0011\t)/a6\t\u0011\u0005M\u0014q\u001da\u0001\u0003'Dq!!\u0018\u0001\t\u0003\t\u0019\u0010F\u0002b\u0003kD\u0001\"a\u001d\u0002r\u0002\u0007\u0011q\u001f\t\u0005\u0003s\fy0\u0004\u0002\u0002|*\u0019\u0011Q \u0003\u0002\t5\f7o]\u0005\u0005\u0005\u0003\tYP\u0001\bDQ\u0016l\u0017nY1m\u00036|WO\u001c;\t\u000f\u0005u\u0003\u0001\"\u0001\u0003\u0006Q\u0019\u0011Ma\u0002\t\u0011\u0005M$1\u0001a\u0001\u0005\u0013\u0001B!a\u0019\u0003\f%!!QBA8\u0005\u0015\ten\u001a7f\u0011\u001d\ti\u0006\u0001C\u0001\u0005#!2!\u0019B\n\u0011!\t\u0019Ha\u0004A\u0002\tU\u0001\u0003BA2\u0005/IAA!\u0007\u0002p\t!\u0011I]3b\u0011\u001d\ti\u0006\u0001C\u0001\u0005;!2A\u0007B\u0010\u0011!\t\u0019Ha\u0007A\u0002\t\u0005\u0002cA\b\u0003$%\u0019!Q\u0005\t\u0003\u0017QKW.Z*rk\u0006\u0014X\r\u001a\u0005\b\u0003;\u0002A\u0011\u0001B\u0015)\u0011\u0011\tCa\u000b\t\u000f\u0005M$q\u0005a\u00015!1!q\u0006\u0001\u0005\u0002}\t1\u0002^8XCR$\bj\\;sg\"1!1\u0007\u0001\u0005\u0002}\tq\u0002^8LS2|w/\u0019;u\u0011>,(o\u001d\u0005\u0007\u0005o\u0001A\u0011A\u0010\u0002\u001fQ|W*Z4bo\u0006$H\u000fS8veNDaAa\u000f\u0001\t\u0003y\u0012a\u0004;p\u000f&<\u0017m^1ui\"{WO]:\t\r\t}\u0002\u0001\"\u0001 \u0003!!xNS8vY\u0016\u001c\bB\u0002B\"\u0001\u0011\u0005q$\u0001\u0007u_BK7m\u001c6pk2,7\u000f\u0003\u0004\u0003H\u0001!\taH\u0001\ri>t\u0015M\\8k_VdWm\u001d\u0005\u0007\u0005\u0017\u0002A\u0011A\u0010\u0002\u001bQ|W*[2s_*|W\u000f\\3t\u0011\u0019\u0011y\u0005\u0001C\u0001?\u0005iAo\\'jY2L'n\\;mKNDaAa\u0015\u0001\t\u0003y\u0012\u0001\u0004;p\u0017&dwN[8vY\u0016\u001c\bB\u0002B,\u0001\u0011\u0005q$\u0001\u0007u_6+w-\u00196pk2,7\u000f\u0003\u0004\u0003\\\u0001!\taH\u0001\ri><\u0015nZ1k_VdWm\u001d\u0005\u0007\u0005?\u0002A\u0011A\u0010\u0002\u0019Q|G+\u001a:bU>,H.Z:\t\r\t\r\u0004\u0001\"\u0001 \u0003\u0019!xN\u0011;vg\"1!q\r\u0001\u0005\u0002}\tq\u0001^8N\u0005R,8\u000f\u0003\u0004\u0003l\u0001!\taH\u0001\ti>lUJ\u0011;vg\u0002")
public final class Energy
extends Quantity<Energy>
implements TimeIntegral<Power>,
SecondTimeIntegral<PowerRamp> {
    private final double value;
    private final EnergyUnit unit;

    public static Try<Energy> parse(Object object) {
        return Energy$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<Energy>> symbolToUnit(String string) {
        return Energy$.MODULE$.symbolToUnit(string);
    }

    public static Set<UnitOfMeasure<Energy>> units() {
        return Energy$.MODULE$.units();
    }

    public static Joules$ siUnit() {
        return Energy$.MODULE$.siUnit();
    }

    public static WattHours$ primaryUnit() {
        return Energy$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Energy$.MODULE$.name();
    }

    public static Function1<Object, Try<Energy>> apply() {
        return Energy$.MODULE$.apply();
    }

    public static Energy apply(Power power, Time time) {
        return Energy$.MODULE$.apply(power, time);
    }

    @Override
    public SecondTimeDerivative per(TimeSquared that) {
        return SecondTimeIntegral$class.per(this, that);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral$class.per(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral$class.$div((Quantity)this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public EnergyUnit unit() {
        return this.unit;
    }

    public Energy$ dimension() {
        return Energy$.MODULE$;
    }

    @Override
    public Power timeDerived() {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWattHours()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $div(Length that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Force that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toNewtons())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SpecificEnergy $div(Mass that) {
        return Grays$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(SpecificEnergy that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public EnergyDensity $div(Volume that) {
        return JoulesPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(EnergyDensity that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCharge that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $div(ElectricPotential that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ThermalCapacity $div(Temperature that) {
        return JoulesPerKelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKelvinDegrees())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Temperature $div(ThermalCapacity that) {
        return Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerKelvin())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(ChemicalAmount that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ $div(Angle that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ $div(Area that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public PowerRamp $div(TimeSquared that) {
        return (PowerRamp)((TimeIntegral)((Object)this.$div(that.time1()))).$div(that.time2());
    }

    @Override
    public TimeSquared $div(PowerRamp that) {
        return this.$div(that.timeIntegrated()).$times(this.time());
    }

    public double toWattHours() {
        return this.to(WattHours$.MODULE$);
    }

    public double toKilowattHours() {
        return this.to(KilowattHours$.MODULE$);
    }

    public double toMegawattHours() {
        return this.to(MegawattHours$.MODULE$);
    }

    public double toGigawattHours() {
        return this.to(GigawattHours$.MODULE$);
    }

    public double toJoules() {
        return this.to(Joules$.MODULE$);
    }

    public double toPicojoules() {
        return this.to(Picojoules$.MODULE$);
    }

    public double toNanojoules() {
        return this.to(Nanojoules$.MODULE$);
    }

    public double toMicrojoules() {
        return this.to(Microjoules$.MODULE$);
    }

    public double toMillijoules() {
        return this.to(Millijoules$.MODULE$);
    }

    public double toKilojoules() {
        return this.to(Kilojoules$.MODULE$);
    }

    public double toMegajoules() {
        return this.to(Megajoules$.MODULE$);
    }

    public double toGigajoules() {
        return this.to(Gigajoules$.MODULE$);
    }

    public double toTerajoules() {
        return this.to(Terajoules$.MODULE$);
    }

    public double toBtus() {
        return this.to(BritishThermalUnits$.MODULE$);
    }

    public double toMBtus() {
        return this.to(MBtus$.MODULE$);
    }

    public double toMMBtus() {
        return this.to(MMBtus$.MODULE$);
    }

    public Energy(double value, EnergyUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral$class.$init$(this);
        SecondTimeIntegral$class.$init$(this);
    }
}

