/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Function1;
import scala.Option;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance$;
import squants.electro.ElectricalResistanceUnit;
import squants.electro.Gigohms$;
import squants.electro.Kilohms$;
import squants.electro.Megohms$;
import squants.electro.Microohms$;
import squants.electro.Milliohms$;
import squants.electro.Nanohms$;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0005\u001d\u0011A#\u00127fGR\u0014\u0018nY1m%\u0016\u001c\u0018n\u001d;b]\u000e,'BA\u0002\u0005\u0003\u001d)G.Z2ue>T\u0011!B\u0001\bgF,\u0018M\u001c;t\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0007%QA\"D\u0001\u0005\u0013\tYAA\u0001\u0005Rk\u0006tG/\u001b;z!\ti\u0001!D\u0001\u0003\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012!\u0002<bYV,W#A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0011{WO\u00197f\u0011!A\u0002A!A!\u0002\u0013\t\u0012A\u0002<bYV,\u0007\u0005\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\u0011)h.\u001b;\u0016\u0003q\u0001\"!D\u000f\n\u0005y\u0011!\u0001G#mK\u000e$(/[2bYJ+7/[:uC:\u001cW-\u00168ji\"A\u0001\u0005\u0001B\u0001B\u0003%A$A\u0003v]&$\b\u0005C\u0003#\u0001\u0011%1%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0019\u0011*\u0003\"B\b\"\u0001\u0004\t\u0002\"\u0002\u000e\"\u0001\u0004a\u0002\"B\u0014\u0001\t\u0003A\u0013!\u00033j[\u0016t7/[8o+\u0005IcBA\u0007+\u000f\u0015Y#\u0001#\u0001-\u0003Q)E.Z2ue&\u001c\u0017\r\u001c*fg&\u001cH/\u00198dKB\u0011Q\"\f\u0004\u0006\u0003\tA\tAL\n\u0005[=\u0012T\u0007\u0005\u0002\u0013a%\u0011\u0011g\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\u0019D\"\u0003\u00025\t\tIA)[7f]NLwN\u001c\t\u0003%YJ!aN\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\tjC\u0011A\u001d\u0015\u00031BaaO\u0017\u0005\u0002\ta\u0014!B1qa2LXCA\u001fP)\rq\u0004L\u0017\u000b\u0003\u0019}BQ\u0001\u0011\u001eA\u0004\u0005\u000b1A\\;n!\r\u0011%*\u0014\b\u0003\u0007\"s!\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012BA%\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0013'\u0003\u000f9+X.\u001a:jG*\u0011\u0011j\u0005\t\u0003\u001d>c\u0001\u0001B\u0003Qu\t\u0007\u0011KA\u0001B#\t\u0011V\u000b\u0005\u0002\u0013'&\u0011Ak\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0011b+\u0003\u0002X'\t\u0019\u0011I\\=\t\u000beS\u0004\u0019A'\u0002\u00039DQA\u0007\u001eA\u0002qAQaO\u0017\u0005\u0002q+\u0012!\u0018\t\u0005%y+\u0006-\u0003\u0002`'\tIa)\u001e8di&|g.\r\t\u0004C\u0012dQ\"\u00012\u000b\u0005\r\u001c\u0012\u0001B;uS2L!!\u001a2\u0003\u0007Q\u0013\u0018\u0010C\u0003h[\u0011\u0005\u0001.\u0001\u0003oC6,W#A5\u0011\u0005)|W\"A6\u000b\u00051l\u0017\u0001\u00027b]\u001eT\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\n11\u000b\u001e:j]\u001eDQA]\u0017\u0005\u0002M\f1\u0002\u001d:j[\u0006\u0014\u00180\u00168jiV\tAO\u0004\u0002\u000ek&\u0011aOA\u0001\u0005\u001f\"l7\u000fC\u0003y[\u0011\u00051/\u0001\u0004tSVs\u0017\u000e\u001e\u0005\u0006u6\"\ta_\u0001\u0006k:LGo]\u000b\u0002yB)Q0!\u0002\u0002\n5\taPC\u0002\u0000\u0003\u0003\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005\r1#\u0001\u0006d_2dWm\u0019;j_:L1!a\u0002\u007f\u0005\r\u0019V\r\u001e\t\u0005\u0013\u0005-A\"C\u0002\u0002\u000e\u0011\u0011Q\"\u00168ji>3W*Z1tkJ,\u0007\"CA\t[\u0005\u0005I\u0011BA\n\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0001c\u00016\u0002\u0018%\u0019\u0011\u0011D6\u0003\r=\u0013'.Z2u\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\ta\u0001\n;j[\u0016\u001cH\u0003BA\u0011\u0003O\u00012!DA\u0012\u0013\r\t)C\u0001\u0002\u0012\u000b2,7\r\u001e:jGB{G/\u001a8uS\u0006d\u0007\u0002CA\u0015\u00037\u0001\r!a\u000b\u0002\tQD\u0017\r\u001e\t\u0004\u001b\u00055\u0012bAA\u0018\u0005\tyQ\t\\3diJL7mQ;se\u0016tG\u000fC\u0004\u0002\u001e\u0001!\t!a\r\u0015\t\u0005U\u00121\b\t\u0004\u001b\u0005]\u0012bAA\u001d\u0005\tY!+Z:jgRLg/\u001b;z\u0011!\tI#!\rA\u0002\u0005u\u0002\u0003BA \u0003\u000frA!!\u0011\u0002F9\u0019A)a\u0011\n\u0003\u0015I!!\u0013\u0003\n\t\u0005%\u00131\n\u0002\u0007\u0019\u0016tw\r\u001e5\u000b\u0005%#\u0001BBA(\u0001\u0011\u0005\u0001#\u0001\u0004u_>CWn\u001d\u0005\u0007\u0003'\u0002A\u0011\u0001\t\u0002\u0013Q|g*\u00198pQ6\u001c\bBBA,\u0001\u0011\u0005\u0001#\u0001\u0006u_6K7M]8i[NDa!a\u0017\u0001\t\u0003\u0001\u0012A\u0003;p\u001b&dGn\u001c5ng\"1\u0011q\f\u0001\u0005\u0002A\t\u0011\u0002^8LS2|\u0007.\\:\t\r\u0005\r\u0004\u0001\"\u0001\u0011\u0003%!x.T3h_\"l7\u000f\u0003\u0004\u0002h\u0001!\t\u0001E\u0001\ni><\u0015nZ8i[NDq!a\u001b\u0001\t\u0003\ti'A\u0005j]NKW-\\3ogV\u0011\u0011q\u000e\t\u0004\u001b\u0005E\u0014bAA:\u0005\t)R\t\\3diJL7-\u00197D_:$Wo\u0019;b]\u000e,\u0007")
public final class ElectricalResistance
extends Quantity<ElectricalResistance> {
    private final double value;
    private final ElectricalResistanceUnit unit;

    public static Try<ElectricalResistance> parse(Object object) {
        return ElectricalResistance$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<ElectricalResistance>> symbolToUnit(String string) {
        return ElectricalResistance$.MODULE$.symbolToUnit(string);
    }

    public static Set<UnitOfMeasure<ElectricalResistance>> units() {
        return ElectricalResistance$.MODULE$.units();
    }

    public static Ohms$ siUnit() {
        return ElectricalResistance$.MODULE$.siUnit();
    }

    public static Ohms$ primaryUnit() {
        return ElectricalResistance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricalResistance$.MODULE$.name();
    }

    public static Function1<Object, Try<ElectricalResistance>> apply() {
        return ElectricalResistance$.MODULE$.apply();
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalResistanceUnit unit() {
        return this.unit;
    }

    public ElectricalResistance$ dimension() {
        return ElectricalResistance$.MODULE$;
    }

    public ElectricPotential $times(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity $times(Length that) {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhms() {
        return this.to(Ohms$.MODULE$);
    }

    public double toNanohms() {
        return this.to(Nanohms$.MODULE$);
    }

    public double toMicrohms() {
        return this.to(Microohms$.MODULE$);
    }

    public double toMillohms() {
        return this.to(Milliohms$.MODULE$);
    }

    public double toKilohms() {
        return this.to(Kilohms$.MODULE$);
    }

    public double toMegohms() {
        return this.to(Megohms$.MODULE$);
    }

    public double toGigohms() {
        return this.to(Gigohms$.MODULE$);
    }

    public ElectricalConductance inSiemens() {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.to(Ohms$.MODULE$))), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance(double value, ElectricalResistanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

