/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.Capacitance;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential$;
import squants.electro.ElectricPotentialUnit;
import squants.electro.ElectricalResistance;
import squants.electro.Kilovolts$;
import squants.electro.MagneticFlux;
import squants.electro.Megavolts$;
import squants.electro.Microvolts$;
import squants.electro.Millivolts$;
import squants.electro.Ohms$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Length;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeDerivative$class;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0005\u001d\u0011\u0011#\u00127fGR\u0014\u0018n\u0019)pi\u0016tG/[1m\u0015\t\u0019A!A\u0004fY\u0016\u001cGO]8\u000b\u0003\u0015\tqa]9vC:$8o\u0001\u0001\u0014\u0007\u0001Aa\u0002E\u0002\n\u00151i\u0011\u0001B\u0005\u0003\u0017\u0011\u0011\u0001\"U;b]RLG/\u001f\t\u0003\u001b\u0001i\u0011A\u0001\t\u0004\u001fI!R\"\u0001\t\u000b\u0005E!\u0011\u0001\u0002;j[\u0016L!a\u0005\t\u0003\u001dQKW.\u001a#fe&4\u0018\r^5wKB\u0011Q\"F\u0005\u0003-\t\u0011A\"T1h]\u0016$\u0018n\u0019$mkbD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\u0006m\u0006dW/Z\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1Ai\\;cY\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nA!\u001e8jiV\tQ\u0005\u0005\u0002\u000eM%\u0011qE\u0001\u0002\u0016\u000b2,7\r\u001e:jGB{G/\u001a8uS\u0006dWK\\5u\u0011!I\u0003A!A!\u0002\u0013)\u0013!B;oSR\u0004\u0003\"B\u0016\u0001\t\u0013a\u0013A\u0002\u001fj]&$h\bF\u0002\r[9BQ\u0001\u0007\u0016A\u0002iAQa\t\u0016A\u0002\u0015BQ\u0001\r\u0001\u0005\u0002E\n\u0011\u0002Z5nK:\u001c\u0018n\u001c8\u0016\u0003Ir!!D\u001a\b\u000bQ\u0012\u0001\u0012A\u001b\u0002#\u0015cWm\u0019;sS\u000e\u0004v\u000e^3oi&\fG\u000e\u0005\u0002\u000em\u0019)\u0011A\u0001E\u0001oM!a\u0007O\u001e?!\tY\u0012(\u0003\u0002;9\t1\u0011I\\=SK\u001a\u00042!\u0003\u001f\r\u0013\tiDAA\u0005ES6,gn]5p]B\u00111dP\u0005\u0003\u0001r\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQa\u000b\u001c\u0005\u0002\t#\u0012!\u000e\u0005\u0007\tZ\"\tAA#\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0005\u0019CFcA$bGR\u0011A\u0002\u0013\u0005\u0006\u0013\u000e\u0003\u001dAS\u0001\u0004]Vl\u0007cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005Ic\u0012a\u00029bG.\fw-Z\u0005\u0003)V\u0013qAT;nKJL7M\u0003\u0002S9A\u0011q\u000b\u0017\u0007\u0001\t\u0015I6I1\u0001[\u0005\u0005\t\u0015CA._!\tYB,\u0003\u0002^9\t9aj\u001c;iS:<\u0007CA\u000e`\u0013\t\u0001GDA\u0002B]fDQAY\"A\u0002Y\u000b\u0011A\u001c\u0005\u0006G\r\u0003\r!\n\u0005\u0006\tZ\"\t!Z\u000b\u0002MB!1d\u001a0j\u0013\tAGDA\u0005Gk:\u001cG/[8ocA\u0019!.\u001c\u0007\u000e\u0003-T!\u0001\u001c\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003].\u00141\u0001\u0016:z\u0011\u0015\u0001h\u0007\"\u0001r\u0003\u0011q\u0017-\\3\u0016\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\t1\fgn\u001a\u0006\u0002o\u0006!!.\u0019<b\u0013\tIHO\u0001\u0004TiJLgn\u001a\u0005\u0006wZ\"\t\u0001`\u0001\faJLW.\u0019:z+:LG/F\u0001~\u001d\tia0\u0003\u0002\u0000\u0005\u0005)ak\u001c7ug\"1\u00111\u0001\u001c\u0005\u0002q\faa]5V]&$\bbBA\u0004m\u0011\u0005\u0011\u0011B\u0001\u0006k:LGo]\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u0018\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0013%lW.\u001e;bE2,'bAA\u000b9\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\u0004'\u0016$\b\u0003B\u0005\u0002\u001e1I1!a\b\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u00111\u0005\u001c\u0002\u0002\u0013%\u0011QE\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002(A\u00191/!\u000b\n\u0007\u0005-BO\u0001\u0004PE*,7\r\u001e\u0005\t\u0003_\u0001A\u0011\u0003\u0003\u00022\u0005qA/[7f\u0013:$Xm\u001a:bi\u0016$W#\u0001\u000b\t\u000fE\u0001A\u0011\u0003\u0003\u00026U\u0011\u0011q\u0007\t\u0004\u001f\u0005e\u0012bAA\u001e!\t!A+[7f\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\na\u0001\n;j[\u0016\u001cH\u0003BA\"\u0003'\u0002B!!\u0012\u0002N9!\u0011qIA&\u001d\ri\u0015\u0011J\u0005\u0002\u000b%\u0011!\u000bB\u0005\u0005\u0003\u001f\n\tFA\u0003Q_^,'O\u0003\u0002S\t!A\u0011QKA\u001f\u0001\u0004\t9&\u0001\u0003uQ\u0006$\bcA\u0007\u0002Z%\u0019\u00111\f\u0002\u0003\u001f\u0015cWm\u0019;sS\u000e\u001cUO\u001d:f]RDq!a\u0010\u0001\t\u0003\ty\u0006\u0006\u0003\u0002b\u0005\u001d\u0004cA\u0007\u0002d%\u0019\u0011Q\r\u0002\u0003\u001d\u0015cWm\u0019;sS\u000e\u001c\u0005.\u0019:hK\"A\u0011QKA/\u0001\u0004\tI\u0007E\u0002\u000e\u0003WJ1!!\u001c\u0003\u0005-\u0019\u0015\r]1dSR\fgnY3\t\u000f\u0005}\u0002\u0001\"\u0001\u0002rQ!\u00111OA=!\u0011\t)%!\u001e\n\t\u0005]\u0014\u0011\u000b\u0002\u0007\u000b:,'oZ=\t\u0011\u0005U\u0013q\u000ea\u0001\u0003CBq!! \u0001\t\u0003\ty(\u0001\u0003%I&4H\u0003BAA\u0003\u000f\u00032!DAB\u0013\r\t)I\u0001\u0002\u0015\u000b2,7\r\u001e:jG\u0006d'+Z:jgR\fgnY3\t\u0011\u0005U\u00131\u0010a\u0001\u0003/Bq!! \u0001\t\u0003\tY\t\u0006\u0003\u0002X\u00055\u0005\u0002CA+\u0003\u0013\u0003\r!!!\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0012R\u00191,a%\t\u0011\u0005U\u0013q\u0012a\u0001\u0003+\u0003B!!\u0012\u0002\u0018&!\u0011\u0011TA)\u0005\u0019aUM\\4uQ\"1\u0011Q\u0014\u0001\u0005\u0002e\tq\u0001^8W_2$8\u000f\u0003\u0004\u0002\"\u0002!\t!G\u0001\ri>l\u0015N]2pm>dGo\u001d\u0005\u0007\u0003K\u0003A\u0011A\r\u0002\u0019Q|W*\u001b7mSZ|G\u000e^:\t\r\u0005%\u0006\u0001\"\u0001\u001a\u0003-!xnS5m_Z|G\u000e^:\t\r\u00055\u0006\u0001\"\u0001\u001a\u0003-!x.T3hCZ|G\u000e^:")
public final class ElectricPotential
extends Quantity<ElectricPotential>
implements TimeDerivative<MagneticFlux> {
    private final double value;
    private final ElectricPotentialUnit unit;

    public static Try<ElectricPotential> parse(Object object) {
        return ElectricPotential$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<ElectricPotential>> symbolToUnit(String string) {
        return ElectricPotential$.MODULE$.symbolToUnit(string);
    }

    public static Set<UnitOfMeasure<ElectricPotential>> units() {
        return ElectricPotential$.MODULE$.units();
    }

    public static Volts$ siUnit() {
        return ElectricPotential$.MODULE$.siUnit();
    }

    public static Volts$ primaryUnit() {
        return ElectricPotential$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricPotential$.MODULE$.name();
    }

    public static Function1<Object, Try<ElectricPotential>> apply() {
        return ElectricPotential$.MODULE$.apply();
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative$class.$times(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricPotentialUnit unit() {
        return this.unit;
    }

    public ElectricPotential$ dimension() {
        return ElectricPotential$.MODULE$;
    }

    @Override
    public MagneticFlux timeIntegrated() {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toVolts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Power $times(ElectricCurrent that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $times(Capacitance that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toFarads())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(ElectricCharge that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance $div(ElectricCurrent that) {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricalResistance that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Length that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public double toVolts() {
        return this.to(Volts$.MODULE$);
    }

    public double toMircovolts() {
        return this.to(Microvolts$.MODULE$);
    }

    public double toMillivolts() {
        return this.to(Millivolts$.MODULE$);
    }

    public double toKilovolts() {
        return this.to(Kilovolts$.MODULE$);
    }

    public double toMegavolts() {
        return this.to(Megavolts$.MODULE$);
    }

    public ElectricPotential(double value, ElectricPotentialUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative$class.$init$(this);
    }
}

