/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent$;
import squants.electro.ElectricCurrentUnit;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance;
import squants.electro.Inductance;
import squants.electro.MagneticFlux;
import squants.electro.Milliamperes$;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Area;
import squants.space.Length;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeDerivative$class;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0005\u001d\u0011q\"\u00127fGR\u0014\u0018nY\"veJ,g\u000e\u001e\u0006\u0003\u0007\u0011\tq!\u001a7fGR\u0014xNC\u0001\u0006\u0003\u001d\u0019\u0018/^1oiN\u001c\u0001aE\u0002\u0001\u00119\u00012!\u0003\u0006\r\u001b\u0005!\u0011BA\u0006\u0005\u0005!\tV/\u00198uSRL\bCA\u0007\u0001\u001b\u0005\u0011\u0001cA\b\u0013)5\t\u0001C\u0003\u0002\u0012\t\u0005!A/[7f\u0013\t\u0019\u0002C\u0001\bUS6,G)\u001a:jm\u0006$\u0018N^3\u0011\u00055)\u0012B\u0001\f\u0003\u00059)E.Z2ue&\u001c7\t[1sO\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\u0006m\u0006dW/Z\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1Ai\\;cY\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nA!\u001e8jiV\tQ\u0005\u0005\u0002\u000eM%\u0011qE\u0001\u0002\u0014\u000b2,7\r\u001e:jG\u000e+(O]3oiVs\u0017\u000e\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005K\u0005)QO\\5uA!)1\u0006\u0001C\u0005Y\u00051A(\u001b8jiz\"2\u0001D\u0017/\u0011\u0015A\"\u00061\u0001\u001b\u0011\u0015\u0019#\u00061\u0001&\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003%!\u0017.\\3og&|g.F\u00013\u001d\ti1gB\u00035\u0005!\u0005Q'A\bFY\u0016\u001cGO]5d\u0007V\u0014(/\u001a8u!\tiaGB\u0003\u0002\u0005!\u0005qgE\u00037qmr\u0014\t\u0005\u0002\u001cs%\u0011!\b\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%aD\"\u0003\u0002>\t\tIA)[7f]NLwN\u001c\t\u0003\u0013}J!\u0001\u0011\u0003\u0003\u001b\t\u000b7/\u001a#j[\u0016t7/[8o!\tY\")\u0003\u0002D9\ta1+\u001a:jC2L'0\u00192mK\")1F\u000eC\u0001\u000bR\tQ\u0007\u0003\u0004Hm\u0011\u0005!\u0001S\u0001\u0006CB\u0004H._\u000b\u0003\u0013n#2A\u00133g)\ta1\nC\u0003M\r\u0002\u000fQ*A\u0002ok6\u00042A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S\r\u00051AH]8pizJ\u0011!H\u0005\u0003+r\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n9a*^7fe&\u001c'BA+\u001d!\tQ6\f\u0004\u0001\u0005\u000bq3%\u0019A/\u0003\u0003\u0005\u000b\"AX1\u0011\u0005my\u0016B\u00011\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00072\n\u0005\rd\"aA!os\")QM\u0012a\u00013\u0006\ta\u000eC\u0003$\r\u0002\u0007Q\u0005C\u0003Hm\u0011\u0005\u0001.F\u0001j!\u0011Y\".\u00197\n\u0005-d\"!\u0003$v]\u000e$\u0018n\u001c82!\ri\u0007\u000fD\u0007\u0002]*\u0011q\u000eH\u0001\u0005kRLG.\u0003\u0002r]\n\u0019AK]=\t\u000bM4D\u0011\u0001;\u0002\t9\fW.Z\u000b\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005Y\u0006twMC\u0001{\u0003\u0011Q\u0017M^1\n\u0005q<(AB*ue&tw\rC\u0003\u007fm\u0011\u0005q0A\u0006qe&l\u0017M]=V]&$XCAA\u0001\u001d\ri\u00111A\u0005\u0004\u0003\u000b\u0011\u0011aB!na\u0016\u0014Xm\u001d\u0005\u0007\u0003\u00131D\u0011A@\u0002\rMLWK\\5u\u0011\u001d\tiA\u000eC\u0001\u0003\u001f\tQ!\u001e8jiN,\"!!\u0005\u0011\r\u0005M\u0011QDA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C5n[V$\u0018M\u00197f\u0015\r\tY\u0002H\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0010\u0003+\u00111aU3u!\u0011I\u00111\u0005\u0007\n\u0007\u0005\u0015BAA\u0007V]&$xJZ'fCN,(/\u001a\u0005\u0007\u0003S1D\u0011\u0001;\u0002\u001f\u0011LW.\u001a8tS>t7+_7c_2D\u0011\"!\f7\u0003\u0003%I!a\f\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003c\u00012A^A\u001a\u0013\r\t)d\u001e\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005e\u0002\u0001\"\u0005\u0005\u0003w\ta\u0002^5nK&sG/Z4sCR,G-F\u0001\u0015\u0011\u001d\t\u0002\u0001\"\u0005\u0005\u0003\u007f)\"!!\u0011\u0011\u0007=\t\u0019%C\u0002\u0002FA\u0011A\u0001V5nK\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013A\u0002\u0013uS6,7\u000f\u0006\u0003\u0002N\u0005M\u0003cA\u0007\u0002P%\u0019\u0011\u0011\u000b\u0002\u0003#\u0015cWm\u0019;sS\u000e\u0004v\u000e^3oi&\fG\u000e\u0003\u0005\u0002V\u0005\u001d\u0003\u0019AA,\u0003\u0011!\b.\u0019;\u0011\u00075\tI&C\u0002\u0002\\\t\u0011A#\u00127fGR\u0014\u0018nY1m%\u0016\u001c\u0018n\u001d;b]\u000e,\u0007bBA%\u0001\u0011\u0005\u0011q\f\u000b\u0005\u0003C\n\t\b\u0005\u0003\u0002d\u0005-d\u0002BA3\u0003Sr1\u0001UA4\u0013\u0005)\u0011BA+\u0005\u0013\u0011\ti'a\u001c\u0003\u000bA{w/\u001a:\u000b\u0005U#\u0001\u0002CA+\u0003;\u0002\r!!\u0014\t\u000f\u0005%\u0003\u0001\"\u0001\u0002vQ!\u0011qOA?!\ri\u0011\u0011P\u0005\u0004\u0003w\u0012!\u0001D'bO:,G/[2GYVD\b\u0002CA+\u0003g\u0002\r!a \u0011\u00075\t\t)C\u0002\u0002\u0004\n\u0011!\"\u00138ek\u000e$\u0018M\\2f\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013\u000bA\u0001\n3jmR!\u00111RAI!\ri\u0011QR\u0005\u0004\u0003\u001f\u0013!!F#mK\u000e$(/[2bY\u000e{g\u000eZ;di\u0006t7-\u001a\u0005\t\u0003+\n)\t1\u0001\u0002N!9\u0011q\u0011\u0001\u0005\u0002\u0005UEc\u00010\u0002\u0018\"A\u0011QKAJ\u0001\u0004\tI\n\u0005\u0003\u0002d\u0005m\u0015\u0002BAO\u0003_\u0012a\u0001T3oORD\u0007bBAD\u0001\u0011\u0005\u0011\u0011\u0015\u000b\u0004=\u0006\r\u0006\u0002CA+\u0003?\u0003\r!!*\u0011\t\u0005\r\u0014qU\u0005\u0005\u0003S\u000byG\u0001\u0003Be\u0016\f\u0007BBAW\u0001\u0011\u0005\u0011$A\u0005u_\u0006k\u0007/\u001a:fg\"1\u0011\u0011\u0017\u0001\u0005\u0002e\ta\u0002^8NS2d\u0017.Y7qKJ,7\u000f")
public final class ElectricCurrent
extends Quantity<ElectricCurrent>
implements TimeDerivative<ElectricCharge> {
    private final double value;
    private final ElectricCurrentUnit unit;

    public static Try<ElectricCurrent> parse(Object object) {
        return ElectricCurrent$.MODULE$.parse(object);
    }

    public static Option<UnitOfMeasure<ElectricCurrent>> symbolToUnit(String string) {
        return ElectricCurrent$.MODULE$.symbolToUnit(string);
    }

    public static String dimensionSymbol() {
        return ElectricCurrent$.MODULE$.dimensionSymbol();
    }

    public static Set<UnitOfMeasure<ElectricCurrent>> units() {
        return ElectricCurrent$.MODULE$.units();
    }

    public static Amperes$ siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static Amperes$ primaryUnit() {
        return ElectricCurrent$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricCurrent$.MODULE$.name();
    }

    public static Function1<Object, Try<ElectricCurrent>> apply() {
        return ElectricCurrent$.MODULE$.apply();
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative$class.$times(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricCurrentUnit unit() {
        return this.unit;
    }

    public ElectricCurrent$ dimension() {
        return ElectricCurrent$.MODULE$;
    }

    @Override
    public ElectricCharge timeIntegrated() {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toAmperes()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public ElectricPotential $times(ElectricalResistance that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(ElectricPotential that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(Inductance that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance $div(ElectricPotential that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Length that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Nothing$ $div(Area that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public double toAmperes() {
        return this.to(Amperes$.MODULE$);
    }

    public double toMilliamperes() {
        return this.to(Milliamperes$.MODULE$);
    }

    public ElectricCurrent(double value, ElectricCurrentUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative$class.$init$(this);
    }
}

