/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.rxgrpc.stub;

import io.reactivex.FlowableOperator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SubscribeOnlyOnceFlowableOperator<T>
implements FlowableOperator<T, T> {
    private AtomicBoolean subscribedOnce = new AtomicBoolean(false);

    public Subscriber<? super T> apply(final Subscriber<? super T> observer) {
        return new Subscriber<T>(){

            public void onSubscribe(Subscription subscription) {
                if (SubscribeOnlyOnceFlowableOperator.this.subscribedOnce.getAndSet(true)) {
                    throw new NullPointerException("You cannot directly subscribe to a gRPC service multiple times concurrently. Use Flowable.share() instead.");
                }
                observer.onSubscribe(subscription);
            }

            public void onNext(T t) {
                observer.onNext(t);
            }

            public void onError(Throwable throwable) {
                observer.onError(throwable);
            }

            public void onComplete() {
                observer.onComplete();
            }
        };
    }
}

