/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ProtocPlugin {
    private ProtocPlugin() {
    }

    public static void generate(@Nonnull Generator generator) {
        Preconditions.checkNotNull((Object)generator, (Object)"generator");
        ProtocPlugin.generate(Collections.singletonList(generator));
    }

    public static void generate(@Nonnull List<Generator> generators) {
        ProtocPlugin.generate(generators, Collections.emptyList());
    }

    public static void generate(@Nonnull List<Generator> generators, List<GeneratedMessage.GeneratedExtension> extensions) {
        Preconditions.checkNotNull(generators, (Object)"generators");
        Preconditions.checkArgument((!generators.isEmpty() ? 1 : 0) != 0, (Object)"generators.isEmpty()");
        Preconditions.checkNotNull(extensions, (Object)"extensions");
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        for (GeneratedMessage.GeneratedExtension extension : extensions) {
            extensionRegistry.add(extension);
        }
        try {
            byte[] generatorRequestBytes = ByteStreams.toByteArray((InputStream)System.in);
            PluginProtos.CodeGeneratorRequest request = PluginProtos.CodeGeneratorRequest.parseFrom((byte[])generatorRequestBytes, (ExtensionRegistryLite)extensionRegistry);
            PluginProtos.CodeGeneratorResponse response = ProtocPlugin.generate(generators, request);
            response.writeTo((OutputStream)System.out);
        }
        catch (GeneratorException ex) {
            try {
                PluginProtos.CodeGeneratorResponse.newBuilder().setError(ex.getMessage()).build().writeTo((OutputStream)System.out);
            }
            catch (IOException ex2) {
                ProtocPlugin.abort(ex2);
            }
        }
        catch (Throwable ex) {
            ProtocPlugin.abort(ex);
        }
    }

    public static void debug(@Nonnull Generator generator, @Nonnull String dumpPath) {
        Preconditions.checkNotNull((Object)generator, (Object)"generator");
        ProtocPlugin.debug(Collections.singletonList(generator), dumpPath);
    }

    public static void debug(@Nonnull List<Generator> generators, @Nonnull String dumpPath) {
        ProtocPlugin.debug(generators, Collections.emptyList(), dumpPath);
    }

    public static void debug(@Nonnull List<Generator> generators, List<GeneratedMessage.GeneratedExtension> extensions, @Nonnull String dumpPath) {
        Preconditions.checkNotNull(generators, (Object)"generators");
        Preconditions.checkArgument((!generators.isEmpty() ? 1 : 0) != 0, (Object)"generators.isEmpty()");
        Preconditions.checkNotNull(extensions, (Object)"extensions");
        Preconditions.checkNotNull((Object)dumpPath, (Object)"dumpPath");
        ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        for (GeneratedMessage.GeneratedExtension extension : extensions) {
            extensionRegistry.add(extension);
        }
        try {
            byte[] generatorRequestBytes = ByteStreams.toByteArray((InputStream)new FileInputStream(new File(dumpPath)));
            PluginProtos.CodeGeneratorRequest request = PluginProtos.CodeGeneratorRequest.parseFrom((byte[])generatorRequestBytes, (ExtensionRegistryLite)extensionRegistry);
            PluginProtos.CodeGeneratorResponse response = ProtocPlugin.generate(generators, request);
            if (!Strings.isNullOrEmpty((String)response.getError())) {
                System.err.println(response.getError());
            }
            for (PluginProtos.CodeGeneratorResponse.File file : response.getFileList()) {
                File outFile;
                if (Strings.isNullOrEmpty((String)file.getInsertionPoint())) {
                    outFile = new File(file.getName());
                } else {
                    String name = Files.getNameWithoutExtension((String)file.getName()) + "-" + file.getInsertionPoint() + Files.getFileExtension((String)file.getName());
                    outFile = new File(name);
                }
                Files.createParentDirs((File)outFile);
                Files.write((CharSequence)file.getContent(), (File)outFile, (Charset)Charsets.UTF_8);
                Files.write((byte[])file.getContentBytes().toByteArray(), (File)outFile);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static PluginProtos.CodeGeneratorResponse generate(@Nonnull List<Generator> generators, @Nonnull PluginProtos.CodeGeneratorRequest request) {
        Preconditions.checkNotNull(generators, (Object)"generators");
        Preconditions.checkArgument((!generators.isEmpty() ? 1 : 0) != 0, (Object)"generators.isEmpty()");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Stream oldWay = generators.stream().flatMap(gen -> gen.generate(request));
        Stream newWay = generators.stream().flatMap(gen -> gen.generateFiles(request).stream());
        return PluginProtos.CodeGeneratorResponse.newBuilder().addAllFile((Iterable)Stream.concat(oldWay, newWay).collect(Collectors.toList())).build();
    }

    private static void abort(Throwable ex) {
        ex.printStackTrace(System.err);
        System.exit(1);
    }
}

