/*
 * Decompiled with CFR 0.152.
 */
package com.quec.model.device.request;

import com.quec.annotation.KeyNameInMap;
import com.quec.annotation.RequestParamType;
import com.quec.annotation.Validation;
import com.quec.model.BasicsModel;

public class DeviceSendDataRequest
extends BasicsModel {
    @KeyNameInMap(value="productKey", queryType=RequestParamType.query)
    @Validation(required=true, maxLength=128, minLength=1)
    public String productKey;
    @KeyNameInMap(value="deviceKey", queryType=RequestParamType.query)
    @Validation(required=true, pattern="^[a-zA-Z0-9]{4,32}$")
    public String deviceKey;
    @KeyNameInMap(value="language", queryType=RequestParamType.query)
    @Validation(required=false, pattern="CN|EN")
    public String language = "CN";
    @KeyNameInMap(value="data", queryType=RequestParamType.body)
    @Validation(required=true)
    public String data;
    @KeyNameInMap(value="passDataFormat", queryType=RequestParamType.body)
    @Validation(required=false, pattern="Hex|Text")
    public String passDataFormat;
    @KeyNameInMap(value="isCache", queryType=RequestParamType.body)
    @Validation(required=false, pattern="true|false")
    public String isCache;
    @KeyNameInMap(value="cacheTime", queryType=RequestParamType.body)
    @Validation(required=false, minimum=1.0, maximum=7776000.0)
    public Long cacheTime;
    @KeyNameInMap(value="type", queryType=RequestParamType.body)
    @Validation(required=true, pattern="PASSTHROUGH|PROPERTY|SERVICE")
    public String type;
    @KeyNameInMap(value="operate", queryType=RequestParamType.body)
    @Validation(required=true, pattern="GET|DOWN")
    public String operate;
    @KeyNameInMap(value="isCover", queryType=RequestParamType.body)
    @Validation(required=false, pattern="true|false")
    public String isCover;

    public DeviceSendDataRequest() {
    }

    public DeviceSendDataRequest(String productKey, String deviceKey, String data, String type, String operate) {
        this.productKey = productKey;
        this.deviceKey = deviceKey;
        this.data = data;
        this.type = type;
        this.operate = operate;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public String getDeviceKey() {
        return this.deviceKey;
    }

    public void setDeviceKey(String deviceKey) {
        this.deviceKey = deviceKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getPassDataFormat() {
        return this.passDataFormat;
    }

    public void setPassDataFormat(String passDataFormat) {
        this.passDataFormat = passDataFormat;
    }

    public String getIsCache() {
        return this.isCache;
    }

    public void setIsCache(String isCache) {
        this.isCache = isCache;
    }

    public Long getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(Long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperate() {
        return this.operate;
    }

    public void setOperate(String operate) {
        this.operate = operate;
    }

    public String getIsCover() {
        return this.isCover;
    }

    public void setIsCover(String isCover) {
        this.isCover = isCover;
    }
}

