/*
 * Decompiled with CFR 0.152.
 */
package com.quec.model.device.request;

import com.quec.annotation.KeyNameInMap;
import com.quec.annotation.RequestParamType;
import com.quec.annotation.Validation;
import com.quec.model.BasicsModel;
import java.util.List;

public class DeviceDmReadDataRequest
extends BasicsModel {
    @KeyNameInMap(value="language", queryType=RequestParamType.query)
    @Validation(required=false, pattern="CN|EN")
    public String language = "CN";
    @KeyNameInMap(value="devices", queryType=RequestParamType.body)
    @Validation(required=true, minSize=1, maxSize=20)
    public List<String> devices;
    @KeyNameInMap(value="productKey", queryType=RequestParamType.body)
    @Validation(required=true, pattern="^[a-zA-Z0-9]{1,128}$")
    public String productKey;
    @KeyNameInMap(value="data", queryType=RequestParamType.body)
    @Validation(required=true)
    public String data;
    @KeyNameInMap(value="isCache", queryType=RequestParamType.body)
    @Validation(required=false, pattern="true|false")
    public boolean isCache;
    @KeyNameInMap(value="cacheTime", queryType=RequestParamType.body)
    @Validation(required=false, minimum=1.0, maximum=7776000.0)
    public Long cacheTime;
    @KeyNameInMap(value="isCover", queryType=RequestParamType.body)
    @Validation(required=false, pattern="true|false")
    public boolean isCover;
    @KeyNameInMap(value="qos", queryType=RequestParamType.body)
    @Validation(required=false)
    public Integer qos;

    public DeviceDmReadDataRequest() {
    }

    public DeviceDmReadDataRequest(List<String> devices, String productKey, String data) {
        this.devices = devices;
        this.productKey = productKey;
        this.data = data;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public void setDevices(List<String> devices) {
        this.devices = devices;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setCache(boolean cache) {
        this.isCache = cache;
    }

    public Long getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(Long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public boolean isCover() {
        return this.isCover;
    }

    public void setCover(boolean cover) {
        this.isCover = cover;
    }

    public Integer getQos() {
        return this.qos;
    }

    public void setQos(Integer qos) {
        this.qos = qos;
    }
}

