/*
 * Decompiled with CFR 0.152.
 */
package com.quec.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.quec.amqphandle.HandleMessage;
import com.quec.model.msg.DeviceAddAndDelete;
import com.quec.model.msg.DeviceStatus;
import com.quec.model.msg.DeviceUpdate;
import com.quec.model.msg.EnduserUser;
import com.quec.model.msg.EnduserUserBind;
import com.quec.model.msg.Location;
import com.quec.model.msg.LocationInfoKV;
import com.quec.model.msg.LocationInfoRAW;
import com.quec.model.msg.MAttr;
import com.quec.model.msg.MAttrRead;
import com.quec.model.msg.MServ;
import com.quec.model.msg.ProductAddAndDelete;
import com.quec.model.msg.ProductThingmodel;
import com.quec.model.msg.ProductUpdate;
import com.quec.model.msg.Reqack;
import com.quec.model.msg.UpDownLine;
import com.quec.model.msg.UpDownLink;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DeliverCallback;
import java.nio.charset.StandardCharsets;

public class ConsumerBuilder {
    private static final String ONLINE = "ONLINE";
    private static final String STATUS = "STATUS";
    private static final String RAW = "RAW";
    private static final String UPLINK = "UPLINK";
    private static final String DOWNLINK = "DOWNLINK";
    private static final String REQACK = "REQACK";
    private static final String MATTR = "MATTR";
    private static final String READ = "READ";
    private static final String READRESP = "READRESP";
    private static final String WRITE = "WRITE";
    private static final String REPORT = "REPORT";
    private static final String MSERV = "MSERV";
    private static final String INPUT = "INPUT";
    private static final String OUTPUT = "OUTPUT";
    private static final String MEVENT = "MEVENT";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String LOCATION = "LOCATION";
    private static final String MODE = "MODE";
    private static final String QUERY = "QUERY";
    private static final String INFO_RAW = "INFO-RAW";
    private static final String INFO_KV = "INFO-KV";
    private static final String ENDUSER = "ENDUSER";
    private static final String USER_ADD = "USER-ADD";
    private static final String USER_UPDATE = "USER-UPDATE";
    private static final String USER_DELETE = "USER-DELETE";
    private static final String USER_BIND = "USER-BIND";
    private static final String META_EVENT = "META_EVENT";
    private static final String PRODUCT = "PRODUCT";
    private static final String DEVICE = "DEVICE";
    private static final String THING_MODEL = "THING_MODEL";
    private static final String ADD = "ADD";
    private static final String DELETE = "DELETE";
    private static final String UPDATE = "UPDATE";
    private static final String AUTH = "AUTH";
    private static final String CANCEL_AUTH = "CANCEL_AUTH";
    private static final String GRANT_AUTHORIZED = "GRANT_AUTHORIZED";

    public static DeliverCallback doHandle(Channel channel, HandleMessage handleMessage) {
        DeliverCallback deliverCallback = (consumerTag, delivery) -> {
            try {
                String message = new String(delivery.getBody(), StandardCharsets.UTF_8);
                handleMessage.beforeHandleMessage(message);
                ConsumerBuilder.handleMag(message, handleMessage);
                handleMessage.afterHandleMessage(message);
                handleMessage.confirmAck(channel, delivery);
            }
            catch (Exception e) {
                handleMessage.onExceptionHandleMessage(channel, delivery, e);
            }
        };
        return deliverCallback;
    }

    private static void handleMag(String message, HandleMessage handleMessage) {
        String type;
        JSONObject obj = JSON.parseObject((String)message);
        switch (type = obj.getString("type")) {
            case "ONLINE": {
                UpDownLine upDownLine = (UpDownLine)JSONObject.parseObject((String)message, UpDownLine.class);
                handleMessage.upAndDownLine(upDownLine);
                break;
            }
            case "STATUS": {
                DeviceStatus deviceStatus = (DeviceStatus)JSONObject.parseObject((String)message, DeviceStatus.class);
                handleMessage.deviceStatus(deviceStatus);
                break;
            }
            case "RAW": {
                ConsumerBuilder.handleLink(obj, handleMessage, message);
                break;
            }
            case "REQACK": {
                Reqack reqack = (Reqack)JSONObject.parseObject((String)message, Reqack.class);
                handleMessage.reqack(reqack);
                break;
            }
            case "MATTR": {
                ConsumerBuilder.handleMattr(obj, handleMessage, message);
                break;
            }
            case "MSERV": {
                ConsumerBuilder.handleMserv(obj, handleMessage, message);
                break;
            }
            case "MEVENT": {
                ConsumerBuilder.handleMevent(obj, handleMessage, message);
                break;
            }
            case "LOCATION": {
                ConsumerBuilder.handleLocation(obj, handleMessage, message);
                break;
            }
            case "ENDUSER": {
                ConsumerBuilder.handleEnduserUser(obj, handleMessage, message);
                break;
            }
            case "META_EVENT": {
                ConsumerBuilder.handleMetaEvent(obj, handleMessage, message);
            }
        }
    }

    private static void handleLink(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        UpDownLink upDownLink = null;
        if (subtype != null) {
            switch (subtype) {
                case "UPLINK": {
                    upDownLink = (UpDownLink)JSONObject.parseObject((String)message, UpDownLink.class);
                    handleMessage.upLink(upDownLink);
                    break;
                }
                case "DOWNLINK": {
                    upDownLink = (UpDownLink)JSONObject.parseObject((String)message, UpDownLink.class);
                    handleMessage.downLink(upDownLink);
                }
            }
        }
    }

    private static void handleMattr(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "READ": {
                    MAttrRead mAttrRead = (MAttrRead)JSONObject.parseObject((String)message, MAttrRead.class);
                    handleMessage.mAttrRead(mAttrRead);
                    break;
                }
                case "READRESP": {
                    MAttr readresp = (MAttr)JSONObject.parseObject((String)message, MAttr.class);
                    handleMessage.mAttrReadresp(readresp);
                    break;
                }
                case "WRITE": {
                    MAttr write = (MAttr)JSONObject.parseObject((String)message, MAttr.class);
                    handleMessage.mAttrWrite(write);
                    break;
                }
                case "REPORT": {
                    MAttr report = (MAttr)JSONObject.parseObject((String)message, MAttr.class);
                    handleMessage.mAttrReport(report);
                }
            }
        }
    }

    private static void handleMserv(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "INPUT": {
                    MServ input = (MServ)JSONObject.parseObject((String)message, MServ.class);
                    handleMessage.mServInput(input);
                    break;
                }
                case "OUTPUT": {
                    MServ output = (MServ)JSONObject.parseObject((String)message, MServ.class);
                    handleMessage.mServOutput(output);
                }
            }
        }
    }

    private static void handleMevent(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "INFO": {
                    MServ mEventInfo = (MServ)JSONObject.parseObject((String)message, MServ.class);
                    handleMessage.mEventInfo(mEventInfo);
                    break;
                }
                case "WARN": {
                    MServ mEventWarn = (MServ)JSONObject.parseObject((String)message, MServ.class);
                    handleMessage.mEventWarn(mEventWarn);
                    break;
                }
                case "ERROR": {
                    MServ mEventError = (MServ)JSONObject.parseObject((String)message, MServ.class);
                    handleMessage.mEventError(mEventError);
                }
            }
        }
    }

    private static void handleLocation(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "MODE": {
                    Location locationMode = (Location)JSONObject.parseObject((String)message, Location.class);
                    handleMessage.locationMode(locationMode);
                    break;
                }
                case "QUERY": {
                    Location locationQuery = (Location)JSONObject.parseObject((String)message, Location.class);
                    handleMessage.locationQuery(locationQuery);
                    break;
                }
                case "INFO-RAW": {
                    LocationInfoRAW locationInfoRAW = (LocationInfoRAW)JSONObject.parseObject((String)message, LocationInfoRAW.class);
                    handleMessage.locationInfoRaw(locationInfoRAW);
                    break;
                }
                case "INFO-KV": {
                    LocationInfoKV locationInfoKV = (LocationInfoKV)JSONObject.parseObject((String)message, LocationInfoKV.class);
                    handleMessage.locationInfoKV(locationInfoKV);
                }
            }
        }
    }

    private static void handleEnduserUser(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "USER-ADD": {
                    EnduserUser enduserUserAdd = (EnduserUser)JSONObject.parseObject((String)message, EnduserUser.class);
                    handleMessage.enduserUserAdd(enduserUserAdd);
                    break;
                }
                case "USER-UPDATE": {
                    EnduserUser enduserUserUpdate = (EnduserUser)JSONObject.parseObject((String)message, EnduserUser.class);
                    handleMessage.enduserUserUpdate(enduserUserUpdate);
                    break;
                }
                case "USER-DELETE": {
                    EnduserUser enduserUserDelete = (EnduserUser)JSONObject.parseObject((String)message, EnduserUser.class);
                    handleMessage.enduserUserDelete(enduserUserDelete);
                    break;
                }
                case "USER-BIND": {
                    EnduserUserBind enduserUserBind = (EnduserUserBind)JSONObject.parseObject((String)message, EnduserUserBind.class);
                    handleMessage.enduserUserBind(enduserUserBind);
                }
            }
        }
    }

    private static void handleMetaEvent(JSONObject obj, HandleMessage handleMessage, String message) {
        String subtype = obj.getString("subtype");
        if (subtype != null) {
            switch (subtype) {
                case "PRODUCT": 
                case "GRANT_AUTHORIZED": {
                    ConsumerBuilder.handleProduct(obj, handleMessage, message);
                    break;
                }
                case "DEVICE": {
                    ConsumerBuilder.handleDevice(obj, handleMessage, message);
                    break;
                }
                case "THING_MODEL": {
                    ProductThingmodel productThingmodel = (ProductThingmodel)JSONObject.parseObject((String)message, ProductThingmodel.class);
                    handleMessage.deviceModelInfo(productThingmodel);
                }
            }
        }
    }

    private static void handleProduct(JSONObject obj, HandleMessage handleMessage, String message) {
        String operation = obj.getString("operation");
        if (operation != null) {
            switch (operation) {
                case "ADD": 
                case "DELETE": 
                case "AUTH": 
                case "CANCEL_AUTH": {
                    ProductAddAndDelete productAddAndDelete = (ProductAddAndDelete)JSONObject.parseObject((String)message, ProductAddAndDelete.class);
                    handleMessage.productAddAndDel(productAddAndDelete);
                    break;
                }
                case "UPDATE": {
                    ProductUpdate productUpdate = (ProductUpdate)JSONObject.parseObject((String)message, ProductUpdate.class);
                    handleMessage.productUpdate(productUpdate);
                }
            }
        }
    }

    private static void handleDevice(JSONObject obj, HandleMessage handleMessage, String message) {
        String operation = obj.getString("operation");
        if (operation != null) {
            switch (operation) {
                case "ADD": 
                case "DELETE": {
                    DeviceAddAndDelete deviceAddAndDelete = (DeviceAddAndDelete)JSONObject.parseObject((String)message, DeviceAddAndDelete.class);
                    handleMessage.deviceAddAndDel(deviceAddAndDelete);
                    break;
                }
                case "UPDATE": {
                    DeviceUpdate deviceUpdate = (DeviceUpdate)JSONObject.parseObject((String)message, DeviceUpdate.class);
                    handleMessage.deviceUpdate(deviceUpdate);
                }
            }
        }
    }
}

