/*
 * Decompiled with CFR 0.152.
 */
package com.quec.client;

import com.quec.amqphandle.AccessCredentialsProvider;
import com.quec.until.Common;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import com.rabbitmq.client.impl.DefaultCredentialsRefreshService;
import java.time.Duration;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;

public class AmqpHelper {
    private static final int RefreshTime = 4;
    public static final ConcurrentHashMap<String, Connection> amqpClients = new ConcurrentHashMap();

    public static Connection getConnection(String accessKey, String accessSecret, String connectionUrl, String queueName) {
        try {
            String key = AmqpHelper.getClientKey(accessKey, accessSecret, connectionUrl, queueName);
            Connection conn = amqpClients.get(key);
            if (conn == null || !conn.isOpen()) {
                conn = AmqpHelper.createConnection(accessKey, accessSecret, connectionUrl, queueName);
                amqpClients.put(key, conn);
            }
            return conn;
        }
        catch (Exception e) {
            throw new RuntimeException("Rabbitmq resume link failed", e);
        }
    }

    private static String getClientKey(String accessKey, String accessSecret, String connectionUrl, String queueName) {
        return accessKey + "-" + accessSecret + "-" + connectionUrl + "-" + queueName;
    }

    private static Connection createConnection(String accessKey, String accessSecret, String connectionUrl, String queueName) throws Exception {
        long timestamp = Calendar.getInstance().getTimeInMillis();
        String username = "ver=1&auth_mode=accessKey&sign_method=sha256&access_key=" + accessKey + "&timestamp=" + timestamp;
        String password = Common.getSHA256((String)(username + accessSecret));
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUri(connectionUrl);
        factory.setUsername(username);
        factory.setPassword(password);
        factory.useSslProtocol();
        factory.setAutomaticRecoveryEnabled(true);
        factory.setTopologyRecoveryEnabled(true);
        factory.setCredentialsProvider((CredentialsProvider)new AccessCredentialsProvider(accessKey, accessSecret, Duration.ofMinutes(4L)));
        factory.setCredentialsRefreshService((CredentialsRefreshService)new DefaultCredentialsRefreshService.DefaultCredentialsRefreshServiceBuilder().build());
        Connection conn = factory.newConnection();
        return conn;
    }
}

