/*
 * Decompiled with CFR 0.152.
 */
package com.quec.client;

import com.quec.amqphandle.HandleMessage;
import com.quec.client.AmqpHelper;
import com.quec.client.ConsumerBuilder;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.DeliverCallback;

public class AmqpClient {
    private String accessKey;
    private String accessSecret;
    private String connectionUrl;
    private String queueName;
    private int prefetchCount;

    public AmqpClient(String accessKey, String accessSecret, String connectionUrl, String queueName) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.connectionUrl = connectionUrl;
        this.queueName = queueName;
        this.prefetchCount = 1;
    }

    public AmqpClient(String accessKey, String accessSecret, String connectionUrl, String queueName, int prefetchCount) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.connectionUrl = connectionUrl;
        this.queueName = queueName;
        this.prefetchCount = prefetchCount > 0 ? prefetchCount : 1;
    }

    public void start(HandleMessage var1) throws Exception {
        Connection conn = AmqpHelper.getConnection(this.accessKey, this.accessSecret, this.connectionUrl, this.queueName);
        Channel channel = conn.createChannel();
        channel.basicQos(this.prefetchCount);
        channel.basicConsume(this.queueName, false, ConsumerBuilder.doHandle(channel, var1), consumerTag -> {});
    }

    public void start(HandleMessage var1, CancelCallback var2) throws Exception {
        Connection conn = AmqpHelper.getConnection(this.accessKey, this.accessSecret, this.connectionUrl, this.queueName);
        Channel channel = conn.createChannel();
        channel.basicQos(this.prefetchCount);
        channel.basicConsume(this.queueName, false, ConsumerBuilder.doHandle(channel, var1), var2);
    }

    public void start(DeliverCallback var1) throws Exception {
        Connection conn = AmqpHelper.getConnection(this.accessKey, this.accessSecret, this.connectionUrl, this.queueName);
        Channel channel = conn.createChannel();
        channel.basicQos(this.prefetchCount);
        channel.basicConsume(this.queueName, false, var1, consumerTag -> {});
    }

    public void start(DeliverCallback var1, CancelCallback var2) throws Exception {
        Connection conn = AmqpHelper.getConnection(this.accessKey, this.accessSecret, this.connectionUrl, this.queueName);
        Channel channel = conn.createChannel();
        channel.basicQos(this.prefetchCount);
        channel.basicConsume(this.queueName, false, var1, var2);
    }

    public void stop() throws Exception {
        Connection conn = AmqpHelper.getConnection(this.accessKey, this.accessSecret, this.connectionUrl, this.queueName);
        Channel channel = conn.createChannel();
        channel.close();
        conn.close();
    }
}

