/*
 * Decompiled with CFR 0.152.
 */
package com.quec.amqphandle;

import com.quec.until.Common;
import com.rabbitmq.client.impl.CredentialsProvider;
import java.time.Duration;
import java.util.Calendar;

public class AccessCredentialsProvider
implements CredentialsProvider {
    private final String accessKey;
    private final String accessSecret;
    private final Duration expireDuration;
    private String username;
    private String password;

    public AccessCredentialsProvider(String accessKey, String accessSecret, Duration expireDuration) {
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.expireDuration = expireDuration;
        this.refresh();
    }

    public void refresh() {
        long timestamp = Calendar.getInstance().getTimeInMillis();
        this.username = String.format("ver=1&auth_mode=accessKey&sign_method=sha256&access_key=%s&timestamp=%s", this.accessKey, timestamp);
        this.password = Common.getSHA256((String)(this.username + this.accessSecret)).toLowerCase();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Duration getTimeBeforeExpiration() {
        return this.expireDuration;
    }
}

