/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUCache;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

final class LRUParameterMetadataCache
implements Monitor {
    private int cacheSize = 0;
    private final LRUCache<ParameterMetaData> cache = new LRUCache(false);
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    LRUParameterMetadataCache(int size) throws SQLException {
        if (size < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1732).fillInStackTrace();
        }
        this.cacheSize = size;
        this.cache.vacancy(size);
    }

    public void resize(int newSize) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (newSize < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1732).fillInStackTrace();
            }
            while (this.cache.size() > newSize) {
                this.cache.removeLeastRecent();
            }
            this.cacheSize = newSize;
            this.cache.vacancy(newSize);
        }
    }

    void add(ParameterMetaData parameterMetadata, String originalSql, String dbGuid, String schema, String user) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.cacheSize == 0) {
                return;
            }
            this.cache.add(parameterMetadata, 0, 0, LRUParameterMetadataCache.getKey(originalSql, dbGuid, schema, user));
            while (this.cache.size() > this.cacheSize) {
                this.cache.removeLeastRecent();
            }
        }
    }

    ParameterMetaData searchCache(String originalSql, String dbGuid, String schema, String user) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (0 == this.cacheSize) {
                ParameterMetaData parameterMetaData = null;
                return parameterMetaData;
            }
            ParameterMetaData parameterMetadata = this.cache.removeMostRecent(0, 0, LRUParameterMetadataCache.getKey(originalSql, dbGuid, schema, user));
            if (parameterMetadata != null) {
                this.cache.add(parameterMetadata, 0, 0, LRUParameterMetadataCache.getKey(originalSql, dbGuid, schema, user));
            }
            ParameterMetaData parameterMetaData = parameterMetadata;
            return parameterMetaData;
        }
    }

    private static final String getKey(String sql, String dbGuid, String schema, String user) {
        return sql + dbGuid + schema + user;
    }

    void purgeCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            while (this.cache.removeLeastRecent() != null) {
            }
        }
    }

    private OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

