/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonLocalDateTimeDeserializer
extends LocalDateTimeDeserializer {
    public static final OsonLocalDateTimeDeserializer INSTANCE = new OsonLocalDateTimeDeserializer();

    public OsonLocalDateTimeDeserializer(DateTimeFormatter formatter) {
        super(formatter);
    }

    protected OsonLocalDateTimeDeserializer(LocalDateTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected OsonLocalDateTimeDeserializer withDateFormat(DateTimeFormatter formatter) {
        return new OsonLocalDateTimeDeserializer(formatter);
    }

    protected OsonLocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new OsonLocalDateTimeDeserializer(this, leniency);
    }

    protected LocalDateTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        return super._fromString(p, ctxt, string0);
    }

    protected OsonLocalDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    protected OsonLocalDateTimeDeserializer() {
        super(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p instanceof OsonParser) {
            OsonParser _parser = (OsonParser)p;
            if (_parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_TIMESTAMP)) {
                return _parser.readLocalDateTime();
            }
            return super.deserialize(p, ctxt);
        }
        return super.deserialize(p, ctxt);
    }
}

