/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import oracle.jdbc.provider.oson.OsonParser;

public class OsonConverterDeserializer<T>
extends JsonDeserializer<T> {
    private final AttributeConverter converter;
    private final Class<?> elementReturnType;
    private final Class<?> elementInputType;

    public OsonConverterDeserializer(Class<? extends AttributeConverter> converter) {
        try {
            this.converter = converter.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.elementReturnType = this.resolveReturnType(converter);
            this.elementInputType = this.resolveInputType(converter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> resolveInputType(Class<? extends AttributeConverter> converter) {
        Class<? extends AttributeConverter> iter = converter;
        do {
            Method[] methods;
            for (Method method : methods = iter.getDeclaredMethods()) {
                if (!method.getName().equals("convertToDatabaseColumn") || method.getReturnType() == Object.class) continue;
                Class<?> returnType = method.getReturnType();
                return returnType;
            }
        } while ((iter = iter.getSuperclass()).getSuperclass() != null);
        return Object.class;
    }

    private Class<T> resolveReturnType(Class<? extends AttributeConverter> converter) {
        Class<? extends AttributeConverter> iter = converter;
        do {
            Method[] methods;
            for (Method method : methods = iter.getDeclaredMethods()) {
                if (!method.getName().equals("convertToEntityAttribute") || method.getReturnType() == Object.class) continue;
                Class<?> returnType = method.getReturnType();
                return returnType;
            }
        } while ((iter = iter.getSuperclass()).getSuperclass() != null);
        return Object.class;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        Object result = null;
        block0 : switch (p.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                int pInt = p.getIntValue();
                result = this.converter.convertToEntityAttribute((Object)pInt);
                break;
            }
            case VALUE_STRING: {
                OsonParser parser = (OsonParser)p;
                switch (parser.currentOsonEvent()) {
                    case VALUE_TIMESTAMP: {
                        LocalDateTime dateTime = parser.readLocalDateTime();
                        Timestamp timestamp = Timestamp.valueOf(dateTime);
                        result = this.converter.convertToEntityAttribute((Object)timestamp);
                        break block0;
                    }
                    case VALUE_DATE: {
                        LocalDate localDate = parser.readLocalDateTime().toLocalDate();
                        Date date = Date.valueOf(localDate);
                        result = this.converter.convertToEntityAttribute((Object)date);
                        break block0;
                    }
                }
                String pString = p.getText();
                if (this.elementInputType.equals(Time.class)) {
                    result = this.converter.convertToEntityAttribute((Object)Time.valueOf(pString));
                    break;
                }
                if (this.elementInputType.equals(LocalTime.class)) {
                    result = this.converter.convertToEntityAttribute((Object)LocalTime.parse(pString));
                    break;
                }
                if (pString.length() == 1) {
                    result = this.converter.convertToEntityAttribute((Object)Character.valueOf(pString.charAt(0)));
                    break;
                }
                result = this.converter.convertToEntityAttribute((Object)pString);
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                byte[] bytes = p.getBinaryValue();
                result = this.converter.convertToEntityAttribute((Object)bytes);
                break;
            }
            default: {
                String pDString = p.getText();
                result = pDString.length() == 1 ? this.converter.convertToEntityAttribute((Object)Character.valueOf(pDString.charAt(0))) : this.converter.convertToEntityAttribute((Object)pDString);
            }
        }
        return (T)result;
    }
}

