/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.resource;

import java.util.function.BiConsumer;
import java.util.function.Function;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.spi.OracleResourceProvider;

public final class ResourceParameter
implements OracleResourceProvider.Parameter {
    private final String name;
    private final String defaultValue;
    private final boolean isSensitive;
    private final boolean isRequired;
    private final BiConsumer<String, ParameterSetBuilder> parser;

    public ResourceParameter(String name, Parameter<String> providerParameter) {
        this(name, providerParameter, null);
    }

    public ResourceParameter(String name, Parameter<String> providerParameter, String defaultValue) {
        this(name, defaultValue, providerParameter.isRequired(), providerParameter.isSensitive(), (value, builder) -> {
            if (value != null) {
                builder.add(name, providerParameter, value);
            } else {
                builder.add(name, providerParameter, defaultValue);
            }
        });
    }

    public <T> ResourceParameter(String name, Parameter<T> providerParameter, String defaultValue, Function<String, T> parser) {
        this(name, defaultValue, providerParameter.isRequired(), providerParameter.isSensitive(), (value, builder) -> {
            if (value != null) {
                builder.add(name, providerParameter, parser.apply((String)value));
            } else if (defaultValue != null) {
                builder.add(name, providerParameter, parser.apply(defaultValue));
            } else {
                builder.add(name, providerParameter, null);
            }
        });
    }

    public ResourceParameter(String name, String defaultValue, boolean isRequired, boolean isSensitive, BiConsumer<String, ParameterSetBuilder> parser) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.isSensitive = isSensitive;
        this.parser = parser;
    }

    public String name() {
        return this.name;
    }

    public boolean isSensitive() {
        return this.isSensitive;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public CharSequence defaultValue() {
        return this.defaultValue;
    }

    void configureParser(ParameterSetParser.Builder builder) {
        builder.addParameter(this.name, this.parser);
    }
}

