/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import oracle.ons.Connection;
import oracle.ons.CreatePermission;
import oracle.ons.InputBuffer;
import oracle.ons.Notification;
import oracle.ons.NotificationInformation;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.ReceiverThread;
import oracle.ons.SenderThread;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;
import oracle.ons.SubscriptionNotification;

public class ONS {
    private static Object lock = new Object();
    private static ONS myoems = null;
    private Hashtable subscribers;
    private Hashtable pendingSubscriptions;
    private HashMap notifications;
    private int subscriberId;
    private int publisherId;
    private int numPublishers;
    private int localMode;
    private long startTime;
    private long lastCleanupTime;
    private String processId;
    private String hostname;
    private static String configFile;
    private static boolean isSharedInstall;
    private static String hostNameSuffix;
    private Connection connection;
    private Properties properties;
    private Object publishLock;
    private LinkedList<Notification> publishQueue;
    private Object connLock;
    private Connection[] connections;
    private boolean connCheck;
    private LinkedList<ReceiverThread> staleReceivers;
    private int maxconcurrency;
    private int concurrency;
    private int connectionIndex;
    private int senderIndex;
    private SenderThread senderThread;
    protected String walletfile;
    protected char[] password;
    protected String clusterid;
    protected String clustername;
    protected String instanceid;
    protected String instancename;
    protected String oraclehome;
    protected static boolean debug;
    protected static boolean localConn;
    protected static PrintStream outstream;
    protected static PrintStream errstream;
    protected static int shutdowntimeout;
    protected static int notificationtimeout;
    protected static int remoteIOtimeout;
    protected static final int ONS_REMOTE_MIN_TIMEOUT = 10;
    protected static final int ONS_REMOTE_MAX_TIMEOUT = 1800;
    protected static final int ONS_REMOTE_DFLT_TIMEOUT = 30000;
    protected static final int ONS_REMOTE_SUBSCRIBER_ID = 99;
    protected static final String ONS_REMOTE_SUBSCRIPTION = "(";
    protected static final String ONS_SSL_CONTEXT_PROTOCOL = "SSL";
    protected static final String ONS_SSL_KEY_MANAGEMENT = "SunX509";
    protected static final String ONS_NODES = "nodes=";
    protected static final String ONS_WALLET_FILE = "walletfile=";
    protected static final String ONS_PASSWORD = "walletpassword=";
    protected static final String ONS_HP_SEPARATOR = ",";
    protected static final String ONS_FILE_STRING = "file:";
    protected static final String ONS_REMOTE_TIMEOUT = "remotetimeout=";
    protected static final String ONS_PROPERTIES_FILE = "propertiesfile=";
    protected static final String ONS_FORMFACTOR_FILE = ".formfactor";
    protected static final char ONS_CONFIG_SEPARATOR = '\n';
    public static final String ONS_PERM_STRING = "ONSUser";
    public static final int ONS_ORACLE_HOME = 1;
    public static final int ONS_CONFIG_FILE = 2;
    public static final int ONS_ORACLE_INSTANCE = 3;
    public static final int ONS_PROTOCOL_VERSION = 4;
    private static final String SYSPROP_ORACLEINSTANCE = "oracle.instance";
    private static final String SYSPROP_ORACLEHOME = "oracle.ons.oraclehome";
    private static final String SYSPROP_ORACLECONFIGHOME = "oracle.ons.oracleconfighome";
    private static final String SYSPROP_MAXCONNECTIONS = "oracle.ons.maxconnections";
    private static final String SYSPROP_SHUTDOWNTIMEOUT = "oracle.ons.shutdowntimeout";
    private static final String SYSPROP_IGNORESCANVIP = "oracle.ons.ignorescanvip";
    private static final String SYSPROP_NODES = "oracle.ons.nodes";
    private static final String SYSPROP_REMOTETIMEOUT = "oracle.ons.remotetimeout";
    private static final String SYSPROP_WALLETFILE = "oracle.ons.walletfile";
    private static final String SYSPROP_WALLETPASSWORD = "oracle.ons.walletpassword";
    private static final String SYSPROP_DEBUG = "oracle.ons.debug";

    public static void setLogStream(PrintStream out, PrintStream err) {
        if (out != null) {
            outstream = out;
        }
        if (err != null) {
            errstream = err;
        }
    }

    protected ONS() throws ONSException {
        String timeout;
        int mode;
        String path;
        this.properties = null;
        this.connCheck = false;
        this.maxconcurrency = 3;
        this.walletfile = null;
        this.password = null;
        Object ex = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new CreatePermission(ONS_PERM_STRING));
        }
        if ((path = System.getProperty(SYSPROP_ORACLEINSTANCE)) == null) {
            path = System.getProperty(SYSPROP_ORACLECONFIGHOME);
            if (path == null) {
                path = System.getProperty(SYSPROP_ORACLEHOME);
            }
            mode = 1;
            if (path == null) {
                throw new ONSException("oracle.ons.oraclehome not set");
            }
        } else {
            mode = 3;
        }
        if ((timeout = System.getProperty(SYSPROP_SHUTDOWNTIMEOUT)) != null) {
            try {
                shutdowntimeout = Integer.valueOf(timeout);
            }
            catch (Exception e) {
                shutdowntimeout = 5;
            }
        }
        this.ons_init(mode, path);
    }

    public ONS(int mode, String value) throws ONSException {
        this.properties = null;
        this.connCheck = false;
        this.maxconcurrency = 3;
        this.walletfile = null;
        this.password = null;
        this.ons_init(mode, value);
    }

    private void ons_init(int mode, String value) throws ONSException {
        String fname;
        String hostport = null;
        ONSException ex = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new CreatePermission(ONS_PERM_STRING));
        }
        this.localMode = mode;
        if (mode == 3) {
            this.oraclehome = value;
            fname = value + File.separator + "config" + File.separator + "OPMN" + File.separator + "opmn" + File.separator + "opmn.xml";
        } else if (mode == 1) {
            this.oraclehome = value;
            fname = value + File.separator + "opmn" + File.separator + "conf" + File.separator + "opmn.xml";
        } else {
            this.localMode = 1;
            fname = value;
            int pos = value.lastIndexOf(File.separator);
            if (pos == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = value.substring(0, pos);
            if ((pos = this.oraclehome.substring(0, pos).lastIndexOf(File.separator)) == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = value.substring(0, pos);
            if ((pos = this.oraclehome.substring(0, pos).lastIndexOf(File.separator)) == -1) {
                throw new ONSException("Can't determine ORACLE_HOME from configuration file given");
            }
            this.oraclehome = value.substring(0, pos);
        }
        try {
            hostport = "127.0.0.1:" + ONS.readLocalPort(fname);
        }
        catch (ONSException e) {
            ex = e;
        }
        if (ex != null) {
            hostport = "127.0.0.1:" + ONS.readStandaloneLocalPort(this.oraclehome);
        }
        this.onsInit();
        this.buildConnection(hostport);
        this.netStartup(this.connection);
    }

    public ONS(List hplist) throws ONSException {
        this.properties = null;
        this.connCheck = false;
        this.maxconcurrency = 3;
        this.walletfile = null;
        this.password = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onsSetup(String hplist) throws ONSException {
        if (hplist == null || hplist.length() == 0) {
            throw new ONSException("host:port list is empty");
        }
        String timeout = this.getMyProperty(SYSPROP_SHUTDOWNTIMEOUT);
        if (timeout != null) {
            try {
                shutdowntimeout = Integer.valueOf(timeout);
            }
            catch (Exception e) {
                shutdowntimeout = 5;
            }
        }
        this.onsInit();
        if (debug) {
            outstream.println("ONS parameters:");
            outstream.println("  configuration location: " + this.oraclehome);
            outstream.println("  shutdown timeout: " + shutdowntimeout);
            outstream.println("  remote connection IO timeout: " + remoteIOtimeout);
            outstream.println("  remote connection maximum concurrency: " + this.maxconcurrency);
            if (this.walletfile != null) {
                outstream.println("  wallet file: <configured>");
                if (this.password != null) {
                    outstream.println("  wallet password: <configured>");
                }
            }
            outstream.println("  nodes list: " + hplist);
        }
        this.buildConnectionArray(hplist);
        this.publishLock = new Object();
        this.publishQueue = new LinkedList();
        this.connLock = new Object();
        this.staleReceivers = new LinkedList();
        this.notifications = new HashMap();
        this.lastCleanupTime = 0L;
        localConn = false;
        this.concurrency = this.connections.length;
        if (this.concurrency > this.maxconcurrency) {
            this.concurrency = this.maxconcurrency;
        }
        this.connectionIndex = this.concurrency;
        Object object = this.connLock;
        synchronized (object) {
            for (int index = 0; index < this.concurrency; ++index) {
                this.netStartup(this.connections[index]);
            }
        }
    }

    public ONS(String config) throws ONSException {
        String hplist;
        block26: {
            this.properties = null;
            this.connCheck = false;
            this.maxconcurrency = 3;
            this.walletfile = null;
            this.password = null;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new CreatePermission(ONS_PERM_STRING));
            }
            if (config == null) {
                throw new ONSException("The config string must not be null");
            }
            String pfile = this.getValue(config, ONS_PROPERTIES_FILE);
            if (pfile != null) {
                FileInputStream pfis = null;
                this.properties = new Properties();
                try {
                    pfis = new FileInputStream(pfile);
                    this.properties.load(pfis);
                    pfis.close();
                }
                catch (IOException eIO) {
                    if (pfis != null) {
                        try {
                            pfis.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw new ONSException("Failed to load properties file: " + pfile + "\n" + eIO);
                }
            }
            this.checkDebug();
            hplist = this.getConfig(SYSPROP_NODES, false, ONS_NODES, config);
            if (hplist == null) {
                throw new ONSException("No nodes were configured");
            }
            String remotetimeout = this.getConfig(SYSPROP_REMOTETIMEOUT, true, ONS_REMOTE_TIMEOUT, config);
            remoteIOtimeout = 30000;
            if (remotetimeout != null) {
                try {
                    int rtval = Integer.parseInt(remotetimeout);
                    if (rtval > 0) {
                        if ((rtval = rtval / 2 + 1) < 10) {
                            rtval = 10;
                        } else if (rtval > 1800) {
                            rtval = 1800;
                        }
                        remoteIOtimeout = rtval * 1000;
                    } else {
                        remoteIOtimeout = 0;
                    }
                }
                catch (Exception e) {
                    if (!debug) break block26;
                    outstream.println("ONS:: invalid remote timeout ignored: " + remoteIOtimeout);
                }
            }
        }
        this.walletfile = this.getConfig(SYSPROP_WALLETFILE, false, ONS_WALLET_FILE, config);
        String passwd = this.getConfig(SYSPROP_WALLETPASSWORD, false, ONS_PASSWORD, config);
        if (this.walletfile != null) {
            File wfile;
            String filestring = this.walletfile;
            if (filestring.toLowerCase().startsWith(ONS_FILE_STRING)) {
                filestring = filestring.substring(ONS_FILE_STRING.length());
            }
            if (!(wfile = new File(filestring)).isFile() && !wfile.isDirectory()) {
                throw new ONSException("walletfile: " + this.walletfile + " does not exist!");
            }
        }
        if (passwd != null) {
            this.password = passwd.toCharArray();
        }
        if (this.properties != null) {
            this.oraclehome = this.properties.getProperty(SYSPROP_ORACLECONFIGHOME);
            if (this.oraclehome == null) {
                this.oraclehome = this.properties.getProperty(SYSPROP_ORACLEHOME);
            }
        }
        if (this.oraclehome == null) {
            this.oraclehome = System.getProperty(SYSPROP_ORACLECONFIGHOME);
            if (this.oraclehome == null) {
                this.oraclehome = System.getProperty(SYSPROP_ORACLEHOME);
                if (this.oraclehome == null) {
                    this.oraclehome = "direct-connect";
                }
            }
        }
        this.onsSetup(hplist);
    }

    private String getMyProperty(String pKey) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(pKey);
        }
        if (value == null) {
            value = System.getProperty(pKey);
        }
        return value;
    }

    private String getConfig(String pKey, boolean pSys, String cKey, String config) {
        String value = null;
        if (this.properties != null) {
            value = this.properties.getProperty(pKey);
        }
        if (value == null && pSys) {
            value = System.getProperty(pKey);
        }
        if (value == null) {
            value = this.getValue(config, cKey);
        }
        return value;
    }

    private String getValue(String config, String key) {
        int index;
        boolean found = false;
        String value = null;
        int start = 0;
        int pos = 0;
        block0: while ((index = config.indexOf(key, start)) != -1 && !found) {
            pos = index;
            found = true;
            start += key.length();
            while (index > 0) {
                if (config.charAt(index - 1) == ' ') {
                    --index;
                    continue;
                }
                if (config.charAt(index - 1) == '\n') continue block0;
                found = false;
                continue block0;
            }
        }
        if (found) {
            int end = config.indexOf(10, pos += key.length());
            value = end == -1 ? config.substring(pos) : config.substring(pos, end);
        }
        return value;
    }

    private void checkDebug() {
        if (!debug && this.getMyProperty(SYSPROP_DEBUG) != null) {
            debug = true;
            outstream.println("ONS.constructor ==> DEBUG enabled");
        }
    }

    private void onsInit() {
        myoems = this;
        this.subscribers = new Hashtable();
        this.pendingSubscriptions = new Hashtable();
        this.subscriberId = 1;
        this.publisherId = 1;
        this.numPublishers = 0;
        this.startTime = System.currentTimeMillis();
        this.processId = new Long(this.startTime).toString();
        this.hostname = ONS.getHostName();
        this.clusterid = null;
        this.clustername = null;
        this.instanceid = null;
        this.instancename = null;
        this.checkDebug();
        try {
            String number = this.getMyProperty(SYSPROP_MAXCONNECTIONS);
            if (number != null) {
                this.maxconcurrency = Integer.parseInt(number);
                if (debug) {
                    outstream.println("Number of max connections:" + number);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getHostName() {
        String h = null;
        InetAddress localadd = null;
        try {
            localadd = InetAddress.getLocalHost();
            h = localadd.getHostName();
        }
        catch (Exception e) {
            errstream.println("Caught exception getting local hostname");
            e.printStackTrace(errstream);
            h = "UNKNOWNHOST";
        }
        return h;
    }

    private void netStartup(Connection conn) {
        if (debug) {
            outstream.println("ONS::netStartup ==> " + conn.getId());
        }
        ReceiverThread receiver = new ReceiverThread(this, conn);
        SenderThread sender = new SenderThread(this, conn);
        receiver.start();
        sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ONS getONS() {
        Object object = lock;
        synchronized (object) {
            if (myoems == null) {
                myoems = new ONS();
            }
        }
        return myoems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ONS getRunningONS() {
        Object object = lock;
        synchronized (object) {
            return myoems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscriber(Subscriber s, long timeout) throws SubscriptionException {
        Object object = lock;
        synchronized (object) {
            s.setID(this.subscriberId);
            ++this.subscriberId;
            if (this.subscriberId == 99) {
                ++this.subscriberId;
            }
        }
        if (debug) {
            outstream.println("add subscriber id " + s.id() + " " + s.subscription());
        }
        SubscriptionNotification se = new SubscriptionNotification(s.id(), s.subscription(), true);
        object = this.pendingSubscriptions;
        synchronized (object) {
            this.pendingSubscriptions.put(new Integer(s.id()), se);
        }
        if (localConn) {
            if (this.connection != null) {
                if (debug) {
                    outstream.println("sending (local) subscriber id " + s.id());
                }
                this.connection.sender.send(se);
            }
        } else {
            Object object2 = this.connLock;
            synchronized (object2) {
                for (int index = 0; index < this.connections.length; ++index) {
                    if (this.connections[index].sender == null) continue;
                    if (debug) {
                        outstream.println("sending (" + this.connections[index].getId() + ") subscriber id " + s.id());
                    }
                    this.connections[index].sender.send(se);
                }
            }
        }
        se.waitForReply(timeout);
        if (se.success) {
            if (debug) {
                outstream.println("hash array put subscriber id " + s.id());
            }
            Hashtable hashtable = this.subscribers;
            synchronized (hashtable) {
                this.subscribers.put(new Integer(s.id()), s);
            }
        } else {
            if (se.ex != null) {
                throw se.ex;
            }
            throw new SubscriptionException("Subscription failed for unknown reason");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscriber(int id) {
        boolean shutdown = false;
        if (debug) {
            outstream.println("remove subscriber id " + id);
        }
        Object object = this.subscribers;
        synchronized (object) {
            this.subscribers.remove(new Integer(id));
            int hSize = this.subscribers.size();
            if (debug) {
                outstream.println("subscribers hash table size = " + hSize);
            }
            if (hSize == 0) {
                shutdown = true;
            }
        }
        if (shutdown) {
            object = lock;
            synchronized (object) {
                if (this.numPublishers != 0) {
                    shutdown = false;
                }
            }
        }
        if (shutdown) {
            if (debug) {
                outstream.println("last subscriber initiating ONS shutdown");
            }
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscriber lookupSubscriber(int id) {
        Subscriber ret;
        Hashtable hashtable = this.subscribers;
        synchronized (hashtable) {
            ret = (Subscriber)this.subscribers.get(new Integer(id));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPublisher(Publisher p) {
        Object object = lock;
        synchronized (object) {
            p.id(this.publisherId);
            ++this.publisherId;
            ++this.numPublishers;
        }
        if (debug) {
            outstream.println("add publisher id " + this.publisherId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePublisher(Publisher p) {
        boolean shutdown = false;
        if (debug) {
            outstream.println("remove publisher id " + p.id());
        }
        Object object = lock;
        synchronized (object) {
            --this.numPublishers;
            if (debug) {
                outstream.println("number of publishers = " + this.numPublishers);
            }
            if (this.numPublishers == 0) {
                shutdown = true;
            }
        }
        if (shutdown) {
            object = this.subscribers;
            synchronized (object) {
                if (this.subscribers.size() != 0) {
                    shutdown = false;
                }
            }
        }
        if (shutdown) {
            if (debug) {
                outstream.println("last publisher initiating ONS shutdown");
            }
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        boolean stop = false;
        Object object = lock;
        synchronized (object) {
            if (myoems != null) {
                myoems = null;
                stop = true;
            }
        }
        if (!stop) {
            return;
        }
        if (localConn) {
            if (this.connection != null) {
                if (debug) {
                    outstream.println("ONS::shutdown ==> " + this.connection.getId());
                }
                this.connection.sender.shutdown();
                this.connection.receiver.shutdown();
                this.connection = null;
            }
        } else {
            Object object2 = this.connLock;
            synchronized (object2) {
                this.concurrency = 0;
            }
            boolean busy = true;
            do {
                object2 = this.connLock;
                synchronized (object2) {
                    if (!this.connCheck) {
                        busy = false;
                    }
                }
                if (!busy) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            } while (busy);
            if (debug) {
                outstream.println("ONS::shutdown ==> remote: " + this.connections.length);
            }
            this.joinStaleRecievers();
            for (int index = 0; index < this.connections.length; ++index) {
                boolean joined;
                if (debug) {
                    outstream.println("   ::shutdown ==> " + this.connections[index].getId());
                }
                this.connections[index].setClientShutdown(true);
                if (this.connections[index].sender != null) {
                    this.connections[index].sender.shutdown();
                    do {
                        try {
                            this.connections[index].sender.join();
                            joined = true;
                        }
                        catch (Exception e) {
                            joined = false;
                        }
                    } while (!joined);
                    this.connections[index].setClientSender(null);
                }
                if (this.connections[index].receiver == null) continue;
                this.connections[index].receiver.shutdown();
                do {
                    try {
                        this.connections[index].receiver.join();
                        joined = true;
                    }
                    catch (Exception e) {
                        joined = false;
                    }
                } while (!joined);
                this.connections[index].setClientReceiver(null);
            }
        }
    }

    protected String processId() {
        return this.processId;
    }

    protected String hostname() {
        return this.hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(Notification e) {
        if (localConn) {
            if (this.connection != null) {
                this.connection.sender.send(e);
            }
        } else {
            Object object = this.publishLock;
            synchronized (object) {
                this.publishQueue.add(e);
            }
            object = this.connLock;
            synchronized (object) {
                SenderThread sender = this.getSenderThread(false);
                if (sender != null) {
                    sender.wakeThread();
                }
            }
        }
    }

    private SenderThread getSenderThread(boolean wakeNew) {
        if (this.senderThread == null && this.concurrency != 0) {
            int index = this.senderIndex;
            for (int count = 0; count < this.connections.length; ++count) {
                if (index == this.connections.length) {
                    index = 0;
                }
                if (this.connections[index].sender != null && this.connections[index].socket != null) {
                    this.senderThread = this.connections[index].sender;
                    if (this.senderIndex != index) {
                        this.senderIndex = index;
                    }
                    if (debug) {
                        outstream.println("Selected new sender: " + this.senderThread);
                    }
                    if (!wakeNew) break;
                    this.senderThread.wakeThread();
                    break;
                }
                ++index;
            }
        }
        return this.senderThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Notification getFirstPublished(SenderThread st) {
        Notification e = null;
        Object object = this.connLock;
        synchronized (object) {
            SenderThread sender = this.getSenderThread(true);
            if (st == sender) {
                Object object2 = this.publishLock;
                synchronized (object2) {
                    int count = this.publishQueue.size();
                    if (count != 0) {
                        e = this.publishQueue.getFirst();
                    }
                }
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFirstPublished(Notification re, SenderThread st) {
        Object object = this.connLock;
        synchronized (object) {
            SenderThread sender = this.getSenderThread(true);
            if (st == sender) {
                Object object2 = this.publishLock;
                synchronized (object2) {
                    Notification e;
                    int count = this.publishQueue.size();
                    if (count != 0 && (e = this.publishQueue.removeFirst()) != re) {
                        this.publishQueue.addFirst(e);
                        errstream.println("Removal requested for wrong notification: " + re);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearPublishedSender(SenderThread st) {
        Object object = this.connLock;
        synchronized (object) {
            if (debug) {
                outstream.println("Clear: calling: " + st + " current " + this.senderThread);
            }
            if (st == this.senderThread) {
                this.senderThread = null;
                if (debug) {
                    outstream.println("Clearing current sender");
                }
                SenderThread senderThread = this.getSenderThread(true);
            }
        }
    }

    protected void deliver(Notification e) {
        if (!localConn && this.connections != null && this.isDupNotification(e)) {
            return;
        }
        if (e.recipients != null && e.recipients.length > 0) {
            for (int i = 0; i < e.recipients.length; ++i) {
                Subscriber cur = this.lookupSubscriber(e.recipients[i]);
                if (cur == null) continue;
                cur.deliver(e);
            }
        }
    }

    protected boolean bytesEqual(byte[] a, byte[] b, int len) {
        boolean same = true;
        if ((a.length < len || b.length < len) && a.length != b.length) {
            return false;
        }
        for (int i = 0; same && i < len; ++i) {
            same = a[i] == b[i];
        }
        return same;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSubscriptionReply(int sid, boolean success, String message) {
        SubscriptionNotification se;
        SubscriptionException ex = null;
        Integer subId = new Integer(sid);
        Hashtable hashtable = this.pendingSubscriptions;
        synchronized (hashtable) {
            se = (SubscriptionNotification)this.pendingSubscriptions.get(subId);
            if (se != null) {
                this.pendingSubscriptions.remove(subId);
            }
        }
        if (se != null) {
            if (!success && message != null) {
                ex = new SubscriptionException(message);
            }
            se.wakeup(success, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resendSubscriptions(SenderThread st) {
        Hashtable hashtable = this.pendingSubscriptions;
        synchronized (hashtable) {
            SubscriptionNotification se;
            Enumeration subs;
            if (this.pendingSubscriptions.size() > 0) {
                if (debug) {
                    outstream.println("Resending pending subscriptions: " + this.pendingSubscriptions.size());
                }
                subs = this.pendingSubscriptions.elements();
                while (subs.hasMoreElements()) {
                    se = (SubscriptionNotification)subs.nextElement();
                    st.send(se, 1);
                }
            }
            Hashtable hashtable2 = this.subscribers;
            synchronized (hashtable2) {
                if (this.subscribers.size() > 0) {
                    if (debug) {
                        outstream.println("Resending subscriptions: " + this.subscribers.size());
                    }
                    subs = this.subscribers.elements();
                    while (subs.hasMoreElements()) {
                        Subscriber cur = (Subscriber)subs.nextElement();
                        Integer subId = new Integer(cur.id());
                        se = (SubscriptionNotification)this.pendingSubscriptions.get(subId);
                        if (se != null) continue;
                        se = new SubscriptionNotification(cur.id(), cur.subscription(), false);
                        this.pendingSubscriptions.put(subId, se);
                        st.send(se, 1);
                    }
                }
            }
        }
    }

    public Subscriber createNewSubscriber(String s, String c) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SubscribePermission(ONS_PERM_STRING));
        }
        return new Subscriber(this, s, c);
    }

    public Subscriber createNewSubscriber(String s, String c, long timeout) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SubscribePermission(ONS_PERM_STRING));
        }
        return new Subscriber(this, s, c, timeout);
    }

    public Publisher createNewPublisher(String c) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PublishPermission(ONS_PERM_STRING));
        }
        return new Publisher(this, c);
    }

    public static int readLocalPort(String fname) throws ONSException {
        return ONS.readPortFromConfigFile(fname, "local");
    }

    public static int readRemotePort(String fname) throws ONSException {
        return ONS.readPortFromConfigFile(fname, "remote");
    }

    public static int readRequestPort(String fname) throws ONSException {
        return ONS.readPortFromConfigFile(fname, "request");
    }

    private static int readPortFromConfigFile(String fname, String portname) throws ONSException {
        FileInputStream fis = null;
        boolean done = false;
        String portstr = null;
        int port = -1;
        boolean foundopenport = false;
        boolean foundport = false;
        try {
            fis = new FileInputStream(fname);
        }
        catch (Exception e) {
            throw new ONSException("Unable to open config file " + fname);
        }
        InputBuffer ib = new InputBuffer(fis);
        try {
            while (!done) {
                int i;
                int eq;
                int loc;
                String line = ib.getNextLine();
                if (!foundopenport && (loc = line.indexOf("<port")) != -1) {
                    foundopenport = true;
                    line = line.substring(5);
                }
                if (!foundopenport) continue;
                if (!foundport && (loc = line.indexOf(portname)) != -1) {
                    foundport = true;
                    line = line.substring(loc + portname.length());
                }
                if (!foundport || (eq = line.indexOf(61)) == -1) continue;
                portstr = line.substring(eq + 1);
                int len = (portstr = portstr.trim()).length();
                if (len == 0) continue;
                if (portstr.charAt(0) == '\"') {
                    portstr = portstr.substring(1);
                }
                for (i = 0; i < len && Character.isDigit(portstr.charAt(i)); ++i) {
                }
                if (i == 0) continue;
                if (i != len) {
                    portstr = portstr.substring(0, i);
                }
                try {
                    port = Integer.decode(portstr);
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
                if (port == -1) continue;
                done = true;
            }
        }
        catch (IOException e) {
            if (e.getMessage().equals("End of data encountered.")) {
                throw new ONSException("No port entry found in config file " + fname);
            }
            throw new ONSException("I/O error encountered reading config file " + fname);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
        if (port == -1) {
            throw new ONSException("No port entry found in config file " + fname);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readStandaloneLocalPort(String oraclehome) throws ONSException {
        int port;
        block27: {
            FileInputStream fis = null;
            boolean done = false;
            String portstr = null;
            port = -1;
            boolean foundport = false;
            ONS.getConfigFileName(oraclehome);
            try {
                fis = new FileInputStream(configFile);
            }
            catch (Exception e) {
                throw new ONSException("Unable to open config file");
            }
            InputBuffer ib = new InputBuffer(fis);
            port = 6100;
            try {
                while (!done) {
                    String propVal;
                    String line = ib.getNextLine();
                    line.toLowerCase();
                    line.trim();
                    if (line.startsWith("localport=")) {
                        int i;
                        portstr = line.substring(10);
                        int len = (portstr = portstr.trim()).length();
                        if (len == 0) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        if (portstr.charAt(0) == '\"') {
                            portstr = portstr.substring(1);
                        }
                        for (i = 0; i < len && Character.isDigit(portstr.charAt(i)); ++i) {
                        }
                        if (i == 0) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        if (i != len) {
                            portstr = portstr.substring(0, i);
                        }
                        try {
                            port = Integer.decode(portstr);
                        }
                        catch (NumberFormatException e) {
                            throw new ONSException("Format error when reading localport value");
                        }
                        foundport = true;
                    } else if (!isSharedInstall && line.startsWith("usesharedinstall=") && (propVal = line.substring(17)).equalsIgnoreCase("true")) {
                        if (hostNameSuffix == null) {
                            throw new ONSException("GetHostName system call failed. Cannot proceed");
                        }
                        isSharedInstall = true;
                    }
                    if (!foundport || !isSharedInstall) continue;
                    done = true;
                }
            }
            catch (IOException e) {
                if (e.getMessage().equals("End of data encountered.")) {
                    if (!foundport) {
                        throw new ONSException("No port entry found in config file " + configFile);
                    }
                    break block27;
                }
                throw new ONSException("I/O error encountered reading config file " + configFile);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return port;
    }

    private static void getConfigFileName(String oraclehome) {
        String tmpConfigFile = oraclehome + File.separator + "opmn" + File.separator + "conf" + File.separator + "ons.config";
        configFile = null;
        isSharedInstall = false;
        hostNameSuffix = null;
        String tmpHName = ONS.getHostName();
        if (tmpHName.equals("UNKNOWNHOST")) {
            File configFileObj = new File(tmpConfigFile);
            if (configFileObj.exists()) {
                configFile = tmpConfigFile;
                return;
            }
            errstream.println("ERROR: Hostname could not be resolved and config file (ons.config) could not be found.");
            return;
        }
        int dotPos = tmpHName.indexOf(46);
        hostNameSuffix = dotPos != -1 ? tmpHName.substring(0, dotPos) : tmpHName;
        String tmpConfigFileOrig = tmpConfigFile;
        File configFileObj = new File(tmpConfigFile = tmpConfigFile + "." + hostNameSuffix);
        if (configFileObj.exists()) {
            configFile = tmpConfigFile;
            isSharedInstall = true;
            return;
        }
        tmpConfigFile = tmpConfigFileOrig;
        configFileObj = new File(tmpConfigFile);
        if (configFileObj.exists()) {
            configFile = tmpConfigFile;
            return;
        }
        errstream.println("ERROR: config file (ons.config) could not be found.");
    }

    public static String readFormFactor(String path) throws ONSException {
        String cpath = path + File.separator + ONS_FORMFACTOR_FILE;
        String formfactor = ONS.getFormFactor(cpath, false);
        if (formfactor != null) {
            return formfactor;
        }
        String hpath = ONS.createHomeFormFactor(path);
        formfactor = ONS.getFormFactor(hpath, false);
        if (formfactor != null) {
            return formfactor;
        }
        String ipath = ONS.createInstanceFormFactor(path);
        formfactor = ONS.getFormFactor(ipath, false);
        if (formfactor != null) {
            return formfactor;
        }
        throw new ONSException("Failed to find FormFactor: checked " + cpath + ", " + hpath + ", and " + ipath);
    }

    private static String createInstanceFormFactor(String path) {
        return path + File.separator + "config" + File.separator + "OPMN" + File.separator + "opmn" + File.separator + ONS_FORMFACTOR_FILE;
    }

    private static String createHomeFormFactor(String path) {
        return path + File.separator + "opmn" + File.separator + "conf" + File.separator + ONS_FORMFACTOR_FILE;
    }

    String getFormFactor(String path) throws ONSException {
        String fpath = this.localMode == 3 ? ONS.createInstanceFormFactor(path) : ONS.createHomeFormFactor(path);
        if (isSharedInstall) {
            fpath = fpath + "." + hostNameSuffix;
        }
        return ONS.getFormFactor(fpath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFormFactor(String fpath, boolean ex) throws ONSException {
        FileInputStream fis = null;
        String formfactor = null;
        int len = 0;
        try {
            fis = new FileInputStream(fpath);
        }
        catch (Exception e) {
            if (ex) {
                throw new ONSException("Unable to open formfactor file " + fpath);
            }
            return null;
        }
        try {
            byte[] buffer = new byte[64];
            len = fis.read(buffer);
            if (len > 0) {
                formfactor = new String(buffer, 0, len);
            }
            fis.close();
        }
        catch (IOException e) {
            if (ex) {
                if (e.getMessage().equals("End of data encountered.")) {
                    throw new ONSException("No entry found in formfactor file " + fpath);
                }
                throw new ONSException("I/O error encountered reading formfactor file " + fpath);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
        if (len <= 0) {
            if (ex) {
                throw new ONSException("No entry found in formfactor file " + fpath);
            }
            formfactor = null;
        }
        return formfactor;
    }

    public Connection[] getConnections() {
        return this.connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDupNotification(Notification e) {
        if (e.id == null || e.instanceName == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            String nkey;
            NotificationInformation ninfo;
            if (currentTime - this.lastCleanupTime >= (long)notificationtimeout) {
                this.lastCleanupTime = currentTime;
                this.cleanupNotificationTable(currentTime);
            }
            if ((ninfo = (NotificationInformation)this.notifications.get(nkey = e.instanceName + e.id)) == null) {
                ninfo = new NotificationInformation(currentTime);
                ninfo.addCount();
                this.notifications.put(nkey, ninfo);
                return false;
            }
            ninfo.addCount();
            this.cleanupNotificationTable(nkey, ninfo);
        }
        return true;
    }

    private void cleanupNotificationTable(String key, NotificationInformation elem) {
        if (key == null || elem == null) {
            return;
        }
        if (elem.getCount() >= this.concurrency) {
            this.notifications.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupNotificationTable(long currentTime) {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Set set = this.notifications.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                NotificationInformation ninfo = (NotificationInformation)entry.getValue();
                if (currentTime - ninfo.getTimestamp() <= (long)notificationtimeout) continue;
                it.remove();
            }
        }
    }

    private void buildConnection(String hostport) throws ONSException {
        int port;
        if (hostport == null || hostport.length() == 0) {
            throw new ONSException("host:port list is empty");
        }
        int colon = hostport.lastIndexOf(58);
        if (colon != -1) {
            try {
                port = Integer.valueOf(hostport.substring(colon + 1));
            }
            catch (Exception e) {
                throw new ONSException("Invalid port value for host:port pair " + hostport);
            }
        } else {
            throw new ONSException("Invalid host:port syntax " + hostport);
        }
        this.connection = new Connection(this, hostport.substring(0, colon), port);
    }

    private void buildConnectionArray(String hplist) throws ONSException {
        int port;
        int colon;
        int index;
        String[] hp;
        if (!Boolean.valueOf(this.getMyProperty(SYSPROP_IGNORESCANVIP)).booleanValue()) {
            if (debug) {
                outstream.println("Using SCAN VIP on nodes list...");
            }
            hp = this.scanNodes(hplist);
        } else {
            if (debug) {
                outstream.println("Using nodes list directly...");
            }
            hp = hplist.split(ONS_HP_SEPARATOR);
        }
        if (debug) {
            outstream.printf("Remote Servers Configured(%d):\n", hp.length);
            for (index = 0; index < hp.length; ++index) {
                outstream.println("  " + hp[index]);
            }
        }
        int valid = 0;
        for (index = 0; index < hp.length; ++index) {
            colon = hp[index].lastIndexOf(58);
            if (colon != -1) {
                try {
                    port = Integer.valueOf(hp[index].substring(colon + 1));
                    ++valid;
                }
                catch (Exception e) {
                    errstream.println("Invalid port value for host:port pair " + hp[index]);
                }
                continue;
            }
            errstream.println("Invalid host:port syntax " + hp[index]);
        }
        if (valid != 0) {
            this.connections = new Connection[valid];
            int count = 0;
            for (index = 0; index < hp.length; ++index) {
                colon = hp[index].lastIndexOf(58);
                if (colon == -1) continue;
                try {
                    port = Integer.valueOf(hp[index].substring(colon + 1));
                    this.connections[count] = new Connection(this, hp[index].substring(0, colon), port);
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (count != valid) {
                this.connections = null;
                throw new ONSException("fatal host:port list parse error: " + hplist);
            }
        } else {
            throw new ONSException("No valid host:port values found in list: " + hplist);
        }
    }

    private String[] scanNodes(String hpList) {
        String[] endPoints;
        StringBuilder nodesBuild = new StringBuilder();
        for (String endPoint : endPoints = hpList.split(ONS_HP_SEPARATOR)) {
            String[] nodeParts = endPoint.split(":");
            if (nodeParts.length != 2) {
                throw new ONSException("bad format of node (expected 'host:port') in provided ONS configuration: " + endPoint);
            }
            String hostPart = nodeParts[0];
            String portPart = nodeParts[1];
            InetAddress[] addrs = null;
            try {
                addrs = InetAddress.getAllByName(hostPart);
            }
            catch (UnknownHostException e) {
                throw new ONSException("Error deriving server nodes from configuration:\n" + e);
            }
            if (addrs.length == 1) {
                if (nodesBuild.length() != 0) {
                    nodesBuild.append(ONS_HP_SEPARATOR);
                }
                nodesBuild.append(endPoint);
                continue;
            }
            for (InetAddress addr : addrs) {
                if (nodesBuild.length() != 0) {
                    nodesBuild.append(ONS_HP_SEPARATOR);
                }
                String addrEndPoint = addr.getHostAddress() + ":" + portPart;
                nodesBuild.append(addrEndPoint);
            }
        }
        String nodesList = nodesBuild.toString();
        String[] nodes = nodesList.split(ONS_HP_SEPARATOR);
        this.nodesRandomize(nodes);
        return nodes;
    }

    private void nodesRandomize(String[] nodes) {
        int size = nodes.length;
        if (size <= 1) {
            return;
        }
        Random randomizer = new Random();
        for (int index = 0; index < size; ++index) {
            int swapPos = randomizer.nextInt(size);
            String tmp = nodes[index];
            nodes[index] = nodes[swapPos];
            nodes[swapPos] = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkConnections(Connection conn) {
        if (!localConn && this.connections.length > this.maxconcurrency) {
            Object object;
            boolean busy = true;
            do {
                object = this.connLock;
                synchronized (object) {
                    if (!this.connCheck) {
                        this.connCheck = true;
                        busy = false;
                    }
                }
                if (!busy) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            } while (busy);
            if (this.concurrency != 0) {
                if (debug) {
                    outstream.println("ONS::checkConnections ==> conn " + conn.getId());
                }
                this.joinStaleRecievers();
                int index = this.connectionIndex;
                for (int count = 0; count < this.connections.length; ++count) {
                    if (index == this.connections.length) {
                        index = 0;
                    }
                    if (this.connections[index] != conn && this.connections[index].receiver == null) {
                        this.replaceConnection(conn, this.connections[index]);
                        this.connectionIndex = index + 1;
                        break;
                    }
                    ++index;
                }
            }
            object = this.connLock;
            synchronized (object) {
                this.connCheck = false;
            }
        }
    }

    private void replaceConnection(Connection oConn, Connection nConn) {
        boolean joined;
        if (debug) {
            outstream.println("ONS::replaceConnection ==> old " + oConn.getId() + " new " + nConn.getId());
        }
        oConn.setClientShutdown(true);
        oConn.receiver.shutdown();
        this.staleReceivers.add(oConn.receiver);
        oConn.sender.stopThread();
        do {
            try {
                oConn.sender.join();
                joined = true;
            }
            catch (Exception e) {
                joined = false;
            }
        } while (!joined);
        oConn.setClientSender(null);
        oConn.setClientReceiver(null);
        oConn.setClientShutdown(false);
        this.netStartup(nConn);
    }

    private void joinStaleRecievers() {
        if (this.staleReceivers != null) {
            try {
                ReceiverThread recv = this.staleReceivers.removeFirst();
                while (recv != null) {
                    boolean joined;
                    do {
                        try {
                            recv.join();
                            joined = true;
                        }
                        catch (InterruptedException ie) {
                            joined = false;
                        }
                    } while (!joined);
                    recv = this.staleReceivers.removeFirst();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    static {
        debug = false;
        localConn = true;
        outstream = System.out;
        errstream = System.err;
        shutdowntimeout = 5;
        notificationtimeout = 30000;
    }
}

