/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.mangofactory.swagger.models.dto.Parameter;
import com.mangofactory.swagger.readers.operation.parameter.ParameterAllowableReader;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

class ParameterBuilder {
    private String dataTypeName;
    private String parentName;
    private Field field;

    ParameterBuilder() {
    }

    public ParameterBuilder withDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
        return this;
    }

    public ParameterBuilder withParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public ParameterBuilder forField(Field field) {
        this.field = field;
        return this;
    }

    public Parameter build() {
        Optional apiModelPropertyOptional = Annotations.findApiModePropertyAnnotation((AnnotatedElement)this.field);
        if (apiModelPropertyOptional.isPresent()) {
            return this.fromApiModelProperty((ApiModelProperty)apiModelPropertyOptional.get());
        }
        Optional apiParamOptional = Annotations.findApiParamAnnotation((AnnotatedElement)this.field);
        if (apiParamOptional.isPresent()) {
            return this.fromApiParam((ApiParam)apiParamOptional.get());
        }
        return this.defaultParameter();
    }

    private Parameter defaultParameter() {
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.absent(), this.field);
        return new com.mangofactory.swagger.models.dto.builder.ParameterBuilder().name(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName())).description(null).defaultValue(null).required(Boolean.FALSE).allowMultiple(Boolean.FALSE).dataType(this.dataTypeName).allowableValues(allowable).parameterType("query").parameterAccess(null).build();
    }

    private Parameter fromApiParam(ApiParam apiParam) {
        String allowableProperty = Strings.emptyToNull((String)apiParam.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), this.field);
        return new com.mangofactory.swagger.models.dto.builder.ParameterBuilder().name(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName())).description(apiParam.value()).defaultValue(apiParam.defaultValue()).required(Boolean.valueOf(apiParam.required())).allowMultiple(Boolean.valueOf(apiParam.allowMultiple())).dataType(this.dataTypeName).allowableValues(allowable).parameterType("query").parameterAccess(apiParam.access()).build();
    }

    private Parameter fromApiModelProperty(ApiModelProperty apiModelProperty) {
        String allowableProperty = Strings.emptyToNull((String)apiModelProperty.allowableValues());
        AllowableValues allowable = this.allowableValues((Optional<String>)Optional.fromNullable((Object)allowableProperty), this.field);
        return new com.mangofactory.swagger.models.dto.builder.ParameterBuilder().name(Strings.isNullOrEmpty((String)this.parentName) ? this.field.getName() : String.format("%s.%s", this.parentName, this.field.getName())).description(apiModelProperty.value()).defaultValue(null).required(Boolean.valueOf(apiModelProperty.required())).allowMultiple(Boolean.FALSE).dataType(this.dataTypeName).allowableValues(allowable).parameterType("query").parameterAccess(apiModelProperty.access()).build();
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Field field) {
        AllowableValues allowable = null;
        if (field.getType().isEnum()) {
            allowable = new AllowableListValues(this.getEnumValues(field.getType()), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ParameterAllowableReader.allowableValueFromString((String)optionalAllowable.get());
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

