/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandOutput;
import java.nio.ByteBuffer;

public class PubSubOutput<K, V>
extends CommandOutput<K, V, V> {
    private Type type;
    private K channel;
    private K pattern;
    private long count;

    public PubSubOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    public Type type() {
        return this.type;
    }

    public K channel() {
        return this.channel;
    }

    public K pattern() {
        return this.pattern;
    }

    public long count() {
        return this.count;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.type == null) {
            this.type = Type.valueOf(this.decodeAscii(bytes));
            return;
        }
        switch (this.type) {
            case pmessage: {
                if (this.pattern == null) {
                    this.pattern = this.codec.decodeKey(bytes);
                    break;
                }
            }
            case message: {
                if (this.channel == null) {
                    this.channel = this.codec.decodeKey(bytes);
                    break;
                }
                this.output = this.codec.decodeValue(bytes);
                break;
            }
            case psubscribe: 
            case punsubscribe: {
                this.pattern = this.codec.decodeKey(bytes);
                break;
            }
            case subscribe: 
            case unsubscribe: {
                this.channel = this.codec.decodeKey(bytes);
            }
        }
    }

    @Override
    public void set(long integer) {
        this.count = integer;
    }

    static enum Type {
        message,
        pmessage,
        psubscribe,
        punsubscribe,
        subscribe,
        unsubscribe;

    }
}

