/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.protocol.CommandHandler;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class ConnectionWatchdog
extends SimpleChannelUpstreamHandler
implements TimerTask {
    private ClientBootstrap bootstrap;
    private Channel channel;
    private ChannelGroup channels;
    private Timer timer;
    private boolean reconnect;
    private int attempts;

    public ConnectionWatchdog(ClientBootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = ctx.getChannel();
        this.channels.add((Object)this.channel);
        this.attempts = 0;
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.reconnect) {
            if (this.attempts < 8) {
                ++this.attempts;
            }
            int timeout = 2 << this.attempts;
            this.timer.newTimeout((TimerTask)this, (long)timeout, TimeUnit.MILLISECONDS);
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.getChannel().close();
    }

    public void run(Timeout timeout) throws Exception {
        ChannelPipeline old = this.channel.getPipeline();
        CommandHandler handler = (CommandHandler)old.get(CommandHandler.class);
        RedisAsyncConnection connection = (RedisAsyncConnection)old.get(RedisAsyncConnection.class);
        ChannelPipeline pipeline = Channels.pipeline((ChannelHandler[])new ChannelHandler[]{this, handler, connection});
        Channel c = this.bootstrap.getFactory().newChannel(pipeline);
        c.getConfig().setOptions(this.bootstrap.getOptions());
        c.connect((SocketAddress)this.bootstrap.getOption("remoteAddress"));
    }
}

