/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandType;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RedisConnection<K, V> {
    protected RedisAsyncConnection<K, V> c;
    protected long timeout;
    protected TimeUnit unit;

    public RedisConnection(RedisAsyncConnection<K, V> c) {
        this.c = c;
        this.timeout = c.timeout;
        this.unit = c.unit;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        this.c.setTimeout(timeout, unit);
    }

    public Long append(K key, V value) {
        return this.await(this.c.append(key, value));
    }

    public String auth(String password) {
        return this.c.auth(password);
    }

    public String bgrewriteaof() {
        return this.await(this.c.bgrewriteaof());
    }

    public String bgsave() {
        return this.await(this.c.bgsave());
    }

    public Long bitcount(K key) {
        return this.await(this.c.bitcount(key));
    }

    public Long bitcount(K key, long start, long end) {
        return this.await(this.c.bitcount(key, start, end));
    }

    public Long bitopAnd(K destination, K ... keys) {
        return this.await(this.c.bitopAnd(destination, keys));
    }

    public Long bitopNot(K destination, K source) {
        return this.await(this.c.bitopNot(destination, source));
    }

    public Long bitopOr(K destination, K ... keys) {
        return this.await(this.c.bitopOr(destination, keys));
    }

    public Long bitopXor(K destination, K ... keys) {
        return this.await(this.c.bitopXor(destination, keys));
    }

    public KeyValue<K, V> blpop(long timeout, K ... keys) {
        long timeout2 = timeout == 0L ? Long.MAX_VALUE : Math.max(timeout, this.unit.toSeconds(this.timeout));
        return this.await(this.c.blpop(timeout, keys), timeout2, TimeUnit.SECONDS);
    }

    public KeyValue<K, V> brpop(long timeout, K ... keys) {
        long timeout2 = timeout == 0L ? Long.MAX_VALUE : Math.max(timeout, this.unit.toSeconds(this.timeout));
        return this.await(this.c.brpop(timeout, keys), timeout2, TimeUnit.SECONDS);
    }

    public V brpoplpush(long timeout, K source, K destination) {
        long timeout2 = timeout == 0L ? Long.MAX_VALUE : Math.max(timeout, this.unit.toSeconds(this.timeout));
        return this.await(this.c.brpoplpush(timeout, source, destination), timeout2, TimeUnit.SECONDS);
    }

    public K clientGetname() {
        return this.await(this.c.clientGetname());
    }

    public String clientSetname(K name) {
        return this.await(this.c.clientSetname(name));
    }

    public String clientKill(String addr) {
        return this.await(this.c.clientKill(addr));
    }

    public String clientList() {
        return this.await(this.c.clientList());
    }

    public List<String> configGet(String parameter) {
        return this.await(this.c.configGet(parameter));
    }

    public String configResetstat() {
        return this.await(this.c.configResetstat());
    }

    public String configSet(String parameter, String value) {
        return this.await(this.c.configSet(parameter, value));
    }

    public Long dbsize() {
        return this.await(this.c.dbsize());
    }

    public String debugObject(K key) {
        return this.await(this.c.debugObject(key));
    }

    public Long decr(K key) {
        return this.await(this.c.decr(key));
    }

    public Long decrby(K key, long amount) {
        return this.await(this.c.decrby(key, amount));
    }

    public Long del(K ... keys) {
        return this.await(this.c.del(keys));
    }

    public String discard() {
        return this.await(this.c.discard());
    }

    public byte[] dump(K key) {
        return this.await(this.c.dump(key));
    }

    public V echo(V msg) {
        return this.await(this.c.echo(msg));
    }

    public <T> T eval(V script, ScriptOutputType type, K ... keys) {
        return this.await(this.c.eval(script, type, keys, new Object[0]));
    }

    public <T> T eval(V script, ScriptOutputType type, K[] keys, V ... values) {
        return this.await(this.c.eval(script, type, keys, values));
    }

    public <T> T evalsha(String digest, ScriptOutputType type, K ... keys) {
        return this.await(this.c.evalsha(digest, type, keys, new Object[0]));
    }

    public <T> T evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.await(this.c.evalsha(digest, type, keys, values));
    }

    public Boolean exists(K key) {
        return this.await(this.c.exists(key));
    }

    public Boolean expire(K key, long seconds) {
        return this.await(this.c.expire(key, seconds));
    }

    public Boolean expireat(K key, Date timestamp) {
        return this.await(this.c.expireat(key, timestamp));
    }

    public Boolean expireat(K key, long timestamp) {
        return this.await(this.c.expireat(key, timestamp));
    }

    public List<Object> exec() {
        return this.await(this.c.exec());
    }

    public String flushall() throws Exception {
        return this.await(this.c.flushall());
    }

    public String flushdb() throws Exception {
        return this.await(this.c.flushdb());
    }

    public V get(K key) {
        return this.await(this.c.get(key));
    }

    public Long getbit(K key, long offset) {
        return this.await(this.c.getbit(key, offset));
    }

    public V getrange(K key, long start, long end) {
        return this.await(this.c.getrange(key, start, end));
    }

    public V getset(K key, V value) {
        return this.await(this.c.getset(key, value));
    }

    public Long hdel(K key, K ... fields) {
        return this.await(this.c.hdel(key, fields));
    }

    public Boolean hexists(K key, K field) {
        return this.await(this.c.hexists(key, field));
    }

    public V hget(K key, K field) {
        return this.await(this.c.hget(key, field));
    }

    public Long hincrby(K key, K field, long amount) {
        return this.await(this.c.hincrby(key, field, amount));
    }

    public Double hincrbyfloat(K key, K field, double amount) {
        return this.await(this.c.hincrbyfloat(key, field, amount));
    }

    public Map<K, V> hgetall(K key) {
        return this.await(this.c.hgetall(key));
    }

    public List<K> hkeys(K key) {
        return this.await(this.c.hkeys(key));
    }

    public Long hlen(K key) {
        return this.await(this.c.hlen(key));
    }

    public List<V> hmget(K key, K ... fields) {
        return this.await(this.c.hmget(key, fields));
    }

    public String hmset(K key, Map<K, V> map) {
        return this.await(this.c.hmset(key, map));
    }

    public Boolean hset(K key, K field, V value) {
        return this.await(this.c.hset(key, field, value));
    }

    public Boolean hsetnx(K key, K field, V value) {
        return this.await(this.c.hsetnx(key, field, value));
    }

    public List<V> hvals(K key) {
        return this.await(this.c.hvals(key));
    }

    public Long incr(K key) {
        return this.await(this.c.incr(key));
    }

    public Long incrby(K key, long amount) {
        return this.await(this.c.incrby(key, amount));
    }

    public Double incrbyfloat(K key, double amount) {
        return this.await(this.c.incrbyfloat(key, amount));
    }

    public String info() {
        return this.await(this.c.info());
    }

    public String info(String section) {
        return this.await(this.c.info(section));
    }

    public List<K> keys(K pattern) {
        return this.await(this.c.keys(pattern));
    }

    public Date lastsave() {
        return this.await(this.c.lastsave());
    }

    public V lindex(K key, long index) {
        return this.await(this.c.lindex(key, index));
    }

    public Long linsert(K key, boolean before, V pivot, V value) {
        return this.await(this.c.linsert(key, before, pivot, value));
    }

    public Long llen(K key) {
        return this.await(this.c.llen(key));
    }

    public V lpop(K key) {
        return this.await(this.c.lpop(key));
    }

    public Long lpush(K key, V ... values) {
        return this.await(this.c.lpush(key, values));
    }

    public Long lpushx(K key, V value) {
        return this.await(this.c.lpushx(key, value));
    }

    public List<V> lrange(K key, long start, long stop) {
        return this.await(this.c.lrange(key, start, stop));
    }

    public Long lrem(K key, long count, V value) {
        return this.await(this.c.lrem(key, count, value));
    }

    public String lset(K key, long index, V value) {
        return this.await(this.c.lset(key, index, value));
    }

    public String ltrim(K key, long start, long stop) {
        return this.await(this.c.ltrim(key, start, stop));
    }

    public String migrate(String host, int port, K key, int db, long timeout) {
        return this.await(this.c.migrate(host, port, key, db, timeout));
    }

    public List<V> mget(K ... keys) {
        return this.await(this.c.mget(keys));
    }

    public Boolean move(K key, int db) {
        return this.await(this.c.move(key, db));
    }

    public String multi() {
        return this.await(this.c.multi());
    }

    public String mset(Map<K, V> map) {
        return this.await(this.c.mset(map));
    }

    public Boolean msetnx(Map<K, V> map) {
        return this.await(this.c.msetnx(map));
    }

    public String objectEncoding(K key) {
        return this.await(this.c.objectEncoding(key));
    }

    public Long objectIdletime(K key) {
        return this.await(this.c.objectIdletime(key));
    }

    public Long objectRefcount(K key) {
        return this.await(this.c.objectRefcount(key));
    }

    public Boolean persist(K key) {
        return this.await(this.c.persist(key));
    }

    public Boolean pexpire(K key, long milliseconds) {
        return this.await(this.c.pexpire(key, milliseconds));
    }

    public Boolean pexpireat(K key, Date timestamp) {
        return this.await(this.c.pexpireat(key, timestamp));
    }

    public Boolean pexpireat(K key, long timestamp) {
        return this.await(this.c.pexpireat(key, timestamp));
    }

    public String ping() {
        return this.await(this.c.ping());
    }

    public Long pttl(K key) {
        return this.await(this.c.pttl(key));
    }

    public Long publish(K channel, V message) {
        return this.await(this.c.publish(channel, message));
    }

    public String quit() {
        return this.await(this.c.quit());
    }

    public V randomkey() {
        return this.await(this.c.randomkey());
    }

    public String rename(K key, K newKey) {
        return this.await(this.c.rename(key, newKey));
    }

    public Boolean renamenx(K key, K newKey) {
        return this.await(this.c.renamenx(key, newKey));
    }

    public String restore(K key, long ttl, byte[] value) {
        return this.await(this.c.restore(key, ttl, value));
    }

    public V rpop(K key) {
        return this.await(this.c.rpop(key));
    }

    public V rpoplpush(K source, K destination) {
        return this.await(this.c.rpoplpush(source, destination));
    }

    public Long rpush(K key, V ... values) {
        return this.await(this.c.rpush(key, values));
    }

    public Long rpushx(K key, V value) {
        return this.await(this.c.rpushx(key, value));
    }

    public Long sadd(K key, V ... members) {
        return this.await(this.c.sadd(key, members));
    }

    public String save() {
        return this.await(this.c.save());
    }

    public Long scard(K key) {
        return this.await(this.c.scard(key));
    }

    public List<Boolean> scriptExists(String ... digests) {
        return this.await(this.c.scriptExists(digests));
    }

    public String scriptFlush() {
        return this.await(this.c.scriptFlush());
    }

    public String scriptKill() {
        return this.await(this.c.scriptKill());
    }

    public String scriptLoad(V script) {
        return this.await(this.c.scriptLoad(script));
    }

    public Set<V> sdiff(K ... keys) {
        return this.await(this.c.sdiff(keys));
    }

    public Long sdiffstore(K destination, K ... keys) {
        return this.await(this.c.sdiffstore(destination, keys));
    }

    public String select(int db) {
        return this.c.select(db);
    }

    public String set(K key, V value) {
        return this.await(this.c.set(key, value));
    }

    public Long setbit(K key, long offset, int value) {
        return this.await(this.c.setbit(key, offset, value));
    }

    public String setex(K key, long seconds, V value) {
        return this.await(this.c.setex(key, seconds, value));
    }

    public Boolean setnx(K key, V value) {
        return this.await(this.c.setnx(key, value));
    }

    public Long setrange(K key, long offset, V value) {
        return this.await(this.c.setrange(key, offset, value));
    }

    @Deprecated
    public void shutdown() {
        this.c.shutdown();
    }

    public void shutdown(boolean save) {
        this.c.shutdown(save);
    }

    public Set<V> sinter(K ... keys) {
        return this.await(this.c.sinter(keys));
    }

    public Long sinterstore(K destination, K ... keys) {
        return this.await(this.c.sinterstore(destination, keys));
    }

    public Boolean sismember(K key, V member) {
        return this.await(this.c.sismember(key, member));
    }

    public Boolean smove(K source, K destination, V member) {
        return this.await(this.c.smove(source, destination, member));
    }

    public String slaveof(String host, int port) {
        return this.await(this.c.slaveof(host, port));
    }

    public String slaveofNoOne() {
        return this.await(this.c.slaveofNoOne());
    }

    public List<Object> slowlogGet() {
        return this.await(this.c.slowlogGet());
    }

    public List<Object> slowlogGet(int count) {
        return this.await(this.c.slowlogGet(count));
    }

    public Long slowlogLen() {
        return this.await(this.c.slowlogLen());
    }

    public String slowlogReset() {
        return this.await(this.c.slowlogReset());
    }

    public Set<V> smembers(K key) {
        return this.await(this.c.smembers(key));
    }

    public List<V> sort(K key) {
        return this.await(this.c.sort(key));
    }

    public List<V> sort(K key, SortArgs sortArgs) {
        return this.await(this.c.sort(key, sortArgs));
    }

    public Long sortStore(K key, SortArgs sortArgs, K destination) {
        return this.await(this.c.sortStore(key, sortArgs, destination));
    }

    public V spop(K key) {
        return this.await(this.c.spop(key));
    }

    public V srandmember(K key) {
        return this.await(this.c.srandmember(key));
    }

    public Set<V> srandmember(K key, long count) {
        return this.await(this.c.srandmember(key, count));
    }

    public Long srem(K key, V ... members) {
        return this.await(this.c.srem(key, members));
    }

    public Set<V> sunion(K ... keys) {
        return this.await(this.c.sunion(keys));
    }

    public Long sunionstore(K destination, K ... keys) {
        return this.await(this.c.sunionstore(destination, keys));
    }

    public String sync() {
        return this.await(this.c.sync());
    }

    public Long strlen(K key) {
        return this.await(this.c.strlen(key));
    }

    public Long ttl(K key) {
        return this.await(this.c.ttl(key));
    }

    public String type(K key) {
        return this.await(this.c.type(key));
    }

    public String watch(K ... keys) {
        return this.await(this.c.watch(keys));
    }

    public String unwatch() {
        return this.await(this.c.unwatch());
    }

    public Long zadd(K key, double score, V member) {
        return this.await(this.c.zadd(key, score, member));
    }

    public Long zadd(K key, Object ... scoresAndValues) {
        return this.await(this.c.zadd(key, scoresAndValues));
    }

    public Long zcard(K key) {
        return this.await(this.c.zcard(key));
    }

    public Long zcount(K key, double min, double max) {
        return this.await(this.c.zcount(key, min, max));
    }

    public Long zcount(K key, String min, String max) {
        return this.await(this.c.zcount(key, min, max));
    }

    public Double zincrby(K key, double amount, K member) {
        return this.await(this.c.zincrby(key, amount, member));
    }

    public Long zinterstore(K destination, K ... keys) {
        return this.await(this.c.zinterstore(destination, keys));
    }

    public Long zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.await(this.c.zinterstore(destination, storeArgs, keys));
    }

    public List<V> zrange(K key, long start, long stop) {
        return this.await(this.c.zrange(key, start, stop));
    }

    public List<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        return this.await(this.c.zrangeWithScores(key, start, stop));
    }

    public List<V> zrangebyscore(K key, double min, double max) {
        return this.await(this.c.zrangebyscore(key, min, max));
    }

    public List<V> zrangebyscore(K key, String min, String max) {
        return this.await(this.c.zrangebyscore(key, min, max));
    }

    public List<V> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.await(this.c.zrangebyscore(key, min, max, offset, count));
    }

    public List<V> zrangebyscore(K key, String min, String max, long offset, long count) {
        return this.await(this.c.zrangebyscore(key, min, max, offset, count));
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.await(this.c.zrangebyscoreWithScores(key, min, max));
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max) {
        return this.await(this.c.zrangebyscoreWithScores(key, min, max));
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.await(this.c.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    public List<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        return this.await(this.c.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    public Long zrank(K key, V member) {
        return this.await(this.c.zrank(key, member));
    }

    public Long zrem(K key, V ... members) {
        return this.await(this.c.zrem(key, members));
    }

    public Long zremrangebyrank(K key, long start, long stop) {
        return this.await(this.c.zremrangebyrank(key, start, stop));
    }

    public Long zremrangebyscore(K key, double min, double max) {
        return this.await(this.c.zremrangebyscore(key, min, max));
    }

    public Long zremrangebyscore(K key, String min, String max) {
        return this.await(this.c.zremrangebyscore(key, min, max));
    }

    public List<V> zrevrange(K key, long start, long stop) {
        return this.await(this.c.zrevrange(key, start, stop));
    }

    public List<ScoredValue<V>> zrevrangeWithScores(K key, long start, long stop) {
        return this.await(this.c.zrevrangeWithScores(key, start, stop));
    }

    public List<V> zrevrangebyscore(K key, double max, double min) {
        return this.await(this.c.zrevrangebyscore(key, max, min));
    }

    public List<V> zrevrangebyscore(K key, String max, String min) {
        return this.await(this.c.zrevrangebyscore(key, max, min));
    }

    public List<V> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.await(this.c.zrevrangebyscore(key, max, min, offset, count));
    }

    public List<V> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        return this.await(this.c.zrevrangebyscore(key, max, min, offset, count));
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.await(this.c.zrevrangebyscoreWithScores(key, max, min));
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min) {
        return this.await(this.c.zrevrangebyscoreWithScores(key, max, min));
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.await(this.c.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    public List<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        return this.await(this.c.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    public Long zrevrank(K key, V member) {
        return this.await(this.c.zrevrank(key, member));
    }

    public Double zscore(K key, V member) {
        return this.await(this.c.zscore(key, member));
    }

    public Long zunionstore(K destination, K ... keys) {
        return this.await(this.c.zunionstore(destination, keys));
    }

    public Long zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.await(this.c.zunionstore(destination, storeArgs, keys));
    }

    public void close() {
        this.c.close();
    }

    public String digest(V script) {
        return this.c.digest(script);
    }

    private <T> T await(Future<T> future, long timeout, TimeUnit unit) {
        Command cmd = (Command)future;
        return this.c.await(cmd, timeout, unit);
    }

    private <T> T await(Future<T> future) {
        Command cmd = (Command)future;
        if (this.c.multi != null && cmd.type != CommandType.MULTI) {
            return null;
        }
        return this.c.await(cmd, this.timeout, this.unit);
    }
}

