/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.internal.assertion.AssertParameter;
import org.apache.commons.lang3.StringUtils;

public class MultiPartConfig
implements Config {
    private static final String DEFAULT_CONTROL_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "file";
    private static final String DEFAULT_SUBTYPE = "form-data";
    private final String defaultControlName;
    private final String defaultFileName;
    private final String defaultSubtype;
    private final boolean isUserConfigured;

    public MultiPartConfig() {
        this("file", "file", DEFAULT_SUBTYPE, false);
    }

    private MultiPartConfig(String defaultControlName, String defaultFileName, String defaultSubtype, boolean isUserConfigured) {
        this.defaultControlName = defaultControlName;
        this.defaultFileName = StringUtils.trimToNull((String)defaultFileName);
        this.defaultSubtype = StringUtils.trimToNull((String)defaultSubtype);
        AssertParameter.notNull((Object)this.defaultControlName, (String)"Default control name");
        AssertParameter.notNull((Object)this.defaultSubtype, (String)"Default subtype");
        this.isUserConfigured = isUserConfigured;
    }

    public MultiPartConfig defaultControlName(String defaultControlName) {
        return new MultiPartConfig(defaultControlName, this.defaultFileName, this.defaultSubtype, true);
    }

    public MultiPartConfig defaultFileName(String defaultFileName) {
        return new MultiPartConfig(this.defaultControlName, defaultFileName, this.defaultSubtype, true);
    }

    public MultiPartConfig defaultSubtype(String defaultSubtype) {
        return new MultiPartConfig(this.defaultControlName, this.defaultFileName, defaultSubtype, true);
    }

    public MultiPartConfig emptyDefaultFileName() {
        return new MultiPartConfig(this.defaultControlName, null, this.defaultSubtype, true);
    }

    public String defaultControlName() {
        return this.defaultControlName;
    }

    public String defaultFileName() {
        return this.defaultFileName;
    }

    public String defaultSubtype() {
        return this.defaultSubtype;
    }

    public boolean isUserConfigured() {
        return this.isUserConfigured;
    }

    public static MultiPartConfig multiPartConfig() {
        return new MultiPartConfig();
    }

    public MultiPartConfig and() {
        return this;
    }

    public MultiPartConfig with() {
        return this;
    }
}

