/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.JsonUtil;
import com.jayway.jsonpath.filter.FilterOutput;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;

public class ListPropertyFilter
extends JsonPathFilterBase {
    public static final Pattern PATTERN = Pattern.compile("\\[\\s?\\?\\s?\\(\\s?@\\.(\\w+)\\s?\\)\\s?\\]");
    private final String pathFragment;

    public ListPropertyFilter(String pathFragment) {
        this.pathFragment = pathFragment;
    }

    public FilterOutput apply(FilterOutput filterItems) {
        JSONArray result = new JSONArray();
        String prop = this.getFilterProperty();
        for (Object item : filterItems.getResultAsList()) {
            if (!JsonUtil.isMap(item) || !JsonUtil.toMap(item).containsKey(prop)) continue;
            result.add(item);
        }
        return new FilterOutput(result);
    }

    private String getFilterProperty() {
        Matcher matcher = PATTERN.matcher(this.pathFragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("invalid list filter property");
    }
}

