/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagUtil {
    private static Map<String, Character> ourCharacterEntities = new HashMap<String, Character>();

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        String result = "<" + tagName;
        result = tagValue == null || "".equals(tagValue) ? result + "/>" : result + ">" + XmlTagUtil.getCDATAQuote(tagValue) + "</" + tagName + ">";
        return result;
    }

    public static String[] getCharacterEntityNames() {
        Set<String> strings = ourCharacterEntities.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    public static Character getCharacterByEntityName(String entityName) {
        return ourCharacterEntities.get(entityName);
    }

    public static String escapeString(String str, boolean escapeWhiteSpace) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = "&nbsp;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuffer(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlTagUtil.getStartTagNameElement must not be null");
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag) {
        ASTNode current;
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlTagUtil.getEndTagNameElement must not be null");
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/util/XmlTagUtil.getTrimmedValueRange must not be null");
        }
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index;
        TextRange textRange = new TextRange(startOffset, startOffset + trimmed.length());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xml/util/XmlTagUtil.getTrimmedValueRange must not return null");
        }
        return textRange;
    }

    static {
        ourCharacterEntities.put("lt", new Character('<'));
        ourCharacterEntities.put("gt", new Character('>'));
        ourCharacterEntities.put("apos", new Character('\''));
        ourCharacterEntities.put("quot", new Character('\"'));
        ourCharacterEntities.put("nbsp", new Character('\u00a0'));
        ourCharacterEntities.put("amp", new Character('&'));
    }
}

